/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.IInvConfiguration;
import mekanism.common.ITileNetwork;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketConfigurationUpdate
implements IMessageHandler<ConfigurationUpdateMessage, IMessage> {
    public IMessage onMessage(ConfigurationUpdateMessage message, MessageContext context) {
        TileEntity tile = message.coord4D.getTileEntity((IBlockAccess)PacketHandler.getPlayer((MessageContext)context).field_70170_p);
        if (tile instanceof IInvConfiguration) {
            IInvConfiguration config = (IInvConfiguration)tile;
            if (message.packetType == ConfigurationPacket.EJECT) {
                config.getEjector().setEjecting(!config.getEjector().isEjecting());
            } else if (message.packetType == ConfigurationPacket.SIDE_DATA) {
                if (message.clickType == 0) {
                    MekanismUtils.incrementOutput((IInvConfiguration)tile, message.configIndex);
                } else if (message.clickType == 1) {
                    MekanismUtils.decrementOutput((IInvConfiguration)tile, message.configIndex);
                } else if (message.clickType == 2) {
                    ((IInvConfiguration)tile).getConfiguration()[message.configIndex] = 0;
                }
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(message.coord4D, ((ITileNetwork)tile).getNetworkedData(new ArrayList())), new Range4D(message.coord4D));
            } else if (message.packetType == ConfigurationPacket.EJECT_COLOR) {
                if (message.clickType == 0) {
                    config.getEjector().setOutputColor(TransporterUtils.increment(config.getEjector().getOutputColor()));
                } else if (message.clickType == 1) {
                    config.getEjector().setOutputColor(TransporterUtils.decrement(config.getEjector().getOutputColor()));
                } else if (message.clickType == 2) {
                    config.getEjector().setOutputColor(null);
                }
            } else if (message.packetType == ConfigurationPacket.INPUT_COLOR) {
                ForgeDirection side = ForgeDirection.getOrientation((int)message.inputSide);
                if (message.clickType == 0) {
                    config.getEjector().setInputColor(side, TransporterUtils.increment(config.getEjector().getInputColor(side)));
                } else if (message.clickType == 1) {
                    config.getEjector().setInputColor(side, TransporterUtils.decrement(config.getEjector().getInputColor(side)));
                } else if (message.clickType == 2) {
                    config.getEjector().setInputColor(side, null);
                }
            } else if (message.packetType == ConfigurationPacket.STRICT_INPUT) {
                config.getEjector().setStrictInput(!config.getEjector().hasStrictInput());
            }
            for (EntityPlayer p : ((TileEntityBasicBlock)((Object)config)).playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(message.coord4D, ((ITileNetwork)tile).getNetworkedData(new ArrayList())), (EntityPlayerMP)p);
            }
        }
        return null;
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT;

    }

    public static class ConfigurationUpdateMessage
    implements IMessage {
        public Coord4D coord4D;
        public int configIndex;
        public int inputSide;
        public int clickType;
        public ConfigurationPacket packetType;

        public ConfigurationUpdateMessage() {
        }

        public ConfigurationUpdateMessage(ConfigurationPacket type, Coord4D coord, int click, int extra) {
            this.packetType = type;
            this.coord4D = coord;
            if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                this.clickType = click;
            }
            if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                this.clickType = click;
                this.configIndex = extra;
            }
            if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                this.clickType = click;
                this.inputSide = extra;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            if (this.packetType != ConfigurationPacket.EJECT && this.packetType != ConfigurationPacket.STRICT_INPUT) {
                dataStream.writeInt(this.clickType);
            }
            if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                dataStream.writeInt(this.configIndex);
            }
            if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                dataStream.writeInt(this.inputSide);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ConfigurationPacket.values()[dataStream.readInt()];
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                this.clickType = dataStream.readInt();
                this.configIndex = dataStream.readInt();
            } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                this.clickType = dataStream.readInt();
            } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                this.clickType = dataStream.readInt();
                this.inputSide = dataStream.readInt();
            }
        }
    }
}

