/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class PacketEditFilter
implements IMessageHandler<EditFilterMessage, IMessage> {
    public IMessage onMessage(EditFilterMessage message, MessageContext context) {
        block6: {
            WorldServer worldServer;
            block7: {
                worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                if (worldServer == null) break block6;
                if (message.type != 0 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block7;
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                if (!sorter.filters.contains(message.tFilter)) {
                    return null;
                }
                int index = sorter.filters.indexOf(message.tFilter);
                sorter.filters.remove(index);
                if (!message.delete) {
                    sorter.filters.add(index, message.tEdited);
                }
                for (EntityPlayer iterPlayer : sorter.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(sorter), sorter.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
                }
                break block6;
            }
            if (message.type != 1 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block6;
            TileEntityDigitalMiner miner = (TileEntityDigitalMiner)message.coord4D.getTileEntity((IBlockAccess)worldServer);
            if (!miner.filters.contains(message.mFilter)) {
                return null;
            }
            int index = miner.filters.indexOf(message.mFilter);
            miner.filters.remove(index);
            if (!message.delete) {
                miner.filters.add(index, message.mEdited);
            }
            for (EntityPlayer iterPlayer : miner.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(miner), miner.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
            }
        }
        return null;
    }

    public static class EditFilterMessage
    implements IMessage {
        public Coord4D coord4D;
        public TransporterFilter tFilter;
        public TransporterFilter tEdited;
        public MinerFilter mFilter;
        public MinerFilter mEdited;
        public byte type = (byte)-1;
        public boolean delete;

        public EditFilterMessage() {
        }

        public EditFilterMessage(Coord4D coord, boolean deletion, Object filter, Object edited) {
            this.coord4D = coord;
            this.delete = deletion;
            if (filter instanceof TransporterFilter) {
                this.tFilter = (TransporterFilter)filter;
                if (!this.delete) {
                    this.tEdited = (TransporterFilter)edited;
                }
                this.type = 0;
            } else if (filter instanceof MinerFilter) {
                this.mFilter = (MinerFilter)filter;
                if (!this.delete) {
                    this.mEdited = (MinerFilter)edited;
                }
                this.type = 1;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeByte((int)this.type);
            dataStream.writeBoolean(this.delete);
            ArrayList data = new ArrayList();
            if (this.type == 0) {
                this.tFilter.write(data);
                if (!this.delete) {
                    this.tEdited.write(data);
                }
            } else if (this.type == 1) {
                this.mFilter.write(data);
                if (!this.delete) {
                    this.mEdited.write(data);
                }
            }
            PacketHandler.encode(data.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.type = dataStream.readByte();
            this.delete = dataStream.readBoolean();
            if (this.type == 0) {
                this.tFilter = TransporterFilter.readFromPacket(dataStream);
                if (!this.delete) {
                    this.tEdited = TransporterFilter.readFromPacket(dataStream);
                }
            } else if (this.type == 1) {
                this.mFilter = MinerFilter.readFromPacket(dataStream);
                if (!this.delete) {
                    this.mEdited = MinerFilter.readFromPacket(dataStream);
                }
            }
        }
    }
}

