/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.IElectricChest;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.InventoryElectricChest;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class PacketElectricChest
implements IMessageHandler<ElectricChestMessage, IMessage> {
    public IMessage onMessage(ElectricChestMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == ElectricChestPacketType.SERVER_OPEN) {
            try {
                if (message.isBlock) {
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                    if (message.useEnergy) {
                        tileEntity.setEnergy(tileEntity.getEnergy() - 100.0);
                    }
                    MekanismUtils.openElectricChestGui((EntityPlayerMP)player, tileEntity, null, true);
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        if (message.useEnergy) {
                            ((IEnergizedItem)stack.func_77973_b()).setEnergy(stack, ((IEnergizedItem)stack.func_77973_b()).getEnergy(stack) - 100.0);
                        }
                        InventoryElectricChest inventory = new InventoryElectricChest(player);
                        MekanismUtils.openElectricChestGui((EntityPlayerMP)player, null, (IInventory)inventory, false);
                    }
                }
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        } else if (message.packetType == ElectricChestPacketType.CLIENT_OPEN) {
            try {
                int x = message.coord4D != null ? message.coord4D.xCoord : 0;
                int y = message.coord4D != null ? message.coord4D.yCoord : 0;
                int z = message.coord4D != null ? message.coord4D.zCoord : 0;
                Mekanism.proxy.openElectricChest(player, message.guiType, message.windowId, message.isBlock, x, y, z);
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        } else if (message.packetType == ElectricChestPacketType.PASSWORD) {
            try {
                if (message.isBlock) {
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                    tileEntity.password = message.password;
                    tileEntity.authenticated = true;
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        ((IElectricChest)stack.func_77973_b()).setPassword(stack, message.password);
                        ((IElectricChest)stack.func_77973_b()).setAuthenticated(stack, true);
                    }
                }
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest password packet.");
                e.printStackTrace();
            }
        } else if (message.packetType == ElectricChestPacketType.LOCK) {
            try {
                if (message.isBlock) {
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                    tileEntity.locked = message.locked;
                    player.field_70170_p.func_147459_d(message.coord4D.xCoord, message.coord4D.yCoord, message.coord4D.zCoord, Mekanism.MachineBlock);
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        ((IElectricChest)stack.func_77973_b()).setLocked(stack, message.locked);
                    }
                }
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest password packet.");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static enum ElectricChestPacketType {
        LOCK,
        PASSWORD,
        CLIENT_OPEN,
        SERVER_OPEN;

    }

    public static class ElectricChestMessage
    implements IMessage {
        public ElectricChestPacketType packetType;
        public boolean isBlock;
        public boolean locked;
        public String password;
        public int guiType;
        public int windowId;
        public boolean useEnergy;
        public Coord4D coord4D;

        public ElectricChestMessage() {
        }

        public ElectricChestMessage(ElectricChestPacketType type, boolean b1, boolean b2, int i1, int i2, String s1, Coord4D c1) {
            this.packetType = type;
            switch (this.packetType) {
                case LOCK: {
                    this.locked = b1;
                    this.isBlock = b2;
                    if (!this.isBlock) break;
                    this.coord4D = c1;
                    break;
                }
                case PASSWORD: {
                    this.password = s1;
                    this.isBlock = b1;
                    if (!this.isBlock) break;
                    this.coord4D = c1;
                    break;
                }
                case CLIENT_OPEN: {
                    this.guiType = i1;
                    this.windowId = i2;
                    this.isBlock = b1;
                    if (!this.isBlock) break;
                    this.coord4D = c1;
                    break;
                }
                case SERVER_OPEN: {
                    this.useEnergy = b1;
                    this.isBlock = b2;
                    if (!this.isBlock) break;
                    this.coord4D = c1;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            switch (this.packetType) {
                case LOCK: {
                    dataStream.writeBoolean(this.locked);
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                    break;
                }
                case PASSWORD: {
                    PacketHandler.writeString(dataStream, this.password);
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                    break;
                }
                case CLIENT_OPEN: {
                    dataStream.writeInt(this.guiType);
                    dataStream.writeInt(this.windowId);
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                    break;
                }
                case SERVER_OPEN: {
                    dataStream.writeBoolean(this.useEnergy);
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ElectricChestPacketType.values()[dataStream.readInt()];
            if (this.packetType == ElectricChestPacketType.SERVER_OPEN) {
                this.useEnergy = dataStream.readBoolean();
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            } else if (this.packetType == ElectricChestPacketType.CLIENT_OPEN) {
                this.guiType = dataStream.readInt();
                this.windowId = dataStream.readInt();
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            } else if (this.packetType == ElectricChestPacketType.PASSWORD) {
                this.password = PacketHandler.readString(dataStream);
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            } else if (this.packetType == ElectricChestPacketType.LOCK) {
                this.locked = dataStream.readBoolean();
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            }
        }
    }
}

