/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class PacketNewFilter
implements IMessageHandler<NewFilterMessage, IMessage> {
    public IMessage onMessage(NewFilterMessage message, MessageContext context) {
        block2: {
            WorldServer worldServer;
            block3: {
                worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                if (worldServer == null) break block2;
                if (message.type != 0 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block3;
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                sorter.filters.add(message.tFilter);
                for (EntityPlayer iterPlayer : sorter.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(sorter), sorter.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
                }
                break block2;
            }
            if (message.type != 1 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block2;
            TileEntityDigitalMiner miner = (TileEntityDigitalMiner)message.coord4D.getTileEntity((IBlockAccess)worldServer);
            miner.filters.add(message.mFilter);
            for (EntityPlayer iterPlayer : miner.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(miner), miner.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
            }
        }
        return null;
    }

    public static class NewFilterMessage
    implements IMessage {
        public Coord4D coord4D;
        public TransporterFilter tFilter;
        public MinerFilter mFilter;
        public byte type = (byte)-1;

        public NewFilterMessage() {
        }

        public NewFilterMessage(Coord4D coord, Object filter) {
            this.coord4D = coord;
            if (filter instanceof TransporterFilter) {
                this.tFilter = (TransporterFilter)filter;
                this.type = 0;
            } else if (filter instanceof MinerFilter) {
                this.mFilter = (MinerFilter)filter;
                this.type = 1;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeByte((int)this.type);
            ArrayList data = new ArrayList();
            if (this.type == 0) {
                this.tFilter.write(data);
            } else if (this.type == 1) {
                this.mFilter.write(data);
            }
            PacketHandler.encode(data.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.type = dataStream.readByte();
            if (this.type == 0) {
                this.tFilter = TransporterFilter.readFromPacket(dataStream);
            } else if (this.type == 1) {
                this.mFilter = MinerFilter.readFromPacket(dataStream);
            }
        }
    }
}

