/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.IUpgradeManagement;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class PacketRemoveUpgrade
implements IMessageHandler<RemoveUpgradeMessage, IMessage> {
    public IMessage onMessage(RemoveUpgradeMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
        if (tileEntity instanceof IUpgradeManagement && tileEntity instanceof TileEntityBasicBlock) {
            IUpgradeManagement upgradeTile = (IUpgradeManagement)tileEntity;
            if (message.upgradeType == 0) {
                if (upgradeTile.getSpeedMultiplier(new Object[0]) > 0 && player.field_71071_by.func_70441_a(new ItemStack(Mekanism.SpeedUpgrade))) {
                    upgradeTile.setSpeedMultiplier(upgradeTile.getSpeedMultiplier(new Object[0]) - 1, new Object[0]);
                }
            } else if (message.upgradeType == 1 && upgradeTile.getEnergyMultiplier(new Object[0]) > 0 && player.field_71071_by.func_70441_a(new ItemStack(Mekanism.EnergyUpgrade))) {
                upgradeTile.setEnergyMultiplier(upgradeTile.getEnergyMultiplier(new Object[0]) - 1, new Object[0]);
            }
        }
        return null;
    }

    public static class RemoveUpgradeMessage
    implements IMessage {
        public Coord4D coord4D;
        public byte upgradeType;

        public RemoveUpgradeMessage() {
        }

        public RemoveUpgradeMessage(Coord4D coord, byte type) {
            this.coord4D = coord;
            this.upgradeType = type;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeByte((int)this.upgradeType);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.upgradeType = dataStream.readByte();
        }
    }
}

