/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class PacketTileEntity
implements IMessageHandler<TileEntityMessage, IMessage> {
    public IMessage onMessage(TileEntityMessage message, MessageContext context) {
        TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)PacketHandler.getPlayer((MessageContext)context).field_70170_p);
        if (tileEntity instanceof ITileNetwork) {
            try {
                ((ITileNetwork)tileEntity).handlePacketData(message.storedBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            message.storedBuffer.release();
        }
        return null;
    }

    public static class TileEntityMessage
    implements IMessage {
        public Coord4D coord4D;
        public ArrayList parameters;
        public ByteBuf storedBuffer = null;

        public TileEntityMessage() {
        }

        public TileEntityMessage(Coord4D coord, ArrayList params) {
            this.coord4D = coord;
            this.parameters = params;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            PacketHandler.encode(new Object[]{this.parameters}, dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.storedBuffer = dataStream.copy();
        }
    }
}

