/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.FluidNetwork;
import mekanism.common.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketTransmitterUpdate
implements IMessageHandler<TransmitterUpdateMessage, IMessage> {
    public IMessage onMessage(TransmitterUpdateMessage message, MessageContext context) {
        TileEntity tileEntity;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == PacketType.UPDATE) {
            TileEntity tileEntity2 = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity2 instanceof IGridTransmitter) {
                ((IGridTransmitter)tileEntity2).refreshTransmitterNetwork();
            }
        } else if (message.packetType == PacketType.ENERGY) {
            TileEntity tileEntity3 = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity3 instanceof IGridTransmitter) {
                ((EnergyNetwork)((IGridTransmitter)tileEntity3).getTransmitterNetwork()).clientEnergyScale = message.power;
            }
        } else if (message.packetType == PacketType.GAS) {
            TileEntity tileEntity4 = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity4 instanceof IGridTransmitter) {
                GasNetwork net = (GasNetwork)((IGridTransmitter)tileEntity4).getTransmitterNetwork();
                if (message.gasType != null) {
                    net.refGas = message.gasType;
                }
                net.gasStored = message.gasStack;
                net.didTransfer = message.didGasTransfer;
            }
        } else if (message.packetType == PacketType.FLUID && (tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p)) instanceof IGridTransmitter) {
            FluidNetwork net = (FluidNetwork)((IGridTransmitter)tileEntity).getTransmitterNetwork();
            if (message.fluidType != null) {
                net.refFluid = message.fluidType;
            }
            net.fluidStored = message.fluidStack;
            net.didTransfer = message.didFluidTransfer;
            net.fluidScale = net.getScale();
        }
        return null;
    }

    public static enum PacketType {
        UPDATE,
        ENERGY,
        GAS,
        FLUID;

    }

    public static class TransmitterUpdateMessage
    implements IMessage {
        public PacketType packetType;
        public Coord4D coord4D;
        public double power;
        public GasStack gasStack;
        public Gas gasType;
        public boolean didGasTransfer;
        public FluidStack fluidStack;
        public Fluid fluidType;
        public boolean didFluidTransfer;
        public int amount;

        public TransmitterUpdateMessage() {
        }

        public TransmitterUpdateMessage(PacketType type, Coord4D coord, Object ... data) {
            this.packetType = type;
            this.coord4D = coord;
            switch (this.packetType) {
                case ENERGY: {
                    this.power = (Double)data[0];
                    break;
                }
                case GAS: {
                    this.gasStack = (GasStack)data[0];
                    this.didGasTransfer = (Boolean)data[1];
                    break;
                }
                case FLUID: {
                    this.fluidStack = (FluidStack)data[0];
                    this.didFluidTransfer = (Boolean)data[1];
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            switch (this.packetType) {
                case ENERGY: {
                    dataStream.writeDouble(this.power);
                    break;
                }
                case GAS: {
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.getGas().getID() : -1);
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.amount : 0);
                    dataStream.writeBoolean(this.didGasTransfer);
                    break;
                }
                case FLUID: {
                    dataStream.writeInt(this.fluidStack != null ? this.fluidStack.getFluid().getID() : -1);
                    dataStream.writeInt(this.fluidStack != null ? this.fluidStack.amount : 0);
                    dataStream.writeBoolean(this.didFluidTransfer);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = PacketType.values()[dataStream.readInt()];
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            if (this.packetType == PacketType.ENERGY) {
                this.power = dataStream.readDouble();
            } else if (this.packetType == PacketType.GAS) {
                this.gasType = GasRegistry.getGas(dataStream.readInt());
                this.amount = dataStream.readInt();
                this.didGasTransfer = dataStream.readBoolean();
                if (this.gasType != null) {
                    this.gasStack = new GasStack(this.gasType, this.amount);
                }
            } else if (this.packetType == PacketType.FLUID) {
                int type = dataStream.readInt();
                this.fluidType = type != -1 ? FluidRegistry.getFluid((int)type) : null;
                this.amount = dataStream.readInt();
                this.didFluidTransfer = dataStream.readBoolean();
                if (this.fluidType != null) {
                    this.fluidStack = new FluidStack(this.fluidType, this.amount);
                }
            }
        }
    }
}

