/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.IEnergyCube;
import mekanism.common.IFactory;
import mekanism.common.IUpgradeManagement;
import mekanism.common.block.BlockMachine;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MekanismRecipe
implements IRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ItemStack output = null;
    private Object[] input = null;
    public int width = 0;
    public int height = 0;
    private boolean mirrored = true;

    public MekanismRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack itemstack;
        int i;
        ItemStack toReturn = this.output.func_77946_l();
        if (toReturn.func_77973_b() instanceof IEnergizedItem) {
            double energyFound = 0.0;
            for (i = 0; i < 9; ++i) {
                itemstack = inv.func_70301_a(i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IEnergizedItem)) continue;
                energyFound += ((IEnergizedItem)itemstack.func_77973_b()).getEnergy(itemstack);
            }
            ((IEnergizedItem)toReturn.func_77973_b()).setEnergy(toReturn, Math.min(((IEnergizedItem)toReturn.func_77973_b()).getMaxEnergy(toReturn), energyFound));
        }
        if (toReturn.func_77973_b() instanceof IGasItem) {
            GasStack gasFound = null;
            for (int i2 = 0; i2 < 9; ++i2) {
                GasStack stored;
                ItemStack itemstack2 = inv.func_70301_a(i2);
                if (itemstack2 == null || !(itemstack2.func_77973_b() instanceof IGasItem) || (stored = ((IGasItem)itemstack2.func_77973_b()).getGas(itemstack2)) == null) continue;
                if (!((IGasItem)toReturn.func_77973_b()).canReceiveGas(toReturn, stored.getGas())) {
                    return null;
                }
                if (gasFound == null) {
                    gasFound = stored;
                    continue;
                }
                if (gasFound.getGas() != stored.getGas()) {
                    return null;
                }
                gasFound.amount += stored.amount;
            }
            if (gasFound != null) {
                gasFound.amount = Math.min(((IGasItem)toReturn.func_77973_b()).getMaxGas(toReturn), gasFound.amount);
                ((IGasItem)toReturn.func_77973_b()).setGas(toReturn, gasFound);
            }
        }
        if (toReturn.func_77973_b() instanceof IUpgradeManagement && ((IUpgradeManagement)toReturn.func_77973_b()).supportsUpgrades(toReturn)) {
            int speedUpgrades = 0;
            int energyUpgrades = 0;
            for (i = 0; i < 9; ++i) {
                itemstack = inv.func_70301_a(i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IUpgradeManagement) || !((IUpgradeManagement)itemstack.func_77973_b()).supportsUpgrades(toReturn)) continue;
                speedUpgrades = Math.min(8, speedUpgrades + ((IUpgradeManagement)itemstack.func_77973_b()).getSpeedMultiplier(itemstack));
                energyUpgrades = Math.min(8, energyUpgrades + ((IUpgradeManagement)itemstack.func_77973_b()).getEnergyMultiplier(itemstack));
            }
            ((IUpgradeManagement)toReturn.func_77973_b()).setSpeedMultiplier(speedUpgrades, toReturn);
            ((IUpgradeManagement)toReturn.func_77973_b()).setEnergyMultiplier(energyUpgrades, toReturn);
        }
        return toReturn;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (this.checkItemEquals((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (ItemStack item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        if (input == null && target == null) {
            return true;
        }
        if (target.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        if (!(target.func_77973_b() instanceof IEnergizedItem || input.func_77973_b() instanceof IEnergizedItem || target.func_77973_b() instanceof IGasItem || input.func_77973_b() instanceof IGasItem)) {
            if (target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
        } else {
            if (target.func_77973_b() instanceof IEnergizedItem && input.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)target.func_77973_b()).isMetadataSpecific(target) && ((IEnergizedItem)input.func_77973_b()).isMetadataSpecific(input) && target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
            if (target.func_77973_b() instanceof IGasItem && input.func_77973_b() instanceof IGasItem && ((IGasItem)target.func_77973_b()).isMetadataSpecific(target) && ((IGasItem)input.func_77973_b()).isMetadataSpecific(input) && target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
            if (target.func_77973_b() instanceof IEnergyCube && input.func_77973_b() instanceof IEnergyCube ? ((IEnergyCube)target.func_77973_b()).getEnergyCubeTier(target) != ((IEnergyCube)input.func_77973_b()).getEnergyCubeTier(input) : target.func_77973_b() instanceof IFactory && input.func_77973_b() instanceof IFactory && MekanismRecipe.isFactory(target) && MekanismRecipe.isFactory(input) && ((IFactory)target.func_77973_b()).getRecipeType(target) != ((IFactory)input.func_77973_b()).getRecipeType(input)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFactory(ItemStack stack) {
        return BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.BASIC_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ADVANCED_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELITE_FACTORY;
    }

    public MekanismRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

