/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.AdvancedInput;
import mekanism.api.ChanceOutput;
import mekanism.api.ChemicalPair;
import mekanism.api.PressurizedProducts;
import mekanism.api.PressurizedReactants;
import mekanism.api.PressurizedRecipe;
import mekanism.api.StackUtils;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.infuse.InfusionInput;
import mekanism.api.infuse.InfusionOutput;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public final class RecipeHandler {
    public static void addRecipe(Recipe recipe, Object input, Object output) {
        recipe.put(input, output);
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        Recipe.ENRICHMENT_CHAMBER.put(input, output);
    }

    public static void addOsmiumCompressorRecipe(ItemStack input, ItemStack output) {
        Recipe.OSMIUM_COMPRESSOR.put(new AdvancedInput(input, GasRegistry.getGas("liquidOsmium")), output);
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack output) {
        Recipe.COMBINER.put(new AdvancedInput(input, GasRegistry.getGas("liquidStone")), output);
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        Recipe.CRUSHER.put(input, output);
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        Recipe.PURIFICATION_CHAMBER.put(new AdvancedInput(input, GasRegistry.getGas("oxygen")), output);
    }

    public static void addMetallurgicInfuserRecipe(InfusionInput input, ItemStack output) {
        Recipe.METALLURGIC_INFUSER.put(input, InfusionOutput.getInfusion(input, output));
    }

    public static void addChemicalInfuserRecipe(ChemicalPair input, GasStack output) {
        Recipe.CHEMICAL_INFUSER.put(input, output);
    }

    public static void addChemicalOxidizerRecipe(ItemStack input, GasStack output) {
        Recipe.CHEMICAL_OXIDIZER.put(input, output);
    }

    public static void addChemicalInjectionChamberRecipe(AdvancedInput input, ItemStack output) {
        Recipe.CHEMICAL_INJECTION_CHAMBER.put(input, output);
    }

    public static void addElectrolyticSeparatorRecipe(FluidStack fluid, ChemicalPair products) {
        Recipe.ELECTROLYTIC_SEPARATOR.put(fluid, products);
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ChanceOutput output) {
        Recipe.PRECISION_SAWMILL.put(input, output);
    }

    public static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        Recipe.CHEMICAL_DISSOLUTION_CHAMBER.put(input, output);
    }

    public static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        Recipe.CHEMICAL_WASHER.put(input, output);
    }

    public static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        Recipe.CHEMICAL_CRYSTALLIZER.put(input, output);
    }

    public static void addPRCRecipe(PressurizedReactants input, PressurizedProducts output, double extraEnergy, int ticks) {
        PressurizedRecipe recipe = new PressurizedRecipe(input, extraEnergy, output, ticks);
        Recipe.PRESSURIZED_REACTION_CHAMBER.put(input, recipe);
    }

    public static InfusionOutput getMetallurgicInfuserOutput(InfusionInput infusion, boolean stackDecrease) {
        if (infusion != null && infusion.inputStack != null) {
            HashMap recipes = Recipe.METALLURGIC_INFUSER.get();
            for (Map.Entry entry : recipes.entrySet()) {
                InfusionInput input = (InfusionInput)entry.getKey();
                if (!StackUtils.equalsWildcard(input.inputStack, infusion.inputStack) || infusion.inputStack.field_77994_a < input.inputStack.field_77994_a || infusion.infusionType != input.infusionType) continue;
                if (stackDecrease) {
                    infusion.inputStack.field_77994_a -= ((InfusionInput)entry.getKey()).inputStack.field_77994_a;
                }
                return ((InfusionOutput)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static GasStack getChemicalInfuserOutput(GasTank leftTank, GasTank rightTank, boolean doRemove) {
        ChemicalPair input = new ChemicalPair(leftTank.getGas(), rightTank.getGas());
        if (input.isValid()) {
            HashMap recipes = Recipe.CHEMICAL_INFUSER.get();
            for (Map.Entry entry : recipes.entrySet()) {
                ChemicalPair key = (ChemicalPair)entry.getKey();
                if (!key.meetsInput(input)) continue;
                if (doRemove) {
                    key.draw(leftTank, rightTank);
                }
                return ((GasStack)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static ItemStack getChemicalCrystallizerOutput(GasTank gasTank, boolean removeGas) {
        GasStack gas = gasTank.getGas();
        if (gas != null) {
            HashMap recipes = Recipe.CHEMICAL_CRYSTALLIZER.get();
            for (Map.Entry entry : recipes.entrySet()) {
                GasStack key = (GasStack)entry.getKey();
                if (key == null || key.getGas() != gas.getGas() || gas.amount < key.amount) continue;
                gasTank.draw(key.amount, removeGas);
                return ((ItemStack)entry.getValue()).func_77946_l();
            }
        }
        return null;
    }

    public static GasStack getChemicalWasherOutput(GasTank gasTank, boolean removeGas) {
        GasStack gas = gasTank.getGas();
        if (gas != null) {
            HashMap recipes = Recipe.CHEMICAL_WASHER.get();
            for (Map.Entry entry : recipes.entrySet()) {
                GasStack key = (GasStack)entry.getKey();
                if (key == null || key.getGas() != gas.getGas() || gas.amount < key.amount) continue;
                gasTank.draw(key.amount, removeGas);
                return ((GasStack)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static GasStack getItemToGasOutput(ItemStack itemstack, boolean stackDecrease, HashMap<ItemStack, GasStack> recipes) {
        if (itemstack != null) {
            for (Map.Entry<ItemStack, GasStack> entry : recipes.entrySet()) {
                ItemStack stack = entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack) || itemstack.field_77994_a < stack.field_77994_a) continue;
                if (stackDecrease) {
                    itemstack.field_77994_a -= stack.field_77994_a;
                }
                return entry.getValue().copy();
            }
        }
        return null;
    }

    public static ChanceOutput getChanceOutput(ItemStack itemstack, boolean stackDecrease, Map<ItemStack, ChanceOutput> recipes) {
        if (itemstack != null) {
            for (Map.Entry<ItemStack, ChanceOutput> entry : recipes.entrySet()) {
                ItemStack stack = entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack) || itemstack.field_77994_a < stack.field_77994_a) continue;
                if (stackDecrease) {
                    itemstack.field_77994_a -= stack.field_77994_a;
                }
                return entry.getValue().copy();
            }
        }
        return null;
    }

    public static ItemStack getOutput(ItemStack itemstack, boolean stackDecrease, Map<ItemStack, ItemStack> recipes) {
        if (itemstack != null) {
            for (Map.Entry<ItemStack, ItemStack> entry : recipes.entrySet()) {
                ItemStack stack = entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack) || itemstack.field_77994_a < stack.field_77994_a) continue;
                if (stackDecrease) {
                    itemstack.field_77994_a -= stack.field_77994_a;
                }
                return entry.getValue().func_77946_l();
            }
        }
        return null;
    }

    public static ItemStack getOutput(AdvancedInput input, boolean stackDecrease, Map<AdvancedInput, ItemStack> recipes) {
        if (input != null && input.isValid()) {
            for (Map.Entry<AdvancedInput, ItemStack> entry : recipes.entrySet()) {
                if (!entry.getKey().matches(input)) continue;
                if (stackDecrease) {
                    input.itemStack.field_77994_a -= entry.getKey().itemStack.field_77994_a;
                }
                return entry.getValue().func_77946_l();
            }
        }
        return null;
    }

    public static ChemicalPair getElectrolyticSeparatorOutput(FluidTank fluidTank, boolean doRemove) {
        FluidStack fluid = fluidTank.getFluid();
        if (fluid != null) {
            HashMap recipes = Recipe.ELECTROLYTIC_SEPARATOR.get();
            for (Map.Entry entry : recipes.entrySet()) {
                FluidStack key = (FluidStack)entry.getKey();
                if (!fluid.containsFluid(key)) continue;
                fluidTank.drain(key.amount, doRemove);
                return ((ChemicalPair)entry.getValue()).copy();
            }
        }
        return null;
    }

    public static PressurizedRecipe getPRCOutput(ItemStack inputItem, FluidTank inputFluidTank, GasTank inputGasTank) {
        FluidStack inputFluid = inputFluidTank.getFluid();
        GasStack inputGas = inputGasTank.getGas();
        if (inputFluid != null && inputGas != null) {
            HashMap recipes = Recipe.PRESSURIZED_REACTION_CHAMBER.get();
            for (PressurizedRecipe recipe : recipes.values()) {
                PressurizedReactants reactants = recipe.reactants;
                if (!reactants.meetsInput(inputItem, inputFluid, inputGas)) continue;
                return recipe.copy();
            }
        }
        return null;
    }

    public static boolean isInRecipe(ItemStack itemstack, Map<ItemStack, ItemStack> recipes) {
        if (itemstack != null) {
            for (Map.Entry<ItemStack, ItemStack> entry : recipes.entrySet()) {
                ItemStack stack = entry.getKey();
                if (!StackUtils.equalsWildcard(stack, itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInPressurizedRecipe(ItemStack stack) {
        if (stack != null) {
            for (PressurizedReactants key : Recipe.PRESSURIZED_REACTION_CHAMBER.get().keySet()) {
                if (!key.containsType(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Recipe {
        ENRICHMENT_CHAMBER(new HashMap<K, V>()),
        OSMIUM_COMPRESSOR(new HashMap<K, V>()),
        COMBINER(new HashMap<K, V>()),
        CRUSHER(new HashMap<K, V>()),
        PURIFICATION_CHAMBER(new HashMap<K, V>()),
        METALLURGIC_INFUSER(new HashMap<K, V>()),
        CHEMICAL_INFUSER(new HashMap<K, V>()),
        CHEMICAL_OXIDIZER(new HashMap<K, V>()),
        CHEMICAL_INJECTION_CHAMBER(new HashMap<K, V>()),
        ELECTROLYTIC_SEPARATOR(new HashMap<K, V>()),
        PRECISION_SAWMILL(new HashMap<K, V>()),
        CHEMICAL_DISSOLUTION_CHAMBER(new HashMap<K, V>()),
        CHEMICAL_WASHER(new HashMap<K, V>()),
        CHEMICAL_CRYSTALLIZER(new HashMap<K, V>()),
        PRESSURIZED_REACTION_CHAMBER(new HashMap<K, V>());

        private HashMap recipes;

        private Recipe(HashMap map) {
            this.recipes = map;
        }

        public void put(Object input, Object output) {
            this.recipes.put(input, output);
        }

        public boolean containsRecipe(ItemStack input) {
            for (Map.Entry obj : this.get().entrySet()) {
                ItemStack stack;
                Map.Entry entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof ItemStack ? StackUtils.equalsWildcard(stack = (ItemStack)entry.getKey(), input) : (entry.getKey() instanceof FluidStack ? ((FluidStack)entry.getKey()).isFluidEqual(input) : entry.getKey() instanceof AdvancedInput && StackUtils.equalsWildcard(stack = ((AdvancedInput)entry.getKey()).itemStack, input)))) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Fluid input) {
            for (Map.Entry obj : this.get().entrySet()) {
                Map.Entry entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof FluidStack) || ((FluidStack)entry.getKey()).getFluid() != input) continue;
                return true;
            }
            return false;
        }

        public HashMap get() {
            return this.recipes;
        }
    }
}

