/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tank;

import mekanism.api.Coord4D;
import mekanism.common.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class DynamicFluidTank
implements IFluidTank {
    public TileEntityDynamicTank dynamicTank;

    public DynamicFluidTank(TileEntityDynamicTank tileEntity) {
        this.dynamicTank = tileEntity;
    }

    public FluidStack getFluid() {
        return this.dynamicTank.structure != null ? this.dynamicTank.structure.fluidStored : null;
    }

    public int getCapacity() {
        return this.dynamicTank.structure != null ? this.dynamicTank.structure.volume * 16000 : 0;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.func_145831_w().field_72995_K) {
            if (resource == null || resource.fluidID <= 0) {
                return 0;
            }
            if (this.dynamicTank.structure.fluidStored == null || this.dynamicTank.structure.fluidStored.fluidID <= 0) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        this.dynamicTank.structure.fluidStored = resource.copy();
                    }
                    if (resource.amount > 0 && doFill) {
                        MekanismUtils.saveChunk(this.dynamicTank);
                        this.updateValveData(true);
                        this.dynamicTank.sendPacketToRenderer();
                        this.updateValveData(false);
                    }
                    return resource.amount;
                }
                if (doFill) {
                    this.dynamicTank.structure.fluidStored = resource.copy();
                    this.dynamicTank.structure.fluidStored.amount = this.getCapacity();
                }
                if (this.getCapacity() > 0 && doFill) {
                    MekanismUtils.saveChunk(this.dynamicTank);
                    this.updateValveData(true);
                    this.dynamicTank.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return this.getCapacity();
            }
            if (!this.dynamicTank.structure.fluidStored.isFluidEqual(resource)) {
                return 0;
            }
            int space = this.getCapacity() - this.dynamicTank.structure.fluidStored.amount;
            if (resource.amount <= space) {
                if (doFill) {
                    this.dynamicTank.structure.fluidStored.amount += resource.amount;
                }
                if (resource.amount > 0 && doFill) {
                    MekanismUtils.saveChunk(this.dynamicTank);
                    this.updateValveData(true);
                    this.dynamicTank.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return resource.amount;
            }
            if (doFill) {
                this.dynamicTank.structure.fluidStored.amount = this.getCapacity();
            }
            if (space > 0 && doFill) {
                MekanismUtils.saveChunk(this.dynamicTank);
                this.updateValveData(true);
                this.dynamicTank.sendPacketToRenderer();
                this.updateValveData(false);
            }
            return space;
        }
        return 0;
    }

    public void updateValveData(boolean value) {
        if (this.dynamicTank.structure != null) {
            for (SynchronizedTankData.ValveData data : this.dynamicTank.structure.valves) {
                if (!data.location.equals(Coord4D.get(this.dynamicTank))) continue;
                data.serverFluid = value;
            }
        }
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.func_145831_w().field_72995_K) {
            if (this.dynamicTank.structure.fluidStored == null || this.dynamicTank.structure.fluidStored.fluidID <= 0) {
                return null;
            }
            if (this.dynamicTank.structure.fluidStored.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (this.dynamicTank.structure.fluidStored.amount < used) {
                used = this.dynamicTank.structure.fluidStored.amount;
            }
            if (doDrain) {
                this.dynamicTank.structure.fluidStored.amount -= used;
            }
            FluidStack drained = new FluidStack(this.dynamicTank.structure.fluidStored.fluidID, used);
            if (this.dynamicTank.structure.fluidStored.amount <= 0) {
                this.dynamicTank.structure.fluidStored = null;
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk(this.dynamicTank);
                this.dynamicTank.sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getFluidAmount() {
        if (this.dynamicTank.structure != null) {
            return this.dynamicTank.structure.fluidStored.amount;
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

