/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import mekanism.api.AdvancedInput;
import mekanism.api.EnumColor;
import mekanism.api.StackUtils;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAdvancedElectricMachine
extends TileEntityBasicMachine
implements IGasHandler,
ITubeConnection {
    public int SECONDARY_ENERGY_PER_TICK;
    public static int MAX_GAS = 200;
    public GasTank gasTank;

    public TileEntityAdvancedElectricMachine(String soundPath, String name, double perTick, int secondaryPerTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiAdvancedMachine.png"), perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{3}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{4}));
        this.sideConfig = new byte[]{2, 1, 0, 4, 5, 3};
        this.gasTank = new GasTank(MAX_GAS);
        this.inventory = new ItemStack[5];
        this.SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.upgradeComponent = new TileComponentUpgrade(this, 4);
        this.ejectorComponent = new TileComponentEjector(this, (SideData)this.sideOutputs.get(3));
    }

    public abstract GasStack getItemGas(ItemStack var1);

    public abstract boolean isValidGas(Gas var1);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            this.handleSecondaryFuel();
            boolean changed = false;
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK) && this.gasTank.getStored() >= MekanismUtils.getSecondaryEnergyPerTick(this, this.SECONDARY_ENERGY_PER_TICK)) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                }
                this.gasTank.draw(MekanismUtils.getSecondaryEnergyPerTick(this, this.SECONDARY_ENERGY_PER_TICK), true);
                this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK);
            } else if (this.prevEnergy >= this.getEnergy()) {
                changed = true;
                this.setActive(false);
            }
            if (changed && !this.canOperate() && !this.hasRecipe(this.inventory[0])) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    private boolean hasRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (Map.Entry obj : this.getRecipes().entrySet()) {
            if (!(obj.getKey() instanceof AdvancedInput)) continue;
            Map.Entry entry = obj;
            ItemStack stack = ((AdvancedInput)entry.getKey()).itemStack;
            if (!StackUtils.equalsWildcard(stack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public void handleSecondaryFuel() {
        if (this.inventory[1] != null) {
            GasStack stack = this.getItemGas(this.inventory[1]);
            int gasNeeded = this.gasTank.getNeeded();
            if (stack != null && stack.amount <= gasNeeded) {
                this.gasTank.receive(stack, true);
                --this.inventory[1].field_77994_a;
                if (this.inventory[1].field_77994_a == 0) {
                    this.inventory[1] = null;
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 4) {
            return itemstack.func_77973_b() == Mekanism.SpeedUpgrade || itemstack.func_77973_b() == Mekanism.EnergyUpgrade;
        }
        if (slotID == 0) {
            return this.hasRecipe(itemstack);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 1) {
            return this.getItemGas(itemstack) != null;
        }
        return false;
    }

    @Override
    public void operate() {
        ItemStack itemstack = RecipeHandler.getOutput(new AdvancedInput(this.inventory[0], this.gasTank.getGas().getGas()), true, this.getRecipes());
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null || this.gasTank.getGas() == null) {
            return false;
        }
        ItemStack itemstack = RecipeHandler.getOutput(new AdvancedInput(this.inventory[0], this.gasTank.getGas().getGas()), false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemstack.field_77994_a <= this.inventory[2].func_77976_d();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return false;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.gasTank.getStored()};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate()};
            }
            case 6: {
                return new Object[]{MekanismUtils.getMaxEnergy(this, this.getMaxEnergy())};
            }
            case 7: {
                return new Object[]{MekanismUtils.getMaxEnergy(this, this.getMaxEnergy()) - this.getEnergy()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

