/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IEjector;
import mekanism.common.IElectricMachine;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public abstract class TileEntityBasicMachine
extends TileEntityElectricBlock
implements IElectricMachine,
IPeripheral,
IActiveState,
IInvConfiguration,
IUpgradeTile,
IHasSound,
IRedstoneControl {
    public byte[] sideConfig;
    public ArrayList<SideData> sideOutputs = new ArrayList();
    public String soundURL;
    public double ENERGY_PER_TICK;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED;
    public int updateDelay;
    public boolean isActive;
    public boolean clientActive;
    public ResourceLocation guiLocation;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public double prevEnergy;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;

    public TileEntityBasicMachine(String soundPath, String name, ResourceLocation location, double perTick, int ticksRequired, double maxEnergy) {
        super(name, maxEnergy);
        this.ENERGY_PER_TICK = perTick;
        this.TICKS_REQUIRED = ticksRequired;
        this.soundURL = soundPath;
        this.guiLocation = location;
        this.isActive = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.operatingTicks = dataStream.readInt();
        this.clientActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        for (int i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.sideConfig);
        return data;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)MekanismUtils.getTicks(this, this.TICKS_REQUIRED);
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this, this.MAX_ELECTRICITY);
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)]).availableSlots;
    }

    @Override
    public ArrayList<SideData> getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return this.soundURL;
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }
}

