/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChargepad
extends TileEntityElectricBlock
implements IActiveState,
IHasSound {
    public boolean isActive;
    public boolean prevActive;
    public Random random = new Random();

    public TileEntityChargepad() {
        super("Chargepad", BlockMachine.MachineType.CHARGEPAD.baseEnergy);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.isActive = false;
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.2), (double)(this.field_145849_e + 1)));
            block0: for (EntityLivingBase entity : entities) {
                if (entity instanceof EntityPlayer || entity instanceof EntityRobit) {
                    this.isActive = true;
                }
                if (!(this.getEnergy() > 0.0)) continue;
                if (entity instanceof EntityRobit) {
                    EntityRobit robit = (EntityRobit)entity;
                    double canGive = Math.min(this.getEnergy(), 1000.0);
                    double toGive = Math.min(robit.MAX_ELECTRICITY - robit.getEnergy(), canGive);
                    robit.setEnergy(robit.getEnergy() + toGive);
                    this.setEnergy(this.getEnergy() - toGive);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                double prevEnergy = this.getEnergy();
                for (ItemStack itemstack : player.field_71071_by.field_70460_b) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) break;
                }
                for (ItemStack itemstack : player.field_71071_by.field_70462_a) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) continue block0;
                }
            }
            if (this.prevActive != this.isActive) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.1, (double)this.field_145849_e + 0.5, "random.click", 0.3f, this.isActive ? 0.6f : 0.5f);
                this.setActive(this.isActive);
            }
        } else {
            Mekanism.proxy.registerSound(this);
            if (this.isActive) {
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + this.random.nextDouble(), (double)this.field_145848_d + 0.15, (double)this.field_145849_e + this.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void chargeItemStack(ItemStack itemstack) {
        if (itemstack != null) {
            if (itemstack.func_77973_b() instanceof IEnergizedItem) {
                this.setEnergy(this.getEnergy() - EnergizedItemManager.charge(itemstack, this.getEnergy()));
            } else if (MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem) {
                double sent = ElectricItem.manager.charge(itemstack, (double)((int)(this.getEnergy() * Mekanism.TO_IC2)), 4, true, false) * Mekanism.FROM_IC2;
                this.setEnergy(this.getEnergy() - sent);
            } else if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)itemstack.func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemstack)), (double)(item.getMaxEnergyStored(itemstack) - item.getEnergyStored(itemstack))));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, this.getEnergy() * Mekanism.TO_TE));
                this.setEnergy(this.getEnergy() - (double)item.receiveEnergy(itemstack, toTransfer, false) * Mekanism.FROM_TE);
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    @Override
    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(ForgeDirection.DOWN, ForgeDirection.getOrientation((int)this.facing).getOpposite());
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
        }
        this.prevActive = active;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public String getSoundPath() {
        return "Chargepad.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 0.4f;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }
}

