/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISustainedData;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChemicalOxidizer
extends TileEntityElectricBlock
implements IActiveState,
ITubeConnection,
IRedstoneControl,
IHasSound,
IUpgradeTile,
ISustainedData {
    public GasTank gasTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED = 100;
    public final double ENERGY_USAGE = Mekanism.rotaryCondensentratorUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);

    public TileEntityChemicalOxidizer() {
        super("ChemicalOxidizer", BlockMachine.MachineType.CHEMICAL_OXIDIZER.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(1, this);
            if (this.inventory[2] != null && this.gasTank.getGas() != null) {
                this.gasTank.draw(GasTransmission.addGas(this.inventory[2], this.gasTank.getGas()), true);
            }
            if (this.canOperate() && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_USAGE) && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - MekanismUtils.getEnergyPerTick(this, this.ENERGY_USAGE));
                if (this.operatingTicks < MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                } else {
                    GasStack stack = RecipeHandler.getItemToGasOutput(this.inventory[0], true, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get());
                    this.gasTank.receive(stack, true);
                    this.operatingTicks = 0;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    this.func_70296_d();
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            if (this.gasTank.getGas() != null) {
                GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.gasTank.getGas().getGas())) {
                    this.gasTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend), true);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.getItemToGasOutput(itemstack, false, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get()) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == 0 || side == 1) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)MekanismUtils.getTicks(this, this.TICKS_REQUIRED);
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        GasStack stack = RecipeHandler.getItemToGasOutput(this.inventory[0], false, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get());
        return stack != null && (this.gasTank.getGas() == null || this.gasTank.getGas().getGas() == stack.getGas() && this.gasTank.getNeeded() >= stack.amount);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.operatingTicks = dataStream.readInt();
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.operatingTicks);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this, this.MAX_ELECTRICITY);
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getGas() != null ? this.gasTank.getStored() * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public String getSoundPath() {
        return "ChemicalInfuser.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.gasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("gasTank", (NBTBase)this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.gasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("gasTank")));
    }
}

