/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.IFluidContainerManager;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tank.DynamicTankCache;
import mekanism.common.tank.SynchronizedTankData;
import mekanism.common.tank.TankUpdateProtocol;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityDynamicTank
extends TileEntityContainerBlock
implements IFluidContainerManager {
    public int inventoryID = -1;
    public SynchronizedTankData structure;
    public DynamicTankCache cachedData = new DynamicTankCache();
    public boolean sendStructure;
    public boolean prevStructure;
    public boolean clientHasStructure;
    public Map<SynchronizedTankData.ValveData, Integer> valveViewing = new HashMap<SynchronizedTankData.ValveData, Integer>();
    public int clientCapacity;
    public boolean isRendering;
    public float prevScale;

    public TileEntityDynamicTank() {
        this("DynamicTank");
    }

    public TileEntityDynamicTank(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    public void update() {
        if (!(this.field_145850_b.field_72995_K || this.structure != null && this.structure.didTick)) {
            new TankUpdateProtocol(this).updateTanks();
            if (this.structure != null) {
                this.structure.didTick = true;
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.structure = new SynchronizedTankData();
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering) {
                float targetScale;
                for (SynchronizedTankData.ValveData data : this.valveViewing.keySet()) {
                    if (this.valveViewing.get(data) <= 0) continue;
                    this.valveViewing.put(data, this.valveViewing.get(data) - 1);
                }
                if (!this.prevStructure) {
                    Mekanism.proxy.doTankAnimation(this);
                }
                if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.structure.fluidStored != null ? this.structure.fluidStored.amount : 0) / (float)this.clientCapacity)) > 0.01) {
                    this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
                }
            }
            this.prevStructure = this.clientHasStructure;
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData data : this.valveViewing.keySet()) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (this.playersUsing.size() > 0 && (this.field_145850_b.field_72995_K && !this.clientHasStructure || !this.field_145850_b.field_72995_K && this.structure == null)) {
            for (EntityPlayer player : this.playersUsing) {
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.isRendering = false;
            }
            if (this.inventoryID != -1 && this.structure == null) {
                MekanismUtils.updateCache(this.inventoryID, this.cachedData, this);
            }
            if (this.structure == null && this.ticker == 5) {
                this.update();
            }
            if (this.prevStructure != (this.structure != null)) {
                if (this.structure != null && !this.structure.hasRenderer) {
                    this.structure.hasRenderer = true;
                    this.isRendering = true;
                    this.sendStructure = true;
                }
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    Coord4D obj = Coord4D.get(this).getFromSide(side);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || obj.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityDynamicTank) continue;
                    obj.getBlock((IBlockAccess)this.field_145850_b).onNeighborChange((IBlockAccess)this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            boolean bl = this.prevStructure = this.structure != null;
            if (this.structure != null) {
                this.structure.didTick = false;
                if (this.inventoryID != -1) {
                    this.cachedData.sync(this.structure);
                    MekanismUtils.updateCache(this.inventoryID, this.cachedData, this);
                }
                this.manageInventory();
            }
        }
    }

    public void manageInventory() {
        int max = this.structure.volume * 16000;
        if (this.structure.inventory[0] != null) {
            if (this.structure.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                if (this.structure.editMode == FluidContainerUtils.ContainerEditMode.FILL && this.structure.fluidStored != null) {
                    int prev = this.structure.fluidStored.amount;
                    this.structure.fluidStored.amount -= FluidContainerUtils.insertFluid(this.structure.fluidStored, this.structure.inventory[0]);
                    if ((prev == this.structure.fluidStored.amount || this.structure.fluidStored.amount == 0) && this.structure.inventory[1] == null) {
                        this.structure.inventory[1] = this.structure.inventory[0].func_77946_l();
                        this.structure.inventory[0] = null;
                        this.func_70296_d();
                    }
                    if (this.structure.fluidStored.amount == 0) {
                        this.structure.fluidStored = null;
                    }
                } else if (this.structure.editMode == FluidContainerUtils.ContainerEditMode.EMPTY) {
                    int newStored;
                    if (this.structure.fluidStored != null) {
                        FluidStack received = FluidContainerUtils.extractFluid(max - this.structure.fluidStored.amount, this.structure.inventory[0], this.structure.fluidStored.getFluid());
                        if (received != null) {
                            this.structure.fluidStored.amount += received.amount;
                        }
                    } else {
                        this.structure.fluidStored = FluidContainerUtils.extractFluid(max, this.structure.inventory[0], null);
                    }
                    int n = newStored = this.structure.fluidStored != null ? this.structure.fluidStored.amount : 0;
                    if ((((IFluidContainerItem)this.structure.inventory[0].func_77973_b()).getFluid(this.structure.inventory[0]) == null || newStored == max) && this.structure.inventory[1] == null) {
                        this.structure.inventory[1] = this.structure.inventory[0].func_77946_l();
                        this.structure.inventory[0] = null;
                        this.func_70296_d();
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)this.structure.inventory[0]) && (this.structure.editMode == FluidContainerUtils.ContainerEditMode.BOTH || this.structure.editMode == FluidContainerUtils.ContainerEditMode.FILL)) {
                ItemStack filled;
                if (this.structure.fluidStored != null && this.structure.fluidStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)this.structure.fluidStored, (ItemStack)this.structure.inventory[0])) != null && (this.structure.inventory[1] == null || this.structure.inventory[1].func_77969_a(filled) && this.structure.inventory[1].field_77994_a + 1 <= filled.func_77976_d())) {
                    --this.structure.inventory[0].field_77994_a;
                    if (this.structure.inventory[0].field_77994_a <= 0) {
                        this.structure.inventory[0] = null;
                    }
                    if (this.structure.inventory[1] == null) {
                        this.structure.inventory[1] = filled;
                    } else {
                        ++this.structure.inventory[1].field_77994_a;
                    }
                    this.func_70296_d();
                    this.structure.fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                    if (this.structure.fluidStored.amount == 0) {
                        this.structure.fluidStored = null;
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)this.structure.inventory[0]) && (this.structure.editMode == FluidContainerUtils.ContainerEditMode.BOTH || this.structure.editMode == FluidContainerUtils.ContainerEditMode.EMPTY)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.structure.inventory[0]);
                if (this.structure.fluidStored == null && itemFluid.amount <= max || this.structure.fluidStored.amount + itemFluid.amount <= max) {
                    if (this.structure.fluidStored != null && !this.structure.fluidStored.isFluidEqual(itemFluid)) {
                        return;
                    }
                    ItemStack containerItem = this.structure.inventory[0].func_77973_b().getContainerItem(this.structure.inventory[0]);
                    boolean filled = false;
                    if (containerItem != null) {
                        if (this.structure.inventory[1] == null || this.structure.inventory[1].func_77969_a(containerItem) && this.structure.inventory[1].field_77994_a + 1 <= containerItem.func_77976_d()) {
                            this.structure.inventory[0] = null;
                            if (this.structure.inventory[1] == null) {
                                this.structure.inventory[1] = containerItem;
                            } else {
                                ++this.structure.inventory[1].field_77994_a;
                            }
                            filled = true;
                        }
                    } else {
                        --this.structure.inventory[0].field_77994_a;
                        if (this.structure.inventory[0].field_77994_a == 0) {
                            this.structure.inventory[0] = null;
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (this.structure.fluidStored == null) {
                            this.structure.fluidStored = itemFluid.copy();
                        } else {
                            this.structure.fluidStored.amount += itemFluid.amount;
                        }
                        this.func_70296_d();
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isRendering);
        data.add(this.structure != null);
        if (this.structure != null) {
            data.add(this.structure.volume * 16000);
            data.add(this.structure.editMode.ordinal());
        }
        if (this.structure != null && this.structure.fluidStored != null) {
            data.add(1);
            data.add(this.structure.fluidStored.fluidID);
            data.add(this.structure.fluidStored.amount);
        } else {
            data.add(0);
        }
        if (this.structure != null && this.isRendering) {
            if (this.sendStructure) {
                this.sendStructure = false;
                data.add(true);
                data.add(this.structure.volHeight);
                data.add(this.structure.volWidth);
                data.add(this.structure.volLength);
                this.structure.renderLocation.write(data);
            } else {
                data.add(false);
            }
            data.add(this.structure.valves.size());
            for (SynchronizedTankData.ValveData valveData : this.structure.valves) {
                valveData.location.write(data);
                data.add(valveData.side.ordinal());
                data.add(valveData.serverFluid);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.structure == null) {
            this.structure = new SynchronizedTankData();
        }
        this.isRendering = dataStream.readBoolean();
        this.clientHasStructure = dataStream.readBoolean();
        if (this.clientHasStructure) {
            this.clientCapacity = dataStream.readInt();
            this.structure.editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
        }
        this.structure.fluidStored = dataStream.readInt() == 1 ? new FluidStack(dataStream.readInt(), dataStream.readInt()) : null;
        if (this.clientHasStructure && this.isRendering) {
            if (dataStream.readBoolean()) {
                this.structure.volHeight = dataStream.readInt();
                this.structure.volWidth = dataStream.readInt();
                this.structure.volLength = dataStream.readInt();
                this.structure.renderLocation = Coord4D.read(dataStream);
            }
            int size = dataStream.readInt();
            for (int i = 0; i < size; ++i) {
                SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                data.location = Coord4D.read(dataStream);
                data.side = ForgeDirection.getOrientation((int)dataStream.readInt());
                int viewingTicks = 0;
                if (dataStream.readBoolean()) {
                    viewingTicks = 30;
                }
                if (viewingTicks == 0 && this.valveViewing.containsKey(data) && this.valveViewing.get(data) > 0) continue;
                this.valveViewing.put(data, viewingTicks);
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null) continue;
                tileEntity.clientHasStructure = true;
            }
        }
    }

    public void sendPacketToRenderer() {
        if (this.structure != null) {
            for (Coord4D obj : this.structure.locations) {
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !tileEntity.isRendering) continue;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
    }

    public int getScaledFluidLevel(int i) {
        if (this.clientCapacity == 0 || this.structure.fluidStored == null) {
            return 0;
        }
        return this.structure.fluidStored.amount * i / this.clientCapacity;
    }

    @Override
    public ItemStack func_70301_a(int slotID) {
        return this.structure != null ? this.structure.inventory[slotID] : null;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.structure != null) {
            this.structure.inventory[slotID] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.structure == null) {
            this.inventoryID = nbtTags.func_74762_e("inventoryID");
            if (this.inventoryID != -1) {
                this.cachedData.load(nbtTags);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("inventoryID", this.inventoryID);
        if (this.inventoryID != -1) {
            this.cachedData.save(nbtTags);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        if (this.structure != null) {
            return this.structure.editMode;
        }
        return FluidContainerUtils.ContainerEditMode.BOTH;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        if (this.structure == null) {
            return;
        }
        this.structure.editMode = mode;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }
}

