/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.ITileNetwork;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2API", striprefs=true), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="IC2API", striprefs=true), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy"), @Optional.Interface(iface="buildcraft.api.power.IPowerReceptor", modid="BuildCraftAPI|power"), @Optional.Interface(iface="buildcraft.api.power.IPowerEmitter", modid="BuildCraftAPI|power")})
public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements ITileNetwork,
IPowerEmitter,
IPowerReceptor,
IStrictEnergyStorage,
IEnergyHandler,
IEnergySink,
IEnergyStorage,
IStrictEnergyAcceptor,
ICableOutputter {
    public double electricityStored;
    public double MAX_ELECTRICITY;
    public PowerHandler powerHandler;

    public TileEntityElectricBlock(String name, double maxEnergy) {
        super(name);
        this.MAX_ELECTRICITY = maxEnergy;
        if (MekanismUtils.useBuildCraft()) {
            this.configure();
        }
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public void configure() {
        this.powerHandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.STORAGE);
        this.powerHandler.configurePowerPerdition(0, 0);
        this.powerHandler.configure(0.0, 0.0, 0.0, 0.0);
    }

    @Optional.Method(modid="IC2API")
    public void register() {
        if (!this.field_145850_b.field_72995_K && !Mekanism.ic2Registered.contains(Coord4D.get(this))) {
            Mekanism.ic2Registered.add(Coord4D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    @Optional.Method(modid="IC2API")
    public void deregister() {
        if (!this.field_145850_b.field_72995_K && Mekanism.ic2Registered.contains(Coord4D.get(this))) {
            Mekanism.ic2Registered.remove(Coord4D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    @Override
    public void onUpdate() {
        if (MekanismUtils.useBuildCraft()) {
            this.reconfigure();
        }
    }

    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    protected EnumSet<ForgeDirection> getConsumingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
        MekanismUtils.saveChunk(this);
    }

    @Override
    public double getMaxEnergy() {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.setEnergy(dataStream.readDouble());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
        if (MekanismUtils.useBuildCraft()) {
            this.reconfigure();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.getConsumingSides().contains(side)) {
            return this.powerHandler.getPowerReceiver();
        }
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    protected void reconfigure() {
        this.powerHandler.configure(0.0, (double)((float)((this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_BC)), 0.0, (double)((float)(this.getMaxEnergy() * Mekanism.TO_BC)));
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public void doWork(PowerHandler workProvider) {
        if (this.powerHandler.getEnergyStored() > 0.0) {
            if (this.getEnergy() < this.getMaxEnergy()) {
                this.setEnergy(this.getEnergy() + this.powerHandler.useEnergy(0.0, (double)((float)((this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_BC)), true) * Mekanism.FROM_BC);
            }
            this.powerHandler.setEnergy(0.0);
        }
        this.reconfigure();
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public World getWorld() {
        return this.field_145850_b;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = (int)Math.min(this.getMaxEnergy() - this.getEnergy(), (double)maxReceive * Mekanism.FROM_TE);
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
            }
            return (int)Math.round(toAdd * Mekanism.TO_TE);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * Mekanism.FROM_TE));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getConsumingSides().contains(from) || this.getOutputtingSides().contains(from);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * Mekanism.TO_TE);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * Mekanism.TO_TE);
    }

    @Optional.Method(modid="IC2API")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2API")
    public void setStored(int energy) {
        this.setEnergy((double)energy * Mekanism.FROM_IC2);
    }

    @Optional.Method(modid="IC2API")
    public int addEnergy(int amount) {
        this.setEnergy(this.getEnergy() + (double)amount * Mekanism.FROM_IC2);
        return (int)Math.round(this.getEnergy() * Mekanism.TO_IC2);
    }

    @Optional.Method(modid="IC2API")
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2API")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.getOutputtingSides().contains(direction);
    }

    @Optional.Method(modid="IC2API")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * Mekanism.TO_IC2);
    }

    @Optional.Method(modid="IC2API")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * Mekanism.TO_IC2);
    }

    @Optional.Method(modid="IC2API")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * Mekanism.TO_IC2);
    }

    @Optional.Method(modid="IC2API")
    public double getDemandedEnergy() {
        return (this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_IC2;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConsumingSides().contains(side);
    }

    @Optional.Method(modid="IC2API")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * Mekanism.TO_IC2;
    }

    @Optional.Method(modid="IC2API")
    public double injectEnergy(ForgeDirection direction, double i, double v) {
        if (Coord4D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_145850_b) instanceof IGridTransmitter) {
            return i;
        }
        return i - this.transferEnergyToAcceptor(direction, i * Mekanism.FROM_IC2) * Mekanism.TO_IC2;
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.getConsumingSides().contains(side) && side != ForgeDirection.UNKNOWN) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }
}

