/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.PacketHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectricChest
extends TileEntityElectricBlock {
    public static int[] INV;
    public String password = "";
    public boolean authenticated = false;
    public boolean locked = false;
    public float lidAngle;
    public float prevLidAngle;

    public TileEntityElectricChest() {
        super("ElectricChest", 12000.0);
        this.inventory = new ItemStack[55];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.prevLidAngle = this.lidAngle;
        float increment = 0.1f;
        if (this.playersUsing.size() > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d + 0.5, (double)((float)this.field_145849_e + 0.5f), "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing.size() == 0 && this.lidAngle > 0.0f || this.playersUsing.size() > 0 && this.lidAngle < 1.0f) {
            float split;
            float angle = this.lidAngle;
            this.lidAngle = this.playersUsing.size() > 0 ? (this.lidAngle += increment) : (this.lidAngle -= increment);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (split = 0.5f) && angle >= split) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        ChargeUtils.discharge(54, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.authenticated = nbtTags.func_74767_n("authenticated");
        this.locked = nbtTags.func_74767_n("locked");
        this.password = nbtTags.func_74779_i("password");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("authenticated", this.authenticated);
        nbtTags.func_74757_a("locked", this.locked);
        nbtTags.func_74778_a("password", this.password);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.authenticated = dataStream.readBoolean();
        this.locked = dataStream.readBoolean();
        this.password = PacketHandler.readString(dataStream);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.authenticated);
        data.add(this.locked);
        data.add(this.password);
        return data;
    }

    public boolean canAccess() {
        return this.authenticated && (this.getEnergy() == 0.0 || !this.locked);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 54) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 0 || !this.canAccess()) {
            return InventoryUtils.EMPTY;
        }
        if (INV == null) {
            INV = new int[55];
            for (int i = 0; i < INV.length; ++i) {
                TileEntityElectricChest.INV[i] = i;
            }
        }
        return INV;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 54) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return true;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }
}

