/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.ChemicalPair;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.ISustainedData;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityElectrolyticSeparator
extends TileEntityElectricBlock
implements IFluidHandler,
IPeripheral,
ITubeConnection,
ISustainedData,
IGasHandler {
    public FluidTank fluidTank = new FluidTank(24000);
    public int MAX_GAS = 2400;
    public GasTank leftTank = new GasTank(this.MAX_GAS);
    public GasTank rightTank = new GasTank(this.MAX_GAS);
    public int output = 16;
    public boolean dumpLeft = false;
    public boolean dumpRight = false;
    public boolean isActive = false;

    public TileEntityElectrolyticSeparator() {
        super("ElectrolyticSeparator", BlockMachine.MachineType.ELECTROLYTIC_SEPARATOR.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tileEntity;
            GasStack toSend;
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(this.inventory[0])) {
                if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                    this.fluidTank.fill(FluidContainerUtils.extractFluid(this.fluidTank, this.inventory[0]), true);
                } else {
                    FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
                    if (fluid != null && this.fluidTank.getFluid() == null || fluid.isFluidEqual(this.fluidTank.getFluid()) && this.fluidTank.getFluid().amount + fluid.amount <= this.fluidTank.getCapacity()) {
                        this.fluidTank.fill(fluid, true);
                        if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.inventory[1] != null && this.leftTank.getStored() > 0) {
                    this.leftTank.draw(GasTransmission.addGas(this.inventory[1], this.leftTank.getGas()), true);
                    MekanismUtils.saveChunk(this);
                }
                if (this.inventory[2] != null && this.rightTank.getStored() > 0) {
                    this.rightTank.draw(GasTransmission.addGas(this.inventory[2], this.rightTank.getGas()), true);
                    MekanismUtils.saveChunk(this);
                }
            }
            if (this.canOperate()) {
                this.setActive(true);
                this.fillTanks(RecipeHandler.getElectrolyticSeparatorOutput(this.fluidTank, true));
                this.setEnergy(this.getEnergy() - Mekanism.FROM_H2 * 2.0);
            } else {
                this.setActive(false);
            }
            if (this.leftTank.getGas() != null) {
                if (!this.dumpLeft) {
                    toSend = new GasStack(this.leftTank.getGas().getGas(), Math.min(this.leftTank.getStored(), this.output));
                    tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getLeft(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), this.leftTank.getGas().getGas())) {
                        this.leftTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), toSend), true);
                    }
                } else {
                    this.leftTank.draw(8, true);
                    if (this.field_145850_b.field_73012_v.nextInt(3) == 2) {
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getParticlePacket(0, new ArrayList())), new Range4D(Coord4D.get(this)));
                    }
                }
            }
            if (this.rightTank.getGas() != null) {
                if (!this.dumpRight) {
                    toSend = new GasStack(this.rightTank.getGas().getGas(), Math.min(this.rightTank.getStored(), this.output));
                    tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.rightTank.getGas().getGas())) {
                        this.rightTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend), true);
                    }
                } else {
                    this.rightTank.draw(8, true);
                    if (this.field_145850_b.field_73012_v.nextInt(3) == 2) {
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getParticlePacket(1, new ArrayList())), new Range4D(Coord4D.get(this)));
                    }
                }
            }
        }
    }

    public boolean canOperate() {
        return this.canFillWithSwap(RecipeHandler.getElectrolyticSeparatorOutput(this.fluidTank, false)) && this.getEnergy() >= Mekanism.FROM_H2 * 2.0;
    }

    public boolean canFillWithSwap(ChemicalPair gases) {
        if (gases == null) {
            return false;
        }
        return this.canFill(gases) || this.canFill(gases.swap());
    }

    public boolean canFill(ChemicalPair gases) {
        return this.leftTank.canReceive(gases.leftGas.getGas()) && this.leftTank.getNeeded() >= gases.leftGas.amount && this.rightTank.canReceive(gases.rightGas.getGas()) && this.rightTank.getNeeded() >= gases.rightGas.amount;
    }

    public void fillTanks(ChemicalPair gases) {
        if (gases == null) {
            return;
        }
        if (this.canFill(gases)) {
            this.leftTank.receive(gases.leftGas, true);
            this.rightTank.receive(gases.rightGas, true);
        } else if (this.canFill(gases.swap())) {
            this.leftTank.receive(gases.rightGas, true);
            this.rightTank.receive(gases.leftGas, true);
        }
    }

    public void spawnParticle(int type) {
        if (type == 0) {
            ForgeDirection side = ForgeDirection.getOrientation((int)this.facing);
            double x = (double)this.field_145851_c + (side.offsetX == 0 ? 0.5 : (double)Math.max(side.offsetX, 0));
            double z = (double)this.field_145849_e + (side.offsetZ == 0 ? 0.5 : (double)Math.max(side.offsetZ, 0));
            this.field_145850_b.func_72869_a("smoke", x, (double)this.field_145848_d + 0.5, z, 0.0, 0.0, 0.0);
        } else if (type == 1) {
            switch (this.facing) {
                case 3: {
                    this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.9, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.75, 0.0, 0.0, 0.0);
                    break;
                }
                case 4: {
                    this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.25, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.9, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.1, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.25, 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.75, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1 || slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(itemstack);
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("hydrogen"));
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("oxygen"));
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight(this.facing)) {
            return new int[]{3};
        }
        if (side == this.facing || ForgeDirection.getOrientation((int)side) == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return new int[]{1, 2};
        }
        return InventoryUtils.EMPTY;
    }

    public int getLeftScaledLevel(int i) {
        return this.leftTank.getStored() * i / this.MAX_GAS;
    }

    public int getRightScaledLevel(int i) {
        return this.rightTank.getStored() * i / this.MAX_GAS;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount * i / this.fluidTank.getCapacity() : 0;
    }

    @Override
    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.dumpLeft ^= true;
            } else if (type == 1) {
                this.dumpRight ^= true;
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            if (dataStream.readBoolean()) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (dataStream.readBoolean()) {
                this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.leftTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.rightTank.setGas(null);
            }
            this.dumpLeft = dataStream.readBoolean();
            this.dumpRight = dataStream.readBoolean();
            this.isActive = dataStream.readBoolean();
        } else if (type == 1) {
            this.spawnParticle(dataStream.readInt());
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.fluidTank.getFluid().getFluid().getID());
            data.add(this.fluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.dumpLeft);
        data.add(this.dumpRight);
        data.add(this.isActive);
        return data;
    }

    public ArrayList getParticlePacket(int type, ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(type);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.dumpLeft = nbtTags.func_74767_n("dumpLeft");
        this.dumpRight = nbtTags.func_74767_n("dumpRight");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("dumpLeft", this.dumpLeft);
        nbtTags.func_74757_a("dumpRight", this.dumpRight);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getCapacity() - this.fluidTank.getFluid().amount : 0};
            }
            case 6: {
                return new Object[]{this.leftTank.getStored()};
            }
            case 7: {
                return new Object[]{this.leftTank.getNeeded()};
            }
            case 8: {
                return new Object[]{this.rightTank.getStored()};
            }
            case 9: {
                return new Object[]{this.rightTank.getNeeded()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.leftTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("leftTank", (NBTBase)this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("rightTank", (NBTBase)this.rightTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank")));
        this.leftTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("rightTank")));
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.draw(amount, true);
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.draw(amount, true);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.getGas() != null && this.leftTank.getGas().getGas() == type;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.getGas() != null && this.rightTank.getGas().getGas() == type;
        }
        return false;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

