/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IPeripheral,
IRedstoneControl {
    public Tier.EnergyCubeTier tier = Tier.EnergyCubeTier.BASIC;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public int prevScale;

    public TileEntityEnergyCube() {
        super("EnergyCube", 0.0);
        this.inventory = new ItemStack[2];
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int newScale;
            ChargeUtils.charge(0, this);
            ChargeUtils.discharge(1, this);
            if (MekanismUtils.canFunction(this)) {
                CableUtils.emit(this);
            }
            if ((newScale = this.getScaledEnergyLevel(20)) != this.prevScale) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            this.prevScale = newScale;
        }
    }

    @Override
    public String func_145825_b() {
        return MekanismUtils.localize(this.func_145838_q().func_149739_a() + "." + this.tier.name + ".name");
    }

    @Override
    public double getMaxOutput() {
        return this.tier.OUTPUT;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    protected EnumSet<ForgeDirection> getConsumingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.removeAll(this.getOutputtingSides());
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing));
    }

    @Override
    public boolean canSetFacing(int side) {
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.MAX_ELECTRICITY;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side <= 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.tier.OUTPUT};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        this.tier = Tier.EnergyCubeTier.getFromName(PacketHandler.readString(dataStream));
        super.handlePacketData(dataStream);
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.tier.name);
        super.getNetworkedData(data);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.EnergyCubeTier.getFromName(nbtTags.func_74779_i("tier"));
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74778_a("tier", this.tier.name);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public void setEnergy(double energy) {
        super.setEnergy(energy);
        int newRedstoneLevel = this.getRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.func_70296_d();
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = this.getEnergy() / this.getMaxEnergy();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }
}

