/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.StackUtils;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IEjector;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeManagement;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityFactory
extends TileEntityElectricBlock
implements IPeripheral,
IActiveState,
IInvConfiguration,
IUpgradeTile,
IHasSound,
IRedstoneControl,
IGasHandler,
ITubeConnection {
    public Tier.FactoryTier tier;
    public byte[] sideConfig = new byte[]{5, 4, 0, 3, 2, 1};
    public ArrayList<SideData> sideOutputs = new ArrayList();
    public int[] progress;
    public int TICKS_REQUIRED = 200;
    public double ENERGY_PER_TICK = Mekanism.factoryUsage;
    public int RECIPE_TICKS_REQUIRED = 40;
    public int recipeTicks;
    public boolean clientActive;
    public boolean isActive;
    public int updateDelay;
    public int recipeType;
    public double prevEnergy;
    public GasTank gasTank;
    public boolean sorting;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 0);
    public TileComponentEjector ejectorComponent;

    public TileEntityFactory() {
        this(Tier.FactoryTier.BASIC, BlockMachine.MachineType.BASIC_FACTORY);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{4}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{5, 6, 7}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{8, 9, 10}));
        this.ejectorComponent = new TileComponentEjector(this, this.sideOutputs.get(5));
    }

    public TileEntityFactory(Tier.FactoryTier type, BlockMachine.MachineType machine) {
        super(type.name + "Factory", machine.baseEnergy);
        this.tier = type;
        this.inventory = new ItemStack[5 + type.processes * 2];
        this.progress = new int[type.processes];
        this.isActive = false;
        this.gasTank = new GasTank(TileEntityAdvancedElectricMachine.MAX_GAS * this.tier.processes);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker == 1) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.sortInventory();
            if (this.inventory[2] != null && this.inventory[3] == null) {
                Enum toSet = null;
                for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                    if (!this.inventory[2].func_77969_a(type.getStack())) continue;
                    toSet = type;
                    break;
                }
                if (toSet != null && this.recipeType != toSet.ordinal()) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else if (this.recipeTicks == this.RECIPE_TICKS_REQUIRED) {
                        this.recipeTicks = 0;
                        ItemStack returnStack = this.getMachineStack();
                        IUpgradeManagement mgmt = (IUpgradeManagement)this.inventory[2].func_77973_b();
                        ((IUpgradeManagement)returnStack.func_77973_b()).setEnergyMultiplier(mgmt.getEnergyMultiplier(this.inventory[2]), returnStack);
                        ((IUpgradeManagement)returnStack.func_77973_b()).setSpeedMultiplier(mgmt.getSpeedMultiplier(this.inventory[2]), returnStack);
                        this.inventory[2] = null;
                        this.inventory[3] = returnStack;
                        this.recipeType = toSet.ordinal();
                        this.gasTank.setGas(null);
                        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                        MekanismUtils.saveChunk(this);
                    }
                } else {
                    this.recipeTicks = 0;
                }
            } else {
                this.recipeTicks = 0;
            }
            for (int process = 0; process < this.tier.processes; ++process) {
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK) && this.gasTank.getStored() >= this.getSecondaryEnergyPerTick()) {
                    if (this.progress[process] + 1 < MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.gasTank.draw(this.getSecondaryEnergyPerTick(), true);
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK);
                    } else if (this.progress[process] + 1 >= MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.gasTank.draw(this.getSecondaryEnergyPerTick(), true);
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK);
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) || IFactory.RecipeType.values()[this.recipeType].usesFuel() && IFactory.RecipeType.values()[this.recipeType].hasRecipe(this.inventory[this.getInputSlot(process)])) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK) && this.gasTank.getStored() >= this.getSecondaryEnergyPerTick()) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public void sortInventory() {
        if (this.sorting) {
            boolean didOp = false;
            int[] inputSlots = null;
            ArrayList<InvID> invStacks = new ArrayList<InvID>();
            if (this.tier == Tier.FactoryTier.BASIC) {
                inputSlots = new int[]{5, 6, 7};
            } else if (this.tier == Tier.FactoryTier.ADVANCED) {
                inputSlots = new int[]{5, 6, 7, 8, 9};
            } else if (this.tier == Tier.FactoryTier.ELITE) {
                inputSlots = new int[]{5, 6, 7, 8, 9, 10, 11};
            }
            for (int id : inputSlots) {
                invStacks.add(InvID.get(id, this.inventory));
            }
            for (InvID invID1 : invStacks) {
                for (InvID invID2 : invStacks) {
                    if (invID1.ID == invID2.ID || StackUtils.diffIgnoreNull(invID1.stack, invID2.stack) || Math.abs(invID1.size() - invID2.size()) < 2) continue;
                    List<ItemStack> evened = StackUtils.even(this.inventory[invID1.ID], this.inventory[invID2.ID]);
                    this.inventory[invID1.ID] = evened.get(0);
                    this.inventory[invID2.ID] = evened.get(1);
                    didOp = true;
                    break;
                }
                if (!didOp) continue;
                this.func_70296_d();
                break;
            }
        }
    }

    public int getSecondaryEnergyPerTick() {
        return MekanismUtils.getSecondaryEnergyPerTick(this, IFactory.RecipeType.values()[this.recipeType].getSecondaryEnergyPerTick());
    }

    public void handleSecondaryFuel() {
        if (this.inventory[4] != null && IFactory.RecipeType.values()[this.recipeType].usesFuel() && this.gasTank.getNeeded() > 0) {
            if (this.inventory[4].func_77973_b() instanceof IGasItem) {
                GasStack gas = ((IGasItem)this.inventory[4].func_77973_b()).getGas(this.inventory[4]);
                if (gas != null && IFactory.RecipeType.values()[this.recipeType].isValidGas(gas.getGas())) {
                    GasStack removed = GasTransmission.removeGas(this.inventory[4], this.gasTank.getGasType(), this.gasTank.getNeeded());
                    this.gasTank.receive(removed, true);
                }
                return;
            }
            GasStack stack = IFactory.RecipeType.values()[this.recipeType].getItemGas(this.inventory[4]);
            int gasNeeded = this.gasTank.getNeeded();
            if (stack != null && stack.amount <= gasNeeded) {
                this.gasTank.receive(stack, true);
                --this.inventory[4].field_77994_a;
                if (this.inventory[4].field_77994_a == 0) {
                    this.inventory[4] = null;
                }
            }
        }
    }

    public ItemStack getMachineStack() {
        return IFactory.RecipeType.values()[this.recipeType].getStack();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == Tier.FactoryTier.BASIC && slotID >= 8 && slotID <= 10) {
            return true;
        }
        if (this.tier == Tier.FactoryTier.ADVANCED && slotID >= 10 && slotID <= 14) {
            return true;
        }
        return this.tier == Tier.FactoryTier.ELITE && slotID >= 12 && slotID <= 18;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.tier == Tier.FactoryTier.BASIC) {
            if (slotID >= 8 && slotID <= 10) {
                return false;
            }
            if (slotID >= 5 && slotID <= 7) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ADVANCED) {
            if (slotID >= 10 && slotID <= 14) {
                return false;
            }
            if (slotID >= 5 && slotID <= 9) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ELITE) {
            if (slotID >= 12 && slotID <= 18) {
                return false;
            }
            if (slotID >= 5 && slotID <= 11) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, false) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == Mekanism.SpeedUpgrade || itemstack.func_77973_b() == Mekanism.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            return IFactory.RecipeType.values()[this.recipeType].getItemGas(itemstack) != null;
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / MekanismUtils.getTicks(this, this.TICKS_REQUIRED);
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / this.RECIPE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (this.inventory[inputSlot] == null) {
            return false;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, false);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[outputSlot] == null) {
            return true;
        }
        if (!this.inventory[outputSlot].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[outputSlot].field_77994_a + itemstack.field_77994_a <= this.inventory[outputSlot].func_77976_d();
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, true);
        if (this.inventory[inputSlot].field_77994_a <= 0) {
            this.inventory[inputSlot] = null;
        }
        if (this.inventory[outputSlot] == null) {
            this.inventory[outputSlot] = itemstack;
        } else {
            this.inventory[outputSlot].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        int i;
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.recipeType = dataStream.readInt();
        this.recipeTicks = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.sorting = dataStream.readBoolean();
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = dataStream.readInt();
        }
        for (i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        int i;
        super.func_145839_a(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.recipeType = nbtTags.func_74762_e("recipeType");
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.sorting = nbtTags.func_74767_n("sorting");
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        int i;
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("recipeType", this.recipeType);
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("sorting", this.sorting);
        for (i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74757_a("sideDataStored", true);
        for (i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.recipeType);
        data.add(this.recipeTicks);
        data.add(this.controlType.ordinal());
        data.add(this.sorting);
        data.add(this.progress);
        data.add(this.sideConfig);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    public int getInputSlot(int operation) {
        return operation + 5;
    }

    public int getOutputSlot(int operation) {
        return this.tier.processes + 5 + operation;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this, this.MAX_ELECTRICITY);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)]).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public ArrayList<SideData> getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return IFactory.RecipeType.values()[this.recipeType].getSound();
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return IFactory.RecipeType.values()[this.recipeType].canReceiveGas(side, type);
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return IFactory.RecipeType.values()[this.recipeType].canTubeConnect(side);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    public static class InvID {
        public ItemStack stack;
        public int ID;

        public InvID(ItemStack s, int i) {
            this.stack = s;
            this.ID = i;
        }

        public int size() {
            return this.stack != null ? this.stack.field_77994_a : 0;
        }

        public Item item() {
            return this.stack != null ? this.stack.func_77973_b() : null;
        }

        public static InvID get(int id, ItemStack[] inv) {
            return new InvID(inv[id], id);
        }
    }
}

