/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IFilterAccess;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.IActiveState;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISustainedData;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.transporter.Finder;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TItemStackFilter;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLogisticalSorter
extends TileEntityElectricBlock
implements IRedstoneControl,
IActiveState,
IFilterAccess,
ISustainedData {
    public HashList<TransporterFilter> filters = new HashList();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public EnumColor color;
    public boolean autoEject;
    public boolean roundRobin;
    public int rrIndex = 0;
    public final int MAX_DELAY = 10;
    public int delayTicks;
    public boolean isActive;
    public boolean clientActive;
    public final double ENERGY_PER_ITEM = 5.0;

    public TileEntityLogisticalSorter() {
        super("LogisticalSorter", BlockMachine.MachineType.LOGISTICAL_SORTER.baseEnergy);
        this.inventory = new ItemStack[1];
        this.doAutoSync = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            if (this.delayTicks == 6) {
                this.setActive(false);
            }
            if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
                TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_145850_b);
                TileEntity front = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (back instanceof IInventory && (front instanceof ILogisticalTransporter || front instanceof IInventory)) {
                    ItemStack used;
                    InvStack invStack;
                    IInventory inventory = (IInventory)back;
                    boolean sentItems = false;
                    int min = 0;
                    for (TransporterFilter filter : this.filters) {
                        ItemStack used2;
                        InvStack invStack2 = filter.getStackFromInventory(inventory, ForgeDirection.getOrientation((int)this.facing).getOpposite());
                        if (invStack2 == null || invStack2.getStack() == null || !filter.canFilter(invStack2.getStack())) continue;
                        if (filter instanceof TItemStackFilter) {
                            TItemStackFilter itemFilter = (TItemStackFilter)filter;
                            if (itemFilter.sizeMode) {
                                min = itemFilter.min;
                            }
                        }
                        if ((used2 = this.emitItemToTransporter(front, invStack2, filter.color, min)) == null) continue;
                        invStack2.use(used2.field_77994_a);
                        inventory.func_70296_d();
                        this.setActive(true);
                        sentItems = true;
                        break;
                    }
                    if (!sentItems && this.autoEject && (invStack = InventoryUtils.takeTopStack(inventory, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), new Finder.FirstFinder())) != null && invStack.getStack() != null && (used = this.emitItemToTransporter(front, invStack, this.color, 0)) != null) {
                        invStack.use(used.field_77994_a);
                        inventory.func_70296_d();
                        this.setActive(true);
                    }
                    this.delayTicks = 10;
                }
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new ArrayList())), (EntityPlayerMP)player);
                }
            }
        }
    }

    public ItemStack emitItemToTransporter(TileEntity front, InvStack inInventory, EnumColor filterColor, int min) {
        ItemStack used = null;
        if (front instanceof ILogisticalTransporter) {
            ILogisticalTransporter transporter = (ILogisticalTransporter)front;
            if (!this.roundRobin) {
                ItemStack rejects = TransporterUtils.insert(this, transporter, inInventory.getStack(), filterColor, true, min);
                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                }
            } else {
                ItemStack rejects = TransporterUtils.insertRR(this, transporter, inInventory.getStack(), filterColor, true, min);
                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                }
            }
        } else if (front instanceof IInventory) {
            ItemStack rejects = InventoryUtils.putStackInInventory((IInventory)front, inInventory.getStack(), this.facing, false);
            if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                used = TransporterManager.getToUse(inInventory.getStack(), rejects);
            }
        }
        return used;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                int clickType = dataStream.readInt();
                if (clickType == 0) {
                    this.color = TransporterUtils.increment(this.color);
                } else if (clickType == 1) {
                    this.color = TransporterUtils.decrement(this.color);
                } else if (clickType == 2) {
                    this.color = null;
                }
            } else if (type == 1) {
                this.autoEject = !this.autoEject;
            } else if (type == 2) {
                this.roundRobin = !this.roundRobin;
                this.rrIndex = 0;
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            int c = dataStream.readInt();
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            this.autoEject = dataStream.readBoolean();
            this.roundRobin = dataStream.readBoolean();
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(TransporterFilter.readFromPacket(dataStream));
            }
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (type == 1) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            int c = dataStream.readInt();
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            this.autoEject = dataStream.readBoolean();
            this.roundRobin = dataStream.readBoolean();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (type == 2) {
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(TransporterFilter.readFromPacket(dataStream));
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        return data;
    }

    public ArrayList getFilterPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public boolean canSendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_145850_b);
        if (back instanceof IInventory) {
            return InventoryUtils.canInsert(back, null, stack, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), true);
        }
        return false;
    }

    public boolean hasInventory() {
        return Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_145850_b) instanceof IInventory;
    }

    public ItemStack sendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_145850_b);
        if (back instanceof IInventory) {
            return InventoryUtils.putStackInInventory((IInventory)back, stack, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), true);
        }
        return stack;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.getOrientation((int)this.facing).ordinal() || side == ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal()) {
            return new int[]{0};
        }
        return null;
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getFilterPacket(new ArrayList())), new Range4D(Coord4D.get(this)));
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            if (active) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "mekanism:etc.Click", 0.3f, 1.0f);
            }
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public boolean canSetFacing(int facing) {
        return true;
    }

    @Override
    public NBTTagCompound getFilterData(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setFilterData(NBTTagCompound nbtTags) {
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return "tooltip.filterCard.logisticalSorter";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        itemStack.field_77990_d.func_74757_a("hasSorterConfig", true);
        if (this.color != null) {
            itemStack.field_77990_d.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        itemStack.field_77990_d.func_74757_a("autoEject", this.autoEject);
        itemStack.field_77990_d.func_74757_a("roundRobin", this.roundRobin);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            itemStack.field_77990_d.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (itemStack.field_77990_d.func_74764_b("hasSorterConfig")) {
            if (itemStack.field_77990_d.func_74764_b("color")) {
                this.color = TransporterUtils.colors.get(itemStack.field_77990_d.func_74762_e("color"));
            }
            this.autoEject = itemStack.field_77990_d.func_74767_n("autoEject");
            this.roundRobin = itemStack.field_77990_d.func_74767_n("roundRobin");
            if (itemStack.field_77990_d.func_74764_b("filters")) {
                NBTTagList tagList = itemStack.field_77990_d.func_150295_c("filters", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
                }
            }
        }
    }
}

