/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.infuse.InfusionInput;
import mekanism.api.infuse.InfusionOutput;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IEjector;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityMetallurgicInfuser
extends TileEntityElectricBlock
implements IPeripheral,
IActiveState,
IInvConfiguration,
IUpgradeTile,
IHasSound,
IRedstoneControl {
    public byte[] sideConfig = new byte[]{2, 1, 0, 5, 3, 4};
    public ArrayList<SideData> sideOutputs = new ArrayList();
    public InfuseType type = null;
    public int MAX_INFUSE = 1000;
    public double ENERGY_PER_TICK = Mekanism.metallurgicInfuserUsage;
    public int TICKS_REQUIRED = 200;
    public int infuseStored;
    public int operatingTicks;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public double prevEnergy;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 0);
    public TileComponentEjector ejectorComponent;

    public TileEntityMetallurgicInfuser() {
        super("MetallurgicInfuser", BlockMachine.MachineType.METALLURGIC_INFUSER.baseEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{3}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{4}));
        this.inventory = new ItemStack[5];
        this.ejectorComponent = new TileComponentEjector(this, this.sideOutputs.get(4));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(4, this);
            if (this.inventory[1] != null && InfuseRegistry.getObject(this.inventory[1]) != null) {
                InfuseObject infuse = InfuseRegistry.getObject(this.inventory[1]);
                if ((this.type == null || this.type == infuse.type) && this.infuseStored + infuse.stored <= this.MAX_INFUSE) {
                    this.infuseStored += infuse.stored;
                    this.type = infuse.type;
                    --this.inventory[1].field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                }
            }
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK)) {
                this.setActive(true);
                if (this.operatingTicks + 1 < MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.setEnergy(this.getEnergy() - MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK));
                } else if (this.operatingTicks + 1 >= MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.setEnergy(this.getEnergy() - MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK));
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            if (this.infuseStored <= 0) {
                this.infuseStored = 0;
                this.type = null;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 4) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 3;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return false;
        }
        if (slotID == 1) {
            return InfuseRegistry.getObject(itemstack) != null && (this.type == null || this.type == InfuseRegistry.getObject((ItemStack)itemstack).type);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == Mekanism.SpeedUpgrade || itemstack.func_77973_b() == Mekanism.EnergyUpgrade;
        }
        if (slotID == 2) {
            if (this.type != null) {
                if (RecipeHandler.getMetallurgicInfuserOutput(InfusionInput.getInfusion(this.type, this.infuseStored, itemstack), false) != null) {
                    return true;
                }
            } else {
                for (Object obj : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().keySet()) {
                    InfusionInput input = (InfusionInput)obj;
                    if (!input.inputStack.func_77969_a(itemstack)) continue;
                    return true;
                }
            }
        } else if (slotID == 4) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        InfusionOutput output = RecipeHandler.getMetallurgicInfuserOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), true);
        this.infuseStored -= output.getInfuseRequired();
        if (this.inventory[2].field_77994_a <= 0) {
            this.inventory[2] = null;
        }
        if (this.inventory[3] == null) {
            this.inventory[3] = output.resource.func_77946_l();
        } else {
            this.inventory[3].field_77994_a += output.resource.field_77994_a;
        }
        this.ejectorComponent.onOutput();
    }

    public boolean canOperate() {
        if (this.inventory[2] == null) {
            return false;
        }
        InfusionOutput output = RecipeHandler.getMetallurgicInfuserOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), false);
        if (output == null) {
            return false;
        }
        if (this.infuseStored - output.getInfuseRequired() < 0) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[3].func_77969_a(output.resource)) {
            return false;
        }
        return this.inventory[3].field_77994_a + output.resource.field_77994_a <= this.inventory[3].func_77976_d();
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored * i / this.MAX_INFUSE;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)MekanismUtils.getTicks(this, this.TICKS_REQUIRED);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.infuseStored = nbtTags.func_74762_e("infuseStored");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.type = InfuseRegistry.get(nbtTags.func_74779_i("type"));
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("infuseStored", this.infuseStored);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.type != null) {
            nbtTags.func_74778_a("type", this.type.name);
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        nbtTags.func_74757_a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            this.infuseStored = dataStream.readInt();
            return;
        }
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.operatingTicks = dataStream.readInt();
        this.infuseStored = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.type = InfuseRegistry.get(PacketHandler.readString(dataStream));
        for (int i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.infuseStored);
        data.add(this.controlType.ordinal());
        if (this.type != null) {
            data.add(this.type.name);
        } else {
            data.add("null");
        }
        data.add(this.sideConfig);
        return data;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                return new Object[]{this.canOperate()};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 6: {
                return new Object[]{this.infuseStored};
            }
            case 7: {
                return new Object[]{this.MAX_INFUSE - this.infuseStored};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)]).availableSlots;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this, this.MAX_ELECTRICITY);
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public ArrayList<SideData> getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return "MetallurgicInfuser.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }
}

