/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.PressurizedProducts;
import mekanism.api.PressurizedRecipe;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.ISustainedData;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.block.BlockMachine;
import mekanism.common.item.ItemMachineUpgrade;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityPRC
extends TileEntityBasicMachine
implements IFluidHandler,
IGasHandler,
ITubeConnection,
ISustainedData {
    public FluidTank inputFluidTank = new FluidTank(10000);
    public GasTank inputGasTank = new GasTank(10000);
    public GasTank outputGasTank = new GasTank(10000);

    public TileEntityPRC() {
        super("PressurizedReactionChamber.ogg", "PressurizedReactionChamber", new ResourceLocation("mekanism", "gui/GuiPRC.png"), Mekanism.pressurizedReactionBaseUsage, 100, BlockMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.baseEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{3}));
        this.sideConfig = new byte[]{2, 1, 0, 0, 0, 3};
        this.inventory = new ItemStack[4];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.ejectorComponent = new TileComponentEjector(this, (SideData)this.sideOutputs.get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(1, this);
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK)) {
                PressurizedRecipe recipe = this.getRecipe();
                this.TICKS_REQUIRED = recipe.ticks;
                this.setActive(true);
                if (this.operatingTicks + 1 < MekanismUtils.getTicks(this, this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK);
                } else if (this.operatingTicks + 1 >= MekanismUtils.getTicks(this, this.TICKS_REQUIRED) && this.electricityStored >= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK + recipe.extraEnergy)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.ENERGY_PER_TICK + recipe.extraEnergy);
                }
            } else {
                this.TICKS_REQUIRED = 100;
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.outputGasTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputGasTank.getGas().getGas(), Math.min(this.outputGasTank.getStored(), 16));
                TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing), this.outputGasTank.getGas().getGas())) {
                    this.outputGasTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getLeft(this.facing), toSend), true);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.isInPressurizedRecipe(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof ItemMachineUpgrade;
        }
        return false;
    }

    @Override
    public void operate() {
        PressurizedRecipe recipe = this.getRecipe();
        recipe.reactants.use(this.inventory[0], this.inputFluidTank, this.inputGasTank);
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        recipe.products.fillTank(this.outputGasTank);
        recipe.products.addProducts(this.inventory, 2);
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public boolean canOperate() {
        PressurizedRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return false;
        }
        PressurizedProducts products = recipe.products;
        if (products.getItemOutput() != null && this.inventory[2] != null) {
            if (!this.inventory[2].func_77969_a(products.getItemOutput())) {
                return false;
            }
            if (this.inventory[2].field_77994_a + products.getItemOutput().field_77994_a > this.inventory[2].func_77976_d()) {
                return false;
            }
        }
        if (products.getGasOutput() != null && this.outputGasTank.getGas() != null) {
            return products.getGasOutput().isGasEqual(this.outputGasTank.getGas()) && products.getGasOutput().amount <= this.outputGasTank.getNeeded();
        }
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this, this.MAX_ELECTRICITY);
    }

    public PressurizedRecipe getRecipe() {
        if (this.inventory[0] == null) {
            return null;
        }
        return RecipeHandler.getPRCOutput(this.inventory[0], this.inputFluidTank, this.inputGasTank);
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.inputFluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.inputFluidTank.getFluid().getFluid().getID());
            data.add(this.inputFluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.inputGasTank.getGas() != null) {
            data.add(true);
            data.add(this.inputGasTank.getGas().getGas().getID());
            data.add(this.inputGasTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputGasTank.getGas() != null) {
            data.add(true);
            data.add(this.outputGasTank.getGas().getGas().getID());
            data.add(this.outputGasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.inputFluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
        } else {
            this.inputFluidTank.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.inputGasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.inputGasTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.outputGasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.outputGasTank.setGas(null);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.inputFluidTank.readFromNBT(nbtTags.func_74775_l("inputFluidTank"));
        this.inputGasTank.read(nbtTags.func_74775_l("inputGasTank"));
        this.outputGasTank.read(nbtTags.func_74775_l("outputGasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.write(new NBTTagCompound()));
    }

    @Override
    public String func_145825_b() {
        return MekanismUtils.localize(this.func_145838_q().func_149739_a() + "." + this.fullName + ".short.name");
    }

    @Override
    public Map getRecipes() {
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return this.inputFluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return this.inputFluidTank.getFluid() == null || this.inputFluidTank.getFluid().getFluid() == fluid;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.inputFluidTank)};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.inputGasTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.outputGasTank.draw(amount, true);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return side == MekanismUtils.getLeft(this.facing) && (this.inputGasTank.getGas() == null || this.inputGasTank.getGas().getGas() == type);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return side == MekanismUtils.getRight(this.facing) && this.outputGasTank.getGas() != null && this.outputGasTank.getGas().getGas() == type;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputFluidTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputGasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputGasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputFluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("inputFluidTank")));
        this.inputGasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("inputGasTank")));
        this.outputGasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("outputGasTank")));
    }
}

