/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.ISalinationSolar;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntitySalinationTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntitySalinationController
extends TileEntitySalinationTank
implements IConfigurable {
    public static final int MAX_BRINE = 10000;
    public static final int MAX_SOLARS = 4;
    public static final int WARMUP = 10000;
    public static final double WATER_USAGE = 40.0;
    public FluidTank waterTank = new FluidTank(0);
    public FluidTank brineTank = new FluidTank(10000);
    public Set<TileEntitySalinationTank> tankParts = new HashSet<TileEntitySalinationTank>();
    public ISalinationSolar[] solars = new ISalinationSolar[4];
    public boolean temperatureSet = false;
    public double partialWater = 0.0;
    public double partialBrine = 0.0;
    public float biomeTemp = 0.0f;
    public float temperature = 0.0f;
    public int height = 0;
    public boolean structured = false;
    public boolean controllerConflict = false;
    public boolean isLeftOnFace;
    public boolean updatedThisTick = false;
    public int clientSolarAmount;
    public boolean cacheStructure = false;
    public float prevScale;

    public TileEntitySalinationController() {
        super("SalinationController");
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.updatedThisTick = false;
            if (this.ticker == 5 && this.cacheStructure) {
                this.refresh(true);
                this.cacheStructure = false;
            }
            this.updateTemperature();
            this.manageBuckets();
            if (this.canOperate()) {
                int brineNeeded = this.brineTank.getCapacity() - this.brineTank.getFluidAmount();
                int waterStored = this.waterTank.getFluidAmount();
                this.partialWater += Math.min((double)this.waterTank.getFluidAmount(), (double)this.getTemperature() * 40.0);
                if (this.partialWater >= 1.0) {
                    int waterInt = (int)Math.floor(this.partialWater);
                    this.waterTank.drain(waterInt, true);
                    this.partialWater %= 1.0;
                    this.partialBrine += (double)waterInt / 40.0;
                }
                if (this.partialBrine >= 1.0) {
                    int brineInt = (int)Math.floor(this.partialBrine);
                    this.brineTank.fill(FluidRegistry.getFluidStack((String)"brine", (int)brineInt), true);
                    this.partialBrine %= 1.0;
                }
            }
            if (this.structured && (double)Math.abs((float)this.waterTank.getFluidAmount() / (float)this.waterTank.getCapacity() - this.prevScale) > 0.01) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                this.prevScale = (float)this.waterTank.getFluidAmount() / (float)this.waterTank.getCapacity();
            }
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.refresh(false);
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        this.refresh(false);
    }

    protected void refresh(boolean canCreate) {
        if (!this.field_145850_b.field_72995_K && (this.structured || canCreate) && !this.updatedThisTick) {
            boolean prev = this.structured;
            this.clearStructure();
            this.structured = this.buildStructure();
            if (this.structured != prev) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            if (this.structured) {
                this.waterTank.setCapacity(this.getMaxWater());
                if (this.waterTank.getFluid() != null) {
                    this.waterTank.getFluid().amount = Math.min(this.waterTank.getFluid().amount, this.getMaxWater());
                }
                this.temperature = Math.min(this.getMaxTemperature(), this.getTemperature());
            } else {
                this.clearStructure();
            }
        }
    }

    public boolean canOperate() {
        if (!this.structured || this.height < 3 || this.height > 18 || this.waterTank.getFluid() == null || this.getTempMultiplier() == 0.0f) {
            return false;
        }
        return this.waterTank.getFluid().containsFluid(FluidRegistry.getFluidStack((String)"water", (int)1)) && this.brineTank.getCapacity() - this.brineTank.getFluidAmount() != 0;
    }

    private void manageBuckets() {
        ItemStack tempStack;
        if (this.inventory[2] != null && this.brineTank.getFluid() != null && this.brineTank.getFluid().amount >= 1000 && FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[2]) && (tempStack = FluidContainerRegistry.fillFluidContainer((FluidStack)this.brineTank.getFluid(), (ItemStack)this.inventory[2])) != null) {
            if (this.inventory[3] == null) {
                this.brineTank.drain(1000, true);
                this.inventory[3] = tempStack;
                --this.inventory[2].field_77994_a;
                if (this.inventory[2].field_77994_a <= 0) {
                    this.inventory[2] = null;
                }
                this.func_70296_d();
            } else if (tempStack.func_77969_a(this.inventory[3]) && tempStack.func_77976_d() > this.inventory[3].field_77994_a) {
                this.brineTank.drain(1000, true);
                ++this.inventory[3].field_77994_a;
                --this.inventory[2].field_77994_a;
                if (this.inventory[2].field_77994_a <= 0) {
                    this.inventory[2] = null;
                }
                this.func_70296_d();
            }
        }
        if (this.structured && FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[0])) {
            FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
            if (this.waterTank.getFluid() == null && itemFluid.amount <= this.getMaxWater() || this.waterTank.getFluid().amount + itemFluid.amount <= this.getMaxWater()) {
                if (itemFluid.getFluid() != FluidRegistry.WATER || this.waterTank.getFluid() != null && !this.waterTank.getFluid().isFluidEqual(itemFluid)) {
                    return;
                }
                ItemStack containerItem = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                boolean filled = false;
                if (containerItem != null) {
                    if (this.inventory[1] == null || this.inventory[1].func_77969_a(containerItem) && this.inventory[1].field_77994_a + 1 <= containerItem.func_77976_d()) {
                        this.inventory[0] = null;
                        if (this.inventory[1] == null) {
                            this.inventory[1] = containerItem;
                        } else {
                            ++this.inventory[1].field_77994_a;
                        }
                        filled = true;
                    }
                } else {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    filled = true;
                }
                if (filled) {
                    this.waterTank.fill(itemFluid, true);
                }
            }
        }
    }

    private void updateTemperature() {
        float max = this.getMaxTemperature();
        float incr = max / 10000.0f * this.getTempMultiplier();
        this.temperature = this.getTempMultiplier() == 0.0f ? Math.max(0.0f, this.getTemperature() - max / 10000.0f) : Math.min(max, this.getTemperature() + incr);
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getMaxTemperature() {
        if (!this.structured) {
            return 0.0f;
        }
        return 1.0f + (float)(this.height - 3) * 0.5f;
    }

    public float getTempMultiplier() {
        if (!this.temperatureSet) {
            this.biomeTemp = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e).func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.temperatureSet = true;
        }
        return this.biomeTemp * ((float)this.getActiveSolars() / 4.0f);
    }

    public int getActiveSolars() {
        if (this.field_145850_b.field_72995_K) {
            return this.clientSolarAmount;
        }
        int ret = 0;
        for (ISalinationSolar solar : this.solars) {
            if (solar == null || !solar.seesSun()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean buildStructure() {
        ForgeDirection right = MekanismUtils.getRight(this.facing);
        this.height = 0;
        this.controllerConflict = false;
        this.updatedThisTick = true;
        if (!this.scanBottomLayer()) {
            this.height = 0;
            return false;
        }
        Coord4D startPoint = Coord4D.get(this).getFromSide(right);
        startPoint = this.isLeftOnFace ? startPoint.getFromSide(right) : startPoint;
        int middle = 0;
        Coord4D middlePointer = startPoint.getFromSide(ForgeDirection.DOWN);
        while (this.scanMiddleLayer(middlePointer)) {
            middlePointer = middlePointer.getFromSide(ForgeDirection.DOWN);
            ++middle;
        }
        if (this.height < 3 || this.height > 18 || middle != this.height - 2) {
            this.height = 0;
            return false;
        }
        this.structured = this.scanTopLayer(startPoint);
        this.height = this.structured ? this.height : 0;
        this.func_70296_d();
        return this.structured;
    }

    public boolean scanTopLayer(Coord4D current) {
        ForgeDirection left = MekanismUtils.getLeft(this.facing);
        ForgeDirection back = MekanismUtils.getBack(this.facing);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                TileEntity pointerTile;
                Coord4D pointer = current.getFromSide(left, x).getFromSide(back, z);
                int corner = this.getCorner(x, z);
                if (!(corner != -1 ? !this.addSolarPanel(pointer.getTileEntity((IBlockAccess)this.field_145850_b), corner) && !this.addTankPart(pointer.getTileEntity((IBlockAccess)this.field_145850_b)) : (!(x != 1 && x != 2 || z != 1 && z != 2) ? !pointer.isAirBlock((IBlockAccess)this.field_145850_b) : !this.addTankPart(pointerTile = pointer.getTileEntity((IBlockAccess)this.field_145850_b))))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxWater() {
        return this.height * 4 * 16000;
    }

    public int getCorner(int x, int z) {
        if (x == 0 && z == 0) {
            return 0;
        }
        if (x == 0 && z == 3) {
            return 1;
        }
        if (x == 3 && z == 0) {
            return 2;
        }
        if (x == 3 && z == 3) {
            return 3;
        }
        return -1;
    }

    public boolean scanMiddleLayer(Coord4D current) {
        ForgeDirection left = MekanismUtils.getLeft(this.facing);
        ForgeDirection back = MekanismUtils.getBack(this.facing);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                TileEntity pointerTile;
                Coord4D pointer = current.getFromSide(left, x).getFromSide(back, z);
                if (!(!(x != 1 && x != 2 || z != 1 && z != 2) ? !pointer.isAirBlock((IBlockAccess)this.field_145850_b) : !this.addTankPart(pointerTile = pointer.getTileEntity((IBlockAccess)this.field_145850_b)))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean scanBottomLayer() {
        boolean twoRight;
        this.height = 1;
        Coord4D baseBlock = Coord4D.get(this);
        while (baseBlock.getFromSide(ForgeDirection.DOWN).getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntitySalinationTank) {
            baseBlock.step(ForgeDirection.DOWN);
            ++this.height;
        }
        ForgeDirection left = MekanismUtils.getLeft(this.facing);
        ForgeDirection right = MekanismUtils.getRight(this.facing);
        if (!this.scanBottomRow(baseBlock)) {
            return false;
        }
        if (!this.scanBottomRow(baseBlock.getFromSide(left))) {
            return false;
        }
        if (!this.scanBottomRow(baseBlock.getFromSide(right))) {
            return false;
        }
        boolean twoLeft = this.scanBottomRow(baseBlock.getFromSide(left).getFromSide(left));
        if (twoLeft == (twoRight = this.scanBottomRow(baseBlock.getFromSide(right).getFromSide(right)))) {
            return false;
        }
        this.isLeftOnFace = twoRight;
        return true;
    }

    public boolean scanBottomRow(Coord4D start) {
        ForgeDirection back = MekanismUtils.getBack(this.facing);
        Coord4D current = start;
        for (int i = 1; i <= 4; ++i) {
            TileEntity tile = current.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!this.addTankPart(tile)) {
                return false;
            }
            current = current.getFromSide(back);
        }
        return true;
    }

    public boolean addTankPart(TileEntity tile) {
        if (tile instanceof TileEntitySalinationTank && (tile == this || !(tile instanceof TileEntitySalinationController))) {
            if (tile != this) {
                ((TileEntitySalinationTank)tile).addToStructure(this);
                this.tankParts.add((TileEntitySalinationTank)tile);
            }
            return true;
        }
        if (tile != this && tile instanceof TileEntitySalinationController) {
            this.controllerConflict = true;
        }
        return false;
    }

    public boolean addSolarPanel(TileEntity tile, int i) {
        if (tile instanceof ISalinationSolar && !tile.func_145837_r()) {
            this.solars[i] = (ISalinationSolar)tile;
            return true;
        }
        return false;
    }

    public int getScaledWaterLevel(int i) {
        return this.getMaxWater() > 0 ? (this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount * i / this.getMaxWater() : 0) : 0;
    }

    public int getScaledBrineLevel(int i) {
        return this.brineTank.getFluid() != null ? this.brineTank.getFluid().amount * i / 10000 : 0;
    }

    public int getScaledTempLevel(int i) {
        return (int)(this.getMaxTemperature() == 0.0f ? 0.0f : this.getTemperature() * (float)i / this.getMaxTemperature());
    }

    public Coord4D getRenderLocation() {
        if (!this.structured) {
            return null;
        }
        ForgeDirection right = MekanismUtils.getRight(this.facing);
        Coord4D startPoint = Coord4D.get(this).getFromSide(right);
        startPoint = this.isLeftOnFace ? startPoint.getFromSide(right) : startPoint;
        startPoint = startPoint.getFromSide(right.getOpposite()).getFromSide(MekanismUtils.getBack(this.facing));
        startPoint.translate(0, -(this.height - 2), 0);
        return startPoint;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.refresh(true);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.waterTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.waterTank.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.brineTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.brineTank.setFluid(null);
        }
        boolean prev = this.structured;
        this.structured = dataStream.readBoolean();
        this.controllerConflict = dataStream.readBoolean();
        this.clientSolarAmount = dataStream.readInt();
        this.height = dataStream.readInt();
        this.temperature = dataStream.readFloat();
        this.biomeTemp = dataStream.readFloat();
        this.isLeftOnFace = dataStream.readBoolean();
        if (this.structured != prev) {
            this.waterTank.setCapacity(this.getMaxWater());
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.waterTank.getFluid() != null) {
            data.add(true);
            data.add(this.waterTank.getFluid().fluidID);
            data.add(this.waterTank.getFluid().amount);
        } else {
            data.add(false);
        }
        if (this.brineTank.getFluid() != null) {
            data.add(true);
            data.add(this.brineTank.getFluid().fluidID);
            data.add(this.brineTank.getFluid().amount);
        } else {
            data.add(false);
        }
        data.add(this.structured);
        data.add(this.controllerConflict);
        data.add(this.getActiveSolars());
        data.add(this.height);
        data.add(Float.valueOf(this.temperature));
        data.add(Float.valueOf(this.biomeTemp));
        data.add(this.isLeftOnFace);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.waterTank.readFromNBT(nbtTags.func_74775_l("waterTank"));
        this.brineTank.readFromNBT(nbtTags.func_74775_l("brineTank"));
        this.temperature = nbtTags.func_74760_g("temperature");
        this.partialWater = nbtTags.func_74769_h("partialWater");
        this.partialBrine = nbtTags.func_74769_h("partialBrine");
        this.cacheStructure = nbtTags.func_74767_n("cacheStructure");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("brineTank", (NBTBase)this.brineTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74776_a("temperature", this.temperature);
        nbtTags.func_74780_a("partialWater", this.partialWater);
        nbtTags.func_74780_a("partialBrine", this.partialBrine);
        nbtTags.func_74757_a("cacheStructure", this.structured);
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    public void clearStructure() {
        for (TileEntitySalinationTank tankPart : this.tankParts) {
            tankPart.controllerGone();
        }
        this.tankParts.clear();
        this.solars = new ISalinationSolar[]{null, null, null, null};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

