/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.Teleporter;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IPeripheral {
    private MinecraftServer server = MinecraftServer.func_71276_C();
    public Teleporter.Code code;
    public AxisAlignedBB teleportBounds = null;
    public Set<Entity> didTeleport = new HashSet<Entity>();
    public int teleDelay = 0;
    public boolean shouldRender;
    public boolean prevShouldRender;
    public byte status = 0;

    public TileEntityTeleporter() {
        super("Teleporter", BlockMachine.MachineType.TELEPORTER.baseEnergy);
        this.inventory = new ItemStack[1];
        this.code = new Teleporter.Code(0, 0, 0, 0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.teleportBounds == null) {
            this.resetBounds();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (!Mekanism.teleporters.get(this.code).contains(Coord4D.get(this)) && this.hasFrame()) {
                    Mekanism.teleporters.get(this.code).add(Coord4D.get(this));
                } else if (Mekanism.teleporters.get(this.code).contains(Coord4D.get(this)) && !this.hasFrame()) {
                    Mekanism.teleporters.get(this.code).remove(Coord4D.get(this));
                }
            } else if (this.hasFrame()) {
                ArrayList<Coord4D> newCoords = new ArrayList<Coord4D>();
                newCoords.add(Coord4D.get(this));
                Mekanism.teleporters.put(this.code, newCoords);
            }
            this.status = this.canTeleport();
            if (this.status == 1 && this.teleDelay == 0) {
                this.teleport();
            }
            if (this.teleDelay == 0 && this.didTeleport.size() > 0) {
                this.cleanTeleportCache();
            }
            boolean bl = this.shouldRender = this.status == 1 || this.status > 4;
            if (this.shouldRender != this.prevShouldRender) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            this.prevShouldRender = this.shouldRender;
            this.teleDelay = Math.max(0, this.teleDelay - 1);
        }
        ChargeUtils.discharge(0, this);
    }

    public String getStatusDisplay() {
        switch (this.status) {
            case 1: {
                return (Object)((Object)EnumColor.DARK_GREEN) + MekanismUtils.localize("gui.teleporter.ready");
            }
            case 2: {
                return (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.teleporter.noFrame");
            }
            case 3: {
                return (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.teleporter.noLink");
            }
            case 4: {
                return (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.teleporter.exceeds");
            }
            case 5: {
                return (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.teleporter.needsEnergy");
            }
            case 6: {
                return (Object)((Object)EnumColor.DARK_GREEN) + MekanismUtils.localize("gui.idle");
            }
        }
        return (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.teleporter.noLink");
    }

    public void cleanTeleportCache() {
        List list = this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds);
        Set teleportCopy = (Set)((HashSet)this.didTeleport).clone();
        for (Entity entity : teleportCopy) {
            if (list.contains(entity)) continue;
            this.didTeleport.remove(entity);
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    public void resetBounds() {
        this.teleportBounds = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (!Mekanism.teleporters.containsKey(this.code) || Mekanism.teleporters.get(this.code).isEmpty()) {
            return 3;
        }
        if (Mekanism.teleporters.get(this.code).size() > 2) {
            return 4;
        }
        if (Mekanism.teleporters.get(this.code).size() == 2) {
            List<Entity> entitiesInPortal = this.getToTeleport();
            Coord4D closestCoords = null;
            for (Coord4D coords : Mekanism.teleporters.get(this.code)) {
                if (coords.equals(Coord4D.get(this))) continue;
                closestCoords = coords;
                break;
            }
            int electricityNeeded = 0;
            for (Entity entity : entitiesInPortal) {
                electricityNeeded += this.calculateEnergyCost(entity, closestCoords);
            }
            if (entitiesInPortal.size() == 0) {
                return 6;
            }
            if (this.getEnergy() < (double)electricityNeeded) {
                return 5;
            }
            return 1;
        }
        return 3;
    }

    public void teleport() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Coord4D closestCoords = null;
        for (Coord4D coords : Mekanism.teleporters.get(this.code)) {
            if (coords.equals(Coord4D.get(this))) continue;
            closestCoords = coords;
            break;
        }
        for (Entity entity : entitiesInPortal) {
            WorldServer teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(closestCoords.dimensionId);
            TileEntityTeleporter teleporter = (TileEntityTeleporter)closestCoords.getTileEntity((IBlockAccess)teleWorld);
            if (teleporter == null) continue;
            teleporter.didTeleport.add(entity);
            teleporter.teleDelay = 5;
            if (entity instanceof EntityPlayerMP) {
                this.teleportPlayerTo((EntityPlayerMP)entity, closestCoords, teleporter);
            } else {
                this.teleportEntityTo(entity, closestCoords, teleporter);
            }
            for (Coord4D coords : Mekanism.teleporters.get(this.code)) {
                Mekanism.packetHandler.sendToReceivers(new PacketPortalFX.PortalFXMessage(coords), new Range4D(coords));
            }
            this.setEnergy(this.getEnergy() - (double)this.calculateEnergyCost(entity, closestCoords));
            this.field_145850_b.func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    public void teleportPlayerTo(EntityPlayerMP player, Coord4D coord, TileEntityTeleporter teleporter) {
        if (player.field_71093_bK != coord.dimensionId) {
            int id = player.field_71093_bK;
            WorldServer oldWorld = this.server.func_71218_a(player.field_71093_bK);
            player.field_71093_bK = coord.dimensionId;
            WorldServer newWorld = this.server.func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            oldWorld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            if (player.func_70089_S()) {
                newWorld.func_72838_d((Entity)player);
                player.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
                newWorld.func_72866_a((Entity)player, false);
                player.func_70029_a((World)newWorld);
            }
            this.server.func_71203_ab().func_72375_a(player, oldWorld);
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(newWorld);
            this.server.func_71203_ab().func_72354_b(player, newWorld);
            this.server.func_71203_ab().func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, id, coord.dimensionId);
        } else {
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
        }
    }

    public void teleportEntityTo(Entity entity, Coord4D coord, TileEntityTeleporter teleporter) {
        WorldServer world = this.server.func_71218_a(coord.dimensionId);
        if (entity.field_70170_p.field_73011_w.field_76574_g != coord.dimensionId) {
            entity.field_70170_p.func_72900_e(entity);
            entity.field_70128_L = false;
            world.func_72838_d(entity);
            entity.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, entity.field_70177_z, entity.field_70125_A);
            world.func_72866_a(entity, false);
            entity.func_70029_a((World)world);
            world.func_82742_i();
            Entity e = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)world);
            if (e != null) {
                e.func_82141_a(entity, true);
                world.func_72838_d(e);
                teleporter.didTeleport.add(e);
            }
            entity.field_70128_L = true;
        }
    }

    public List<Entity> getToTeleport() {
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (this.didTeleport.contains(entity)) continue;
            ret.add(entity);
        }
        return ret;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && Mekanism.teleporters.containsKey(this.code)) {
            if (Mekanism.teleporters.get(this.code).contains(Coord4D.get(this))) {
                Mekanism.teleporters.get(this.code).remove(Coord4D.get(this));
            }
            if (Mekanism.teleporters.get(this.code).isEmpty()) {
                Mekanism.teleporters.remove(this.code);
            }
        }
    }

    public int calculateEnergyCost(Entity entity, Coord4D coords) {
        int energyCost = 1000;
        if (entity.field_70170_p.field_73011_w.field_76574_g != coords.dimensionId) {
            energyCost += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return energyCost += distance * 10;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 3, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 3, this.field_145849_e) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
            return true;
        }
        return this.isFrame(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
    }

    public boolean isFrame(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Mekanism.BasicBlock && this.field_145850_b.func_72805_g(x, y, z) == 7;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.code.digitOne = nbtTags.func_74762_e("digitOne");
        this.code.digitTwo = nbtTags.func_74762_e("digitTwo");
        this.code.digitThree = nbtTags.func_74762_e("digitThree");
        this.code.digitFour = nbtTags.func_74762_e("digitFour");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("digitOne", this.code.digitOne);
        nbtTags.func_74768_a("digitTwo", this.code.digitTwo);
        nbtTags.func_74768_a("digitThree", this.code.digitThree);
        nbtTags.func_74768_a("digitFour", this.code.digitFour);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type;
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (Mekanism.teleporters.get(this.code).contains(Coord4D.get(this))) {
                    Mekanism.teleporters.get(this.code).remove(Coord4D.get(this));
                }
                if (Mekanism.teleporters.get(this.code).isEmpty()) {
                    Mekanism.teleporters.remove(this.code);
                }
            }
            if ((type = dataStream.readInt()) == 0) {
                this.code.digitOne = dataStream.readInt();
            } else if (type == 1) {
                this.code.digitTwo = dataStream.readInt();
            } else if (type == 2) {
                this.code.digitThree = dataStream.readInt();
            } else if (type == 3) {
                this.code.digitFour = dataStream.readInt();
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.status = dataStream.readByte();
        this.code.digitOne = dataStream.readInt();
        this.code.digitTwo = dataStream.readInt();
        this.code.digitThree = dataStream.readInt();
        this.code.digitFour = dataStream.readInt();
        this.shouldRender = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.status);
        data.add(this.code.digitOne);
        data.add(this.code.digitTwo);
        data.add(this.code.digitThree);
        data.add(this.code.digitFour);
        data.add(this.shouldRender);
        return data;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return ChargeUtils.canBeOutputted(itemstack, false);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "canTeleport", "getMaxEnergy", "getEnergyNeeded", "teleport", "set"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        block0 : switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 5: {
                if (!(arguments[0] instanceof Double) || !(arguments[1] instanceof Double)) {
                    return new Object[]{"Invalid parameters."};
                }
                int digit = ((Double)arguments[0]).intValue();
                int newDigit = ((Double)arguments[1]).intValue();
                switch (digit) {
                    case 0: {
                        this.code.digitOne = newDigit;
                        break block0;
                    }
                    case 1: {
                        this.code.digitTwo = newDigit;
                        break block0;
                    }
                    case 2: {
                        this.code.digitThree = newDigit;
                        break block0;
                    }
                    case 3: {
                        this.code.digitFour = newDigit;
                        break block0;
                    }
                }
                return new Object[]{"No digit found."};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

