/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.IEjector;
import mekanism.common.IInvConfiguration;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.ITileComponent;
import mekanism.common.SideData;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileComponentEjector
implements ITileComponent,
IEjector {
    public TileEntityContainerBlock tileEntity;
    public boolean strictInput;
    public boolean ejecting;
    public EnumColor outputColor;
    public EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    public int tickDelay = 0;
    public SideData sideData;
    public int[] trackers;

    public TileComponentEjector(TileEntityContainerBlock tile, SideData data) {
        this.tileEntity = tile;
        this.sideData = data;
        this.trackers = new int[this.sideData.availableSlots.length];
        tile.components.add(this);
    }

    private List<ForgeDirection> getTrackedOutputs(int index, List<ForgeDirection> dirs) {
        ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>();
        for (int i = this.trackers[index] + 1; i <= this.trackers[index] + 6; ++i) {
            for (ForgeDirection side : dirs) {
                if (ForgeDirection.getOrientation((int)(i % 6)) != side) continue;
                sides.add(side);
            }
        }
        return sides;
    }

    @Override
    public void tick() {
        if (this.tickDelay == 0) {
            this.onOutput();
        } else {
            --this.tickDelay;
        }
    }

    @Override
    public void onOutput() {
        if (!this.ejecting || this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        ArrayList<ForgeDirection> outputSides = new ArrayList<ForgeDirection>();
        IInvConfiguration configurable = (IInvConfiguration)((Object)this.tileEntity);
        for (int i = 0; i < configurable.getConfiguration().length; ++i) {
            if (configurable.getConfiguration()[i] != configurable.getSideData().indexOf(this.sideData)) continue;
            outputSides.add(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(i, this.tileEntity.facing)));
        }
        for (int index = 0; index < this.sideData.availableSlots.length; ++index) {
            int slotID = this.sideData.availableSlots[index];
            if (this.tileEntity.inventory[slotID] == null) continue;
            ItemStack stack = this.tileEntity.inventory[slotID];
            List<ForgeDirection> outputs = this.getTrackedOutputs(index, outputSides);
            for (ForgeDirection side : outputs) {
                ItemStack rejects;
                TileEntity tile = Coord4D.get(this.tileEntity).getFromSide(side).getTileEntity((IBlockAccess)this.tileEntity.func_145831_w());
                ItemStack prev = stack.func_77946_l();
                if (tile instanceof IInventory && !(tile instanceof ILogisticalTransporter)) {
                    stack = InventoryUtils.putStackInInventory((IInventory)tile, stack, side.ordinal(), false);
                } else if (tile instanceof ILogisticalTransporter && TransporterManager.didEmit(stack, rejects = TransporterUtils.insert(this.tileEntity, (ILogisticalTransporter)tile, stack, this.outputColor, true, 0))) {
                    stack = rejects;
                }
                if (stack == null || prev.field_77994_a != stack.field_77994_a) {
                    this.trackers[index] = side.ordinal();
                }
                if (stack != null) continue;
                break;
            }
            this.tileEntity.inventory[slotID] = stack;
            this.tileEntity.func_70296_d();
        }
        this.tickDelay = 20;
    }

    @Override
    public boolean isEjecting() {
        return this.ejecting;
    }

    @Override
    public void setEjecting(boolean eject) {
        this.ejecting = eject;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    @Override
    public boolean hasStrictInput() {
        return this.strictInput;
    }

    @Override
    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    @Override
    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    @Override
    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    @Override
    public void setInputColor(ForgeDirection side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    @Override
    public EnumColor getInputColor(ForgeDirection side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        int i;
        this.ejecting = nbtTags.func_74767_n("ejecting");
        this.strictInput = nbtTags.func_74767_n("strictInput");
        if (nbtTags.func_74764_b("ejectColor")) {
            this.outputColor = TransporterUtils.colors.get(nbtTags.func_74762_e("ejectColor"));
        }
        for (i = 0; i < this.sideData.availableSlots.length; ++i) {
            this.trackers[i] = nbtTags.func_74762_e("tracker" + i);
        }
        for (i = 0; i < 6; ++i) {
            if (!nbtTags.func_74764_b("inputColors" + i)) continue;
            int inC = nbtTags.func_74762_e("inputColors" + i);
            this.inputColors[i] = inC != -1 ? TransporterUtils.colors.get(inC) : null;
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.ejecting = dataStream.readBoolean();
        this.strictInput = dataStream.readBoolean();
        int c = dataStream.readInt();
        this.outputColor = c != -1 ? TransporterUtils.colors.get(c) : null;
        for (int i = 0; i < 6; ++i) {
            int inC = dataStream.readInt();
            this.inputColors[i] = inC != -1 ? TransporterUtils.colors.get(inC) : null;
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        int i;
        nbtTags.func_74757_a("ejecting", this.ejecting);
        nbtTags.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            nbtTags.func_74768_a("ejectColor", TransporterUtils.colors.indexOf((Object)this.outputColor));
        }
        for (i = 0; i < this.sideData.availableSlots.length; ++i) {
            nbtTags.func_74768_a("tracker" + i, this.trackers[i]);
        }
        for (i = 0; i < 6; ++i) {
            if (this.inputColors[i] == null) {
                nbtTags.func_74768_a("inputColors" + i, -1);
                continue;
            }
            nbtTags.func_74768_a("inputColors" + i, TransporterUtils.colors.indexOf((Object)this.inputColors[i]));
        }
    }

    @Override
    public void write(ArrayList data) {
        data.add(this.ejecting);
        data.add(this.strictInput);
        if (this.outputColor != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.outputColor));
        } else {
            data.add(-1);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.inputColors[i] == null) {
                data.add(-1);
                continue;
            }
            data.add(TransporterUtils.colors.indexOf((Object)this.inputColors[i]));
        }
    }
}

