/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import java.util.List;
import mekanism.api.StackUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public abstract class Finder {
    public abstract boolean modifies(ItemStack var1);

    public static class ModIDFinder
    extends Finder {
        public String modID;

        public ModIDFinder(String mod) {
            this.modID = mod;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) {
                return false;
            }
            String id = MekanismUtils.getMod(stack);
            if (this.modID.equals(id) || this.modID.equals("*")) {
                return true;
            }
            return this.modID.endsWith("*") && !this.modID.startsWith("*") ? id.startsWith(this.modID.substring(0, this.modID.length() - 1)) : (this.modID.startsWith("*") && !this.modID.endsWith("*") ? id.endsWith(this.modID.substring(1)) : this.modID.startsWith("*") && this.modID.endsWith("*") && id.contains(this.modID.substring(1, this.modID.length() - 1)));
        }
    }

    public static class MaterialFinder
    extends Finder {
        public Material materialType;

        public MaterialFinder(Material type) {
            this.materialType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) {
                return false;
            }
            return Block.func_149634_a((Item)stack.func_77973_b()).func_149688_o() == this.materialType;
        }
    }

    public static class ItemStackFinder
    extends Finder {
        public ItemStack itemType;

        public ItemStackFinder(ItemStack type) {
            this.itemType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            return StackUtils.equalsWildcard(this.itemType, stack);
        }
    }

    public static class OreDictFinder
    extends Finder {
        public String oreDictName;

        public OreDictFinder(String name) {
            this.oreDictName = name;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            List<String> oreKeys = MekanismUtils.getOreDictName(stack);
            if (oreKeys.isEmpty()) {
                return false;
            }
            for (String oreKey : oreKeys) {
                if (this.oreDictName.equals(oreKey) || this.oreDictName.equals("*")) {
                    return true;
                }
                if (!(this.oreDictName.endsWith("*") && !this.oreDictName.startsWith("*") ? oreKey.startsWith(this.oreDictName.substring(0, this.oreDictName.length() - 1)) : (this.oreDictName.startsWith("*") && !this.oreDictName.endsWith("*") ? oreKey.endsWith(this.oreDictName.substring(1)) : this.oreDictName.startsWith("*") && this.oreDictName.endsWith("*") && oreKey.contains(this.oreDictName.substring(1, this.oreDictName.length() - 1))))) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstFinder
    extends Finder {
        @Override
        public boolean modifies(ItemStack stack) {
            return true;
        }
    }
}

