/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TItemStackFilter;
import mekanism.common.transporter.TMaterialFilter;
import mekanism.common.transporter.TModIDFilter;
import mekanism.common.transporter.TOreDictFilter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TransporterFilter {
    public EnumColor color;

    public abstract boolean canFilter(ItemStack var1);

    public abstract InvStack getStackFromInventory(IInventory var1, ForgeDirection var2);

    public void write(NBTTagCompound nbtTags) {
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
    }

    protected void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
    }

    public void write(ArrayList data) {
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
    }

    protected void read(ByteBuf dataStream) {
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
    }

    public static TransporterFilter readFromNBT(NBTTagCompound nbtTags) {
        int type = nbtTags.func_74762_e("type");
        TransporterFilter filter = null;
        if (type == 0) {
            filter = new TItemStackFilter();
        } else if (type == 1) {
            filter = new TOreDictFilter();
        } else if (type == 2) {
            filter = new TMaterialFilter();
        } else if (type == 3) {
            filter = new TModIDFilter();
        }
        ((TransporterFilter)filter).read(nbtTags);
        return filter;
    }

    public static TransporterFilter readFromPacket(ByteBuf dataStream) {
        int type = dataStream.readInt();
        TransporterFilter filter = null;
        if (type == 0) {
            filter = new TItemStackFilter();
        } else if (type == 1) {
            filter = new TOreDictFilter();
        } else if (type == 2) {
            filter = new TMaterialFilter();
        } else if (type == 3) {
            filter = new TModIDFilter();
        }
        ((TransporterFilter)filter).read(dataStream);
        return filter;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + (this.color != null ? this.color.ordinal() : -1);
        return code;
    }

    public boolean equals(Object filter) {
        return filter instanceof TransporterFilter && ((TransporterFilter)filter).color == this.color;
    }
}

