/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerEmitter;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class CableUtils {
    private static Set<ForgeDirection> allSides = EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN));

    public static TileEntity[] getConnectedEnergyAcceptors(TileEntity tileEntity) {
        TileEntity[] acceptors = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!CableUtils.isEnergyAcceptor(acceptor)) continue;
            acceptors[orientation.ordinal()] = acceptor;
        }
        return acceptors;
    }

    public static boolean isEnergyAcceptor(TileEntity tileEntity) {
        return tileEntity instanceof IStrictEnergyAcceptor || MekanismUtils.useIC2() && tileEntity instanceof IEnergySink || MekanismUtils.useBuildCraft() && MjAPI.getMjBattery((Object)tileEntity) != null && !(tileEntity instanceof IGridTransmitter) || MekanismUtils.useRF() && tileEntity instanceof IEnergyHandler;
    }

    public static TileEntity[] getConnectedCables(TileEntity tileEntity) {
        TileEntity[] cables = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity cable = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!CableUtils.isCable(cable)) continue;
            cables[orientation.ordinal()] = cable;
        }
        return cables;
    }

    public static boolean isCable(TileEntity tileEntity) {
        return TransmissionType.checkTransmissionType(tileEntity, TransmissionType.ENERGY);
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        return CableUtils.getConnections(tileEntity, allSides);
    }

    public static boolean[] getConnections(TileEntity tileEntity, Set<ForgeDirection> sides) {
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        Coord4D coord = Coord4D.get(tileEntity);
        for (ForgeDirection side : sides) {
            TileEntity tile = coord.getFromSide(side).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            int n = side.ordinal();
            connectable[n] = connectable[n] | (CableUtils.isEnergyAcceptor(tile) && CableUtils.isConnectable(tileEntity, tile, side));
            int n2 = side.ordinal();
            connectable[n2] = connectable[n2] | CableUtils.isCable(tile);
            int n3 = side.ordinal();
            connectable[n3] = connectable[n3] | CableUtils.isOutputter(tile, side);
        }
        return connectable;
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity outputter = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!CableUtils.isOutputter(outputter, orientation)) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean isOutputter(TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ICableOutputter && ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) || MekanismUtils.useIC2() && tileEntity instanceof IEnergySource && ((IEnergySource)tileEntity).emitsEnergyTo(null, side.getOpposite()) || MekanismUtils.useRF() && tileEntity instanceof IEnergyHandler && ((IEnergyHandler)tileEntity).canConnectEnergy(side.getOpposite()) || MekanismUtils.useRF() && tileEntity instanceof IEnergyConnection && ((IEnergyConnection)tileEntity).canConnectEnergy(side.getOpposite()) || MekanismUtils.useBuildCraft() && tileEntity instanceof IPowerEmitter && ((IPowerEmitter)tileEntity).canEmitPowerFrom(side.getOpposite());
    }

    public static boolean canConnectToAcceptor(ForgeDirection side, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        TileEntity tileEntity = Coord4D.get(tile).getFromSide(side).getTileEntity((IBlockAccess)tile.func_145831_w());
        return CableUtils.isConnectable(tile, tileEntity, side);
    }

    public static boolean isConnectable(TileEntity orig, TileEntity tileEntity, ForgeDirection side) {
        if (tileEntity instanceof IGridTransmitter) {
            return false;
        }
        return tileEntity instanceof IStrictEnergyAcceptor ? ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(side.getOpposite()) : (MekanismUtils.useIC2() && tileEntity instanceof IEnergyAcceptor ? ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(orig, side.getOpposite()) : (tileEntity instanceof ICableOutputter ? ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) : (MekanismUtils.useRF() && tileEntity instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity).canConnectEnergy(side.getOpposite()) : MekanismUtils.useBuildCraft() && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite()) != null)));
    }

    public static void emit(TileEntityElectricBlock emitter) {
        double energyToSend;
        if (!emitter.func_145831_w().field_72995_K && MekanismUtils.canFunction(emitter) && (energyToSend = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            ArrayList<ForgeDirection> outputtingSides = new ArrayList<ForgeDirection>();
            boolean[] connectable = CableUtils.getConnections(emitter, emitter.getOutputtingSides());
            for (ForgeDirection side : emitter.getOutputtingSides()) {
                if (!connectable[side.ordinal()]) continue;
                outputtingSides.add(side);
            }
            if (outputtingSides.size() > 0) {
                double sent = 0.0;
                boolean tryAgain = false;
                do {
                    tryAgain = false;
                    double prev = sent;
                    if (!(energyToSend - (sent += CableUtils.emit_do(emitter, outputtingSides, energyToSend - sent, tryAgain)) > 0.0) || !(sent - prev > 0.0)) continue;
                    tryAgain = true;
                } while (tryAgain);
                emitter.setEnergy(emitter.getEnergy() - sent);
            }
        }
    }

    private static double emit_do(TileEntityElectricBlock emitter, List<ForgeDirection> outputtingSides, double totalToSend, boolean tryAgain) {
        double remains = totalToSend % (double)outputtingSides.size();
        double splitSend = (totalToSend - remains) / (double)outputtingSides.size();
        double sent = 0.0;
        ArrayList<ForgeDirection> toRemove = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : outputtingSides) {
            TileEntity tileEntity = Coord4D.get(emitter).getFromSide(side).getTileEntity((IBlockAccess)emitter.func_145831_w());
            double toSend = splitSend + remains;
            remains = 0.0;
            double prev = sent;
            if ((sent += CableUtils.emit_do_do(emitter, tileEntity, side, toSend, tryAgain)) - prev != 0.0) continue;
            toRemove.add(side);
        }
        for (ForgeDirection side : toRemove) {
            outputtingSides.remove(side);
        }
        return sent;
    }

    private static double emit_do_do(TileEntityElectricBlock from, TileEntity tileEntity, ForgeDirection side, double currentSending, boolean tryAgain) {
        double sent = 0.0;
        if (tileEntity instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor acceptor = (IStrictEnergyAcceptor)tileEntity;
            if (acceptor.canReceiveEnergy(side.getOpposite())) {
                sent += acceptor.transferEnergyToAcceptor(side.getOpposite(), currentSending);
            }
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            if (handler.canConnectEnergy(side.getOpposite())) {
                int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(currentSending * Mekanism.TO_TE), false);
                sent += (double)used * Mekanism.FROM_TE;
            }
        } else if (MekanismUtils.useIC2() && tileEntity instanceof IEnergySink) {
            if (((IEnergySink)tileEntity).acceptsEnergyFrom((TileEntity)from, side.getOpposite())) {
                double toSend = Math.min(currentSending, EnergyNet.instance.getPowerFromTier(((IEnergySink)tileEntity).getSinkTier()) * Mekanism.FROM_IC2);
                toSend = Math.min(toSend, ((IEnergySink)tileEntity).getDemandedEnergy() * Mekanism.FROM_IC2);
                sent += toSend - ((IEnergySink)tileEntity).injectEnergy(side.getOpposite(), toSend * Mekanism.TO_IC2, 0.0) * Mekanism.FROM_IC2;
            }
        } else if (MekanismUtils.useBuildCraft() && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite()) != null && !tryAgain) {
            IBatteryObject battery = MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite());
            double toSend = battery.addEnergy(Math.min(battery.getEnergyRequested(), currentSending * Mekanism.TO_BC));
            sent += toSend * Mekanism.FROM_BC;
        }
        return sent;
    }
}

