/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class ChargeUtils {
    public static void discharge(int slotID, TileEntityElectricBlock storer) {
        if (storer.inventory[slotID] != null && storer.getEnergy() < storer.getMaxEnergy()) {
            if (storer.inventory[slotID].func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(storer.inventory[slotID], storer.getMaxEnergy() - storer.getEnergy()));
            } else if (MekanismUtils.useIC2() && storer.inventory[slotID].func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)storer.inventory[slotID].func_77973_b();
                if (item.canProvideEnergy(storer.inventory[slotID])) {
                    double gain = ElectricItem.manager.discharge(storer.inventory[slotID], (double)((int)((storer.getMaxEnergy() - storer.getEnergy()) * Mekanism.TO_IC2)), 4, true, true, false) * Mekanism.FROM_IC2;
                    storer.setEnergy(storer.getEnergy() + gain);
                }
            } else if (MekanismUtils.useRF() && storer.inventory[slotID].func_77973_b() instanceof IEnergyContainerItem) {
                ItemStack itemStack = storer.inventory[slotID];
                IEnergyContainerItem item = (IEnergyContainerItem)storer.inventory[slotID].func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack)));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, (storer.getMaxEnergy() - storer.getEnergy()) * Mekanism.TO_TE));
                storer.setEnergy(storer.getEnergy() + (double)item.extractEnergy(itemStack, toTransfer, false) * Mekanism.FROM_TE);
            } else if (storer.inventory[slotID].func_77973_b() == Items.field_151137_ax && storer.getEnergy() + Mekanism.ENERGY_PER_REDSTONE <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + Mekanism.ENERGY_PER_REDSTONE);
                --storer.inventory[slotID].field_77994_a;
                if (storer.inventory[slotID].field_77994_a <= 0) {
                    storer.inventory[slotID] = null;
                }
            }
        }
    }

    public static void charge(int slotID, TileEntityElectricBlock storer) {
        if (storer.inventory[slotID] != null && storer.getEnergy() > 0.0) {
            if (storer.inventory[slotID].func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(storer.inventory[slotID], storer.getEnergy()));
            } else if (Mekanism.hooks.IC2APILoaded && storer.inventory[slotID].func_77973_b() instanceof IElectricItem) {
                double sent = ElectricItem.manager.charge(storer.inventory[slotID], (double)((int)(storer.getEnergy() * Mekanism.TO_IC2)), 4, true, false) * Mekanism.FROM_IC2;
                storer.setEnergy(storer.getEnergy() - sent);
            } else if (MekanismUtils.useRF() && storer.inventory[slotID].func_77973_b() instanceof IEnergyContainerItem) {
                ItemStack itemStack = storer.inventory[slotID];
                IEnergyContainerItem item = (IEnergyContainerItem)storer.inventory[slotID].func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)(item.getMaxEnergyStored(itemStack) - item.getEnergyStored(itemStack))));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, storer.getEnergy() * Mekanism.TO_TE));
                storer.setEnergy(storer.getEnergy() - (double)item.receiveEnergy(itemStack, toTransfer, false) * Mekanism.FROM_TE);
            }
        }
    }

    public static boolean canBeDischarged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canSend(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).extractEnergy(itemstack, 1, true) != 0 || itemstack.func_77973_b() == Items.field_151137_ax;
    }

    public static boolean canBeCharged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canReceive(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, 1, true) != 0;
    }

    public static boolean canBeOutputted(ItemStack itemstack, boolean chargeSlot) {
        if (chargeSlot) {
            return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem;
        }
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack);
    }
}

