/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.EnergyDisplay;
import mekanism.common.IActiveState;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IModule;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeManagement;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.Teleporter;
import mekanism.common.Tier;
import mekanism.common.Version;
import mekanism.common.inventory.container.ContainerElectricChest;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.tank.DynamicTankCache;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityElectricChest;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class MekanismUtils {
    public static final ForgeDirection[] SIDE_DIRS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    public static boolean checkForUpdates(EntityPlayer entityplayer) {
        try {
            if (Mekanism.updateNotifications && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null) {
                if (!Mekanism.latestVersionNumber.equals("null")) {
                    ArrayList<IModule> list = new ArrayList<IModule>();
                    for (IModule module : Mekanism.modulesLoaded) {
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(module.getVersion()) != 1) continue;
                        list.add(module);
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1 || !list.isEmpty()) {
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("update.outdated") + "."));
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1) {
                            entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.INDIGO) + " Mekanism: " + (Object)((Object)EnumColor.DARK_RED) + Mekanism.versionNumber));
                        }
                        for (IModule module : list) {
                            entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.INDIGO) + " Mekanism" + module.getName() + ": " + (Object)((Object)EnumColor.DARK_RED) + module.getVersion()));
                        }
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("update.consider") + " " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.latestVersionNumber));
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("update.newFeatures") + ": " + (Object)((Object)EnumColor.INDIGO) + Mekanism.recentNews));
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("update.visit") + " " + (Object)((Object)EnumColor.DARK_GREY) + "aidancbrady.com/mekanism" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("update.toDownload") + "."));
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        return true;
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == -1) {
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + MekanismUtils.localize("update.devBuild") + " " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber));
                        return true;
                    }
                } else {
                    Mekanism.logger.info("Minecraft is in offline mode, could not check for updates.");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getLatestVersion() {
        String[] text = MekanismUtils.merge(MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt")).split(":");
        if (!(text[0].contains("UTF-8") || text[0].contains("HTML") || text[0].contains("http"))) {
            return text[0];
        }
        return "null";
    }

    public static String getRecentNews() {
        String[] text = MekanismUtils.merge(MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt")).split(":");
        if (!(text.length <= 1 || text[1].contains("UTF-8") || text[1].contains("HTML") || text[1].contains("http"))) {
            return text[1];
        }
        return "null";
    }

    public static void updateDonators() {
        Mekanism.donators.clear();
        for (String s : MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Donators/Mekanism.txt")) {
            Mekanism.donators.add(s);
        }
    }

    public static List<String> getHTML(String urlToRead) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.add(line.trim());
            }
            rd.close();
        }
        catch (Exception e) {
            result.clear();
            result.add("null");
            Mekanism.logger.error("An error occured while connecting to URL '" + urlToRead + ".'");
        }
        return result;
    }

    public static String merge(List<String> text) {
        StringBuilder builder = new StringBuilder();
        for (String s : text) {
            builder.append(s);
        }
        return builder.toString();
    }

    public static Coord4D getClosestCoords(Teleporter.Code teleCode, EntityPlayer player) {
        if (Mekanism.teleporters.get(teleCode).size() == 1) {
            return Mekanism.teleporters.get(teleCode).get(0);
        }
        int dimensionId = player.field_70170_p.field_73011_w.field_76574_g;
        Coord4D coords0 = Mekanism.teleporters.get(teleCode).get(0);
        Coord4D coords1 = Mekanism.teleporters.get(teleCode).get(1);
        int distance0 = (int)player.func_70011_f((double)coords0.xCoord, (double)coords0.yCoord, (double)coords0.zCoord);
        int distance1 = (int)player.func_70011_f((double)coords1.xCoord, (double)coords1.yCoord, (double)coords1.zCoord);
        if (dimensionId == coords0.dimensionId && dimensionId != coords1.dimensionId) {
            return coords0;
        }
        if (dimensionId == coords1.dimensionId && dimensionId != coords0.dimensionId) {
            return coords1;
        }
        if (dimensionId == coords0.dimensionId && dimensionId == coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        } else if (dimensionId != coords0.dimensionId && dimensionId != coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        }
        return null;
    }

    public static boolean noUpdates() {
        if (Mekanism.latestVersionNumber.contains("null")) {
            return true;
        }
        if (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1) {
            return false;
        }
        for (IModule module : Mekanism.modulesLoaded) {
            if (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isOffline() {
        try {
            new URL("http://www.apple.com").openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void doFakeEntityExplosion(EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        world.func_72869_a("hugeexplosion", entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 0.0, 0.0, 0.0);
        world.func_72956_a((Entity)entityplayer, "random.explode", 1.0f, 1.0f);
    }

    public static void doFakeBlockExplosion(World world, int x, int y, int z) {
        world.func_72869_a("hugeexplosion", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        world.func_72980_b((double)x, (double)y, (double)z, "random.explode", 1.0f, 1.0f, true);
    }

    public static ItemStack size(ItemStack itemstack, int size) {
        ItemStack newStack = itemstack.func_77946_l();
        newStack.field_77994_a = size;
        return newStack;
    }

    public static void addRecipe(ItemStack output, Object[] params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(output, params));
    }

    public static ItemStack getEnergyCube(Tier.EnergyCubeTier tier) {
        ItemStack itemstack = ((ItemBlockEnergyCube)new ItemStack(Mekanism.EnergyCube).func_77973_b()).getUnchargedItem(tier);
        return itemstack;
    }

    public static ItemStack getEmptyGasTank() {
        ItemStack itemstack = ((ItemBlockGasTank)new ItemStack(Mekanism.GasTank).func_77973_b()).getEmptyItem();
        return itemstack;
    }

    public static ItemStack getFactory(Tier.FactoryTier tier, IFactory.RecipeType type) {
        ItemStack itemstack = new ItemStack(Mekanism.MachineBlock, 1, 5 + tier.ordinal());
        ((IFactory)itemstack.func_77973_b()).setRecipeType(type.ordinal(), itemstack);
        return itemstack;
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static ForgeDirection getLeft(int orientation) {
        switch (orientation) {
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection getRight(int orientation) {
        return MekanismUtils.getLeft(orientation).getOpposite();
    }

    public static ForgeDirection getBack(int orientation) {
        return ForgeDirection.getOrientation((int)orientation).getOpposite();
    }

    public static boolean oreDictCheck(ItemStack check, String oreDict) {
        boolean hasResource = false;
        for (ItemStack ore : OreDictionary.getOres((String)oreDict)) {
            if (!ore.func_77969_a(check)) continue;
            hasResource = true;
        }
        return hasResource;
    }

    public static List<String> getOreDictName(ItemStack check) {
        return OreDictCache.getOreDictName(check);
    }

    public static int getBaseOrientation(int side, int blockFacing) {
        if (blockFacing == 3 || side == 1 || side == 0) {
            if (side == 2 || side == 3) {
                return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            return side;
        }
        if (blockFacing == 2) {
            if (side == 2 || side == 3) {
                return side;
            }
            return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
        }
        if (blockFacing == 4) {
            if (side == 2 || side == 3) {
                return MekanismUtils.getRight(side).ordinal();
            }
            return MekanismUtils.getLeft(side).ordinal();
        }
        if (blockFacing == 5) {
            if (side == 2 || side == 3) {
                return MekanismUtils.getLeft(side).ordinal();
            }
            return MekanismUtils.getRight(side).ordinal();
        }
        return side;
    }

    public static String localize(String s) {
        return StatCollector.func_74838_a((String)s);
    }

    public static void incrementOutput(IInvConfiguration config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current < max) {
            config.getConfiguration()[side] = (byte)(current + 1);
        } else if (current == max) {
            config.getConfiguration()[side] = 0;
        }
        TileEntity tile = (TileEntity)config;
        Coord4D coord = Coord4D.get(tile).getFromSide(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(side, config.getOrientation())));
        tile.func_145831_w().func_147460_e(coord.xCoord, coord.yCoord, coord.zCoord, tile.func_145838_q());
    }

    public static void decrementOutput(IInvConfiguration config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current > 0) {
            config.getConfiguration()[side] = (byte)(current - 1);
        } else if (current == 0) {
            config.getConfiguration()[side] = (byte)max;
        }
        TileEntity tile = (TileEntity)config;
        Coord4D coord = Coord4D.get(tile).getFromSide(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(side, config.getOrientation())));
        tile.func_145831_w().func_147460_e(coord.xCoord, coord.yCoord, coord.zCoord, tile.func_145838_q());
    }

    public static int getTicks(IUpgradeManagement mgmt, int def) {
        return (int)((double)def * Math.pow(Mekanism.maxUpgradeMultiplier, (double)(-mgmt.getSpeedMultiplier(new Object[0])) / 8.0));
    }

    public static double getEnergyPerTick(IUpgradeManagement mgmt, double def) {
        return def * Math.pow(Mekanism.maxUpgradeMultiplier, (double)(2 * mgmt.getSpeedMultiplier(new Object[0]) - mgmt.getEnergyMultiplier(new Object[0])) / 8.0);
    }

    public static int getSecondaryEnergyPerTick(IUpgradeManagement mgmt, int def) {
        return def * (int)Math.pow(Mekanism.maxUpgradeMultiplier, (double)mgmt.getSpeedMultiplier(new Object[0]) / 8.0);
    }

    public static double getMaxEnergy(IUpgradeManagement mgmt, double def) {
        return def * Math.pow(Mekanism.maxUpgradeMultiplier, (double)mgmt.getEnergyMultiplier(new Object[0]) / 8.0);
    }

    public static double getMaxEnergy(ItemStack itemStack, IUpgradeManagement mgmt, double def) {
        return def * Math.pow(Mekanism.maxUpgradeMultiplier, (double)mgmt.getEnergyMultiplier(itemStack) / 8.0);
    }

    public static void makeBoundingBlock(World world, int x, int y, int z, Coord4D orig) {
        world.func_147449_b(x, y, z, Mekanism.BoundingBlock);
        if (!world.field_72995_K) {
            ((TileEntityBoundingBlock)world.func_147438_o(x, y, z)).setMainLocation(orig.xCoord, orig.yCoord, orig.zCoord);
        }
    }

    public static void makeAdvancedBoundingBlock(World world, int x, int y, int z, Coord4D orig) {
        world.func_147465_d(x, y, z, Mekanism.BoundingBlock, 1, 0);
        if (!world.field_72995_K) {
            ((TileEntityAdvancedBoundingBlock)world.func_147438_o(x, y, z)).setMainLocation(orig.xCoord, orig.yCoord, orig.zCoord);
        }
    }

    public static void updateBlock(World world, int x, int y, int z) {
        if (!(world.func_147438_o(x, y, z) instanceof IActiveState) || ((IActiveState)world.func_147438_o(x, y, z)).renderUpdate()) {
            world.func_147479_m(x, y, z);
        }
        if (!(world.func_147438_o(x, y, z) instanceof IActiveState) || ((IActiveState)world.func_147438_o(x, y, z)).lightUpdate() && Mekanism.machineEffects) {
            MekanismUtils.updateAllLightTypes(world, x, y, z);
        }
    }

    public static void updateAllLightTypes(World world, int x, int y, int z) {
        world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        world.func_147463_c(EnumSkyBlock.Sky, x, y, z);
    }

    public static boolean isFluid(World world, int x, int y, int z) {
        return MekanismUtils.getFluid(world, x, y, z) != null;
    }

    public static FluidStack getFluid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null) {
            return null;
        }
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && meta == 0) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && meta == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (meta == 0) {
                return fluid.drain(world, x, y, z, false);
            }
        }
        return null;
    }

    public static int getFluidId(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null) {
            return 0;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER.getID();
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA.getID();
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid.getBlock() != block) continue;
            return fluid.getID();
        }
        return 0;
    }

    public static boolean isDeadFluid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null || meta == 0) {
            return false;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return true;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return true;
        }
        return block instanceof IFluidBlock;
    }

    public static Block getFlowingBlock(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid == FluidRegistry.WATER) {
            return Blocks.field_150358_i;
        }
        if (fluid == FluidRegistry.LAVA) {
            return Blocks.field_150356_k;
        }
        return fluid.getBlock();
    }

    public static void openElectricChestGui(EntityPlayerMP player, TileEntityElectricChest tileEntity, IInventory inventory, boolean isBlock) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        if (isBlock) {
            Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, true, false, 0, id, null, Coord4D.get(tileEntity)), player);
        } else {
            Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, false, false, 0, id, null, null), player);
        }
        player.field_71070_bA = new ContainerElectricChest(player.field_71071_by, tileEntity, inventory, isBlock);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static DynamicTankCache pullInventory(World world, int id) {
        DynamicTankCache toReturn = Mekanism.dynamicInventories.get(id);
        for (Coord4D obj : Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)id)).locations) {
            TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)world);
            if (tileEntity == null) continue;
            tileEntity.cachedData = new DynamicTankCache();
            tileEntity.inventory = new ItemStack[2];
            tileEntity.inventoryID = -1;
        }
        Mekanism.dynamicInventories.remove(id);
        return toReturn;
    }

    public static void updateCache(int inventoryID, DynamicTankCache cache, TileEntityDynamicTank tileEntity) {
        if (!Mekanism.dynamicInventories.containsKey(inventoryID)) {
            cache.locations.add(Coord4D.get(tileEntity));
            Mekanism.dynamicInventories.put(inventoryID, cache);
            return;
        }
        Mekanism.dynamicInventories.put(inventoryID, cache);
        Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID)).locations.add(Coord4D.get(tileEntity));
    }

    public static int getUniqueInventoryID() {
        int id = 0;
        for (Integer i : Mekanism.dynamicInventories.keySet()) {
            if (id != i) continue;
            ++id;
        }
        return id;
    }

    public static Object getPrivateValue(Object obj, Class c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                return f.get(obj);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static void setPrivateValue(Object obj, Object value, Class c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                f.set(obj, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Method getPrivateMethod(Class c, String[] methods, Class ... params) {
        for (String method : methods) {
            try {
                Method m = c.getDeclaredMethod(method, params);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return new ResourceLocation("mekanism", type.getPrefix() + name);
    }

    public static boolean removeRecipes(ItemStack ... itemStacks) {
        boolean didRemove = false;
        Iterator itr = CraftingManager.func_77594_a().func_77592_b().iterator();
        block0: while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof IRecipe) || ((IRecipe)obj).func_77571_b() == null) continue;
            for (ItemStack itemStack : itemStacks) {
                if (!((IRecipe)obj).func_77571_b().func_77969_a(itemStack)) continue;
                itr.remove();
                didRemove = true;
                continue block0;
            }
        }
        return didRemove;
    }

    public static void saveChunk(TileEntity tileEntity) {
        if (tileEntity == null || tileEntity.func_145837_r() || tileEntity.func_145831_w() == null) {
            return;
        }
        tileEntity.func_145831_w().func_147476_b(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity);
    }

    public static boolean canFunction(TileEntity tileEntity) {
        if (!(tileEntity instanceof IRedstoneControl)) {
            return true;
        }
        World world = tileEntity.func_145831_w();
        IRedstoneControl control = (IRedstoneControl)tileEntity;
        if (control.getControlType() == IRedstoneControl.RedstoneControl.DISABLED) {
            return true;
        }
        if (control.getControlType() == IRedstoneControl.RedstoneControl.HIGH) {
            return control.isPowered();
        }
        if (control.getControlType() == IRedstoneControl.RedstoneControl.LOW) {
            return !control.isPowered();
        }
        return false;
    }

    public static MovingObjectPosition rayTrace(World world, EntityPlayer player) {
        double reach = Mekanism.proxy.getReach(player);
        Vec3 headVec = MekanismUtils.getHeadVec(player);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_72901_a(headVec, endVec, true);
    }

    private static Vec3 getHeadVec(EntityPlayer player) {
        Vec3 vec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        if (!player.field_70170_p.field_72995_K) {
            vec.field_72448_b += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                vec.field_72448_b -= 0.08;
            }
        }
        return vec;
    }

    public static String getEnergyDisplay(double energy) {
        switch (Mekanism.activeType) {
            case J: {
                return EnergyDisplay.getDisplayShort(energy, EnergyDisplay.ElectricUnit.JOULES);
            }
            case RF: {
                return Math.round(energy * Mekanism.TO_TE) + " RF";
            }
            case EU: {
                return Math.round(energy * Mekanism.TO_IC2) + " EU";
            }
            case MJ: {
                return Math.round(energy * Mekanism.TO_BC * 100.0) / 100L + " MJ";
            }
        }
        return "error";
    }

    public static String getPowerDisplay(double energy) {
        return EnergyDisplay.getDisplayShort(energy, EnergyDisplay.ElectricUnit.WATT);
    }

    public static boolean useBuildCraft() {
        return Mekanism.hooks.BuildCraftPowerLoaded;
    }

    public static boolean useIC2() {
        return Mekanism.hooks.IC2Loaded;
    }

    public static boolean useRF() {
        return Mekanism.hooks.RedstoneFluxLoaded;
    }

    public static String getCoordDisplay(Coord4D obj) {
        return "[" + obj.xCoord + ", " + obj.yCoord + ", " + obj.zCoord + "]";
    }

    public static List<String> splitLines(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] split = s.split("!n");
        ret.addAll(Arrays.asList(split));
        return ret;
    }

    public static ItemStack getFullGasTank(Gas gas) {
        ItemStack tank = MekanismUtils.getEmptyGasTank();
        ItemBlockGasTank item = (ItemBlockGasTank)tank.func_77973_b();
        item.setGas(tank, new GasStack(gas, item.MAX_GAS));
        return tank;
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[0] == null || dmgItems[0].func_77973_b() == null) {
            return null;
        }
        if (dmgItems[1] != null && dmgItems[0].func_77973_b() == dmgItems[1].func_77973_b() && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && dmgItems[0].func_77973_b().isRepairable()) {
            Item theItem = dmgItems[0].func_77973_b();
            int dmgDiff0 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int dmgDiff1 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int value = dmgDiff0 + dmgDiff1 + theItem.func_77612_l() * 5 / 100;
            int solve = Math.max(0, theItem.func_77612_l() - value);
            return new ItemStack(dmgItems[0].func_77973_b(), 1, solve);
        }
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static boolean isChunkVibrated(Chunk3D chunk) {
        for (Coord4D coord : Mekanism.activeVibrators) {
            if (!coord.getChunk3D().equals(chunk)) continue;
            return true;
        }
        return false;
    }

    public static String getMod(ItemStack stack) {
        try {
            ModContainer mod = GameData.findModOwner((String)GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()));
            return mod == null ? "Minecraft" : mod.getName();
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static int getID(ItemStack itemStack) {
        if (itemStack == null) {
            return -1;
        }
        return Item.func_150891_b((Item)itemStack.func_77973_b());
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_ELEMENT("gui/elements"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/blocks"),
        TEXTURE_ITEMS("textures/items"),
        MODEL("models"),
        INFUSE("infuse");

        private String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

