/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.HashSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmitterNetworkRegistry {
    private static TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private HashSet<DynamicNetwork> networks = new HashSet();
    private HashSet<DynamicNetwork> networksToChange = new HashSet();
    private HashSet<IGridTransmitter> invalidTransmitters = new HashSet();
    private HashMap<Coord4D, IGridTransmitter> orphanTransmitters = new HashMap();
    private Logger logger = LogManager.getLogger((String)"MekanismTransmitters");

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().orphanTransmitters.clear();
    }

    public static void invalidateTransmitter(IGridTransmitter transmitter) {
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.add(transmitter);
    }

    public static void registerOrphanTransmitter(IGridTransmitter transmitter) {
        TransmitterNetworkRegistry.getInstance().orphanTransmitters.put(transmitter.coord(), transmitter);
    }

    public static void registerChangedNetwork(DynamicNetwork network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(DynamicNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork network) {
        if (this.networks.contains(network)) {
            this.networks.remove(network);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            this.tickEnd();
        }
    }

    public void tickEnd() {
        this.removeInvalidTransmitters();
        this.assignOrphans();
        this.commitChanges();
        for (DynamicNetwork net : this.networks) {
            net.tick();
        }
    }

    public void removeInvalidTransmitters() {
        if (MekanismAPI.debug && !this.invalidTransmitters.isEmpty()) {
            this.logger.debug("Dealing with " + this.invalidTransmitters.size() + " invalid Transmitters");
        }
        for (IGridTransmitter invalid : this.invalidTransmitters) {
            Object n;
            if (invalid.isOrphan() || (n = invalid.getTransmitterNetwork()) == null) continue;
            ((DynamicNetwork)n).invalidate();
        }
        this.invalidTransmitters.clear();
    }

    public void assignOrphans() {
        if (MekanismAPI.debug && !this.orphanTransmitters.isEmpty()) {
            this.logger.debug("Dealing with " + this.orphanTransmitters.size() + " orphan Transmitters");
        }
        for (IGridTransmitter orphanTransmitter : this.orphanTransmitters.values()) {
            DynamicNetwork network = this.getNetworkFromOrphan(orphanTransmitter);
            if (network == null) continue;
            this.networksToChange.add(network);
            network.register();
        }
        this.orphanTransmitters.clear();
    }

    public <A, N extends DynamicNetwork<A, N>> DynamicNetwork<A, N> getNetworkFromOrphan(IGridTransmitter<A, N> startOrphan) {
        if (startOrphan.isValid() && startOrphan.isOrphan()) {
            Object network;
            OrphanPathFinder<A, N> finder = new OrphanPathFinder<A, N>(startOrphan);
            finder.start();
            switch (finder.networksFound.size()) {
                case 0: {
                    if (MekanismAPI.debug) {
                        this.logger.debug("No networks found. Creating new network");
                    }
                    network = startOrphan.createEmptyNetwork();
                    break;
                }
                case 1: {
                    if (MekanismAPI.debug) {
                        this.logger.debug("Using single found network");
                    }
                    network = (DynamicNetwork)finder.networksFound.iterator().next();
                    break;
                }
                default: {
                    if (MekanismAPI.debug) {
                        this.logger.debug("Merging " + finder.networksFound.size() + " networks");
                    }
                    network = startOrphan.mergeNetworks(finder.networksFound);
                }
            }
            ((DynamicNetwork)network).addNewTransmitters(finder.connectedTransmitters);
            return network;
        }
        return null;
    }

    public void commitChanges() {
        for (DynamicNetwork network : this.networksToChange) {
            network.commit();
        }
        this.networksToChange.clear();
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public String[] toStrings() {
        String[] strings = new String[this.networks.size()];
        int i = 0;
        for (DynamicNetwork network : this.networks) {
            strings[i++] = network.toString();
        }
        return strings;
    }

    public class OrphanPathFinder<A, N extends DynamicNetwork<A, N>> {
        public IGridTransmitter<A, N> startPoint;
        public HashSet<Coord4D> iterated = new HashSet();
        public HashSet<IGridTransmitter<A, N>> connectedTransmitters = new HashSet();
        public HashSet<N> networksFound = new HashSet();

        public OrphanPathFinder(IGridTransmitter<A, N> start) {
            this.startPoint = start;
        }

        public void start() {
            this.iterate(this.startPoint.coord(), ForgeDirection.UNKNOWN);
        }

        public void iterate(Coord4D from, ForgeDirection fromDirection) {
            if (this.iterated.contains(from)) {
                return;
            }
            this.iterated.add(from);
            if (TransmitterNetworkRegistry.this.orphanTransmitters.containsKey(from)) {
                IGridTransmitter transmitter = (IGridTransmitter)TransmitterNetworkRegistry.this.orphanTransmitters.get(from);
                if (transmitter.isValid() && transmitter.isOrphan()) {
                    this.connectedTransmitters.add(transmitter);
                    transmitter.setOrphan(false);
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        Coord4D directionCoord;
                        if (direction == fromDirection || (directionCoord = transmitter.getAdjacentConnectableTransmitterCoord(direction)) == null || this.iterated.contains(directionCoord)) continue;
                        this.iterate(directionCoord, direction.getOpposite());
                    }
                }
            } else {
                this.addNetworkToIterated(from);
            }
        }

        public void addNetworkToIterated(Coord4D from) {
            N net = this.startPoint.getExternalNetwork(from);
            if (net != null) {
                this.networksFound.add(net);
            }
        }
    }
}

