/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTOreDictFilter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    public boolean isNew = false;
    public TOreDictFilter origFilter;
    public TOreDictFilter filter = new TOreDictFilter();
    private GuiTextField oreDictText;
    public ItemStack renderStack;
    public int ticker = 0;
    public int stackSwitch = 0;
    public int stackIndex = 0;
    public List<ItemStack> iterStacks;
    public String status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");

    public GuiTOreDictFilter(EntityPlayer player, TileEntityLogisticalSorter tentity, int index) {
        super(tentity, new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.origFilter = (TOreDictFilter)this.tileEntity.filters.get(index);
        this.filter = ((TOreDictFilter)tentity.filters.get(index)).clone();
        this.updateStackList(this.filter.oreDictName);
    }

    public GuiTOreDictFilter(EntityPlayer player, TileEntityLogisticalSorter tentity) {
        super(tentity, new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.isNew = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 27, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));
        if (this.isNew) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
        }
        this.oreDictText = new GuiTextField(this.field_146289_q, guiWidth + 35, guiHeight + 47, 95, 12);
        this.oreDictText.func_146203_f(24);
        this.oreDictText.func_146195_b(true);
    }

    public void func_73869_a(char c, int i) {
        if (!this.oreDictText.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.oreDictText.func_146206_l() && i == 28) {
            this.setOreDictKey();
            return;
        }
        if (Character.isLetter(c) || Character.isDigit(c) || TransporterFilter.SPECIAL_CHARS.contains(Character.valueOf(c)) || i == 14 || i == 211 || i == 203 || i == 205) {
            this.oreDictText.func_146201_a(c, i);
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (!this.oreDictText.func_146179_b().isEmpty()) {
                this.setOreDictKey();
            }
            if (this.filter.oreDictName != null && !this.filter.oreDictName.isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.oredictFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.renderScaledText(LangUtils.localize("gui.key") + ": " + this.filter.oreDictName, 35, 32, 52480, 107);
        if (this.renderStack != null) {
            try {
                GL11.glPushMatrix();
                GL11.glEnable((int)2896);
                field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.renderStack, 12, 19);
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.filter.color != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            field_146296_j.func_94149_a(12, 44, MekanismRenderer.getColorIcon(this.filter.color), 16, 16);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            if (this.filter.color != null) {
                this.func_146279_a(this.filter.color.getName(), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTOreDictFilter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59) {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 187, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 187, 12, 12, 12);
        }
        this.oreDictText.func_146194_f();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.oreDictText.func_146178_a();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = null;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.oreDictText.func_146192_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 4 : 0, 0, 0));
            }
            if (xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59) {
                SoundHandler.playSound("gui.button.press");
                this.setOreDictKey();
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            SoundHandler.playSound("mekanism:etc.Ding");
            if (button == 0) {
                this.filter.color = TransporterUtils.increment(this.filter.color);
            } else if (button == 1) {
                this.filter.color = TransporterUtils.decrement(this.filter.color);
            } else if (button == 2) {
                this.filter.color = null;
            }
        }
    }

    private void updateStackList(String oreName) {
        this.iterStacks = OreDictCache.getOreDictStacks(oreName, false);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    private void setOreDictKey() {
        String oreName = this.oreDictText.func_146179_b();
        if (oreName == null || oreName.isEmpty()) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.noKey");
            return;
        }
        if (oreName.equals(this.filter.oreDictName)) {
            this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.oredictFilter.sameKey");
            return;
        }
        this.updateStackList(oreName);
        this.filter.oreDictName = oreName;
        this.oreDictText.func_146180_a("");
    }
}

