/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import codechicken.lib.vec.Rectangle4i;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiScrollList
extends GuiElement {
    public int xSize;
    public int size;
    public int xPosition;
    public int yPosition;
    public List<String> textEntries = new ArrayList<String>();
    public int dragOffset = 0;
    public int selected = -1;
    public float scroll;
    public boolean isDragging;

    public GuiScrollList(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiScrollList.png"), gui, def);
        this.xPosition = x;
        this.yPosition = y;
        this.xSize = sizeX;
        this.size = sizeY;
    }

    public boolean hasSelection() {
        return this.selected != -1;
    }

    public int getSelection() {
        return this.selected;
    }

    public void setText(List<String> text) {
        if (text == null) {
            this.textEntries.clear();
            return;
        }
        if (this.selected > text.size() - 1) {
            this.selected = -1;
        }
        this.textEntries = text;
        if (this.textEntries.size() <= this.size) {
            this.scroll = 0.0f;
        }
    }

    @Override
    public Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new Rectangle4i(guiWidth + this.xPosition, guiHeight + this.yPosition, this.xSize, this.size * 10);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiScrollList.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.drawBlack(guiWidth, guiHeight);
        this.drawSelected(guiWidth, guiHeight, this.selected);
        GuiScrollList.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        int xDisplays = this.xSize / 10 + (this.xSize % 10 > 0 ? 1 : 0);
        for (int yIter = 0; yIter < this.size; ++yIter) {
            for (int xIter = 0; xIter < xDisplays; ++xIter) {
                int width = this.xSize % 10 > 0 && xIter == xDisplays ? this.xSize % 10 : 10;
                this.guiObj.drawTexturedRect(guiWidth + this.xPosition + xIter * 10, guiHeight + this.yPosition + yIter * 10, 0, 0, width, 10);
            }
        }
    }

    public void drawSelected(int guiWidth, int guiHeight, int index) {
        int scroll = this.getScrollIndex();
        if (this.selected != -1 && index >= scroll && index <= scroll + this.size - 1) {
            int xDisplays = this.xSize / 10 + (this.xSize % 10 > 0 ? 1 : 0);
            for (int xIter = 0; xIter < xDisplays; ++xIter) {
                int width = this.xSize % 10 > 0 && xIter == xDisplays ? this.xSize % 10 : 10;
                this.guiObj.drawTexturedRect(guiWidth + this.xPosition + xIter * 10, guiHeight + this.yPosition + (index - scroll) * 10, 0, 10, width, 10);
            }
        }
    }

    public void drawScroll() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xStart = this.xPosition + this.xSize - 6;
        int yStart = this.yPosition;
        for (int i = 0; i < this.size; ++i) {
            this.guiObj.drawTexturedRect(xStart, yStart + i * 10, 10, 1, 6, 10);
        }
        this.guiObj.drawTexturedRect(xStart, yStart, 10, 0, 6, 1);
        this.guiObj.drawTexturedRect(xStart, yStart + this.size * 10 - 1, 10, 0, 6, 1);
        this.guiObj.drawTexturedRect(xStart + 1, yStart + 1 + this.getScroll(), 16, 0, 4, 4);
    }

    public int getMaxScroll() {
        return this.size * 10 - 2;
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * (float)(this.getMaxScroll() - 4)), this.getMaxScroll() - 4), 0);
    }

    public int getScrollIndex() {
        if (this.textEntries.size() <= this.size) {
            return 0;
        }
        return (int)((float)this.textEntries.size() * this.scroll - (float)this.size / (float)this.textEntries.size() * this.scroll);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (!this.textEntries.isEmpty()) {
            for (int i = 0; i < this.size; ++i) {
                int index = this.getScrollIndex() + i;
                if (index > this.textEntries.size() - 1) continue;
                this.renderScaledText(this.textEntries.get(index), this.xPosition + 1, this.yPosition + 1 + 10 * i, 52480, this.xSize - 6);
            }
        }
        GuiScrollList.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.drawScroll();
        GuiScrollList.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        block2: {
            block3: {
                if (button != 0) break block2;
                int xStart = this.xPosition + this.xSize - 5;
                if (xAxis < xStart || xAxis > xStart + 4 || yAxis < this.getScroll() + this.yPosition + 1 || yAxis > this.getScroll() + 4 + this.yPosition + 1) break block3;
                if (this.textEntries.size() <= this.size) break block2;
                this.dragOffset = yAxis - (this.getScroll() + this.yPosition + 1);
                this.isDragging = true;
                break block2;
            }
            if (xAxis >= this.xPosition && xAxis <= this.xPosition + this.xSize - 6 && yAxis >= this.yPosition && yAxis <= this.yPosition + this.size * 10) {
                int index = this.getScrollIndex();
                this.selected = -1;
                for (int i = 0; i < this.size; ++i) {
                    if (index + i > this.textEntries.size() - 1 || yAxis < this.yPosition + i * 10 || yAxis > this.yPosition + i * 10 + 10) continue;
                    this.selected = index + i;
                    break;
                }
            }
        }
    }

    @Override
    public void mouseClickMove(int xAxis, int yAxis, int button, long ticks) {
        super.mouseClickMove(xAxis, yAxis, button, ticks);
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - (this.yPosition + 1) - this.dragOffset) / (float)(this.getMaxScroll() - 4), 0.0f), 1.0f);
        }
    }

    @Override
    public void mouseMovedOrUp(int xAxis, int yAxis, int type) {
        super.mouseMovedOrUp(xAxis, yAxis, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }
}

