/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.MekanismConfig;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class Sound
implements ISound {
    protected ISound.AttenuationType attenuation;
    protected ResourceLocation sound;
    protected float volume;
    protected float pitch;
    protected float x;
    protected float y;
    protected float z;
    protected boolean repeat;
    protected int repeatDelay;

    public Sound(String sound) {
        this(sound, 0.0f);
    }

    public Sound(String sound, float volume) {
        this(sound, volume, 0.0f);
    }

    public Sound(String sound, float volume, float pitch) {
        this(sound, volume, pitch, false, 0);
    }

    public Sound(String sound, float volume, float pitch, boolean repeat, int repeatDelay) {
        this(sound, volume, pitch, repeat, repeatDelay, 0.0, 0.0, 0.0, ISound.AttenuationType.NONE);
    }

    public Sound(String sound, float volume, float pitch, double x, double y, double z) {
        this(sound, volume, pitch, false, 0, x, y, z);
    }

    public Sound(String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public Sound(String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        this(new ResourceLocation(sound), volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
    }

    public Sound(ResourceLocation sound) {
        this(sound, 0.0f);
    }

    public Sound(ResourceLocation sound, float volume) {
        this(sound, volume, 0.0f);
    }

    public Sound(ResourceLocation sound, float volume, float pitch) {
        this(sound, volume, pitch, false, 0);
    }

    public Sound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay) {
        this(sound, volume, pitch, repeat, repeatDelay, 0.0, 0.0, 0.0, ISound.AttenuationType.NONE);
    }

    public Sound(ResourceLocation sound, float volume, float pitch, double x, double y, double z) {
        this(sound, volume, pitch, false, 0, x, y, z);
    }

    public Sound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public Sound(ResourceLocation resource, float v, float p, boolean rep, int delay, double xPos, double yPos, double zPos, ISound.AttenuationType att) {
        this.attenuation = att;
        this.sound = resource;
        this.volume = v;
        this.pitch = p;
        this.x = (float)xPos;
        this.y = (float)yPos;
        this.z = (float)zPos;
        this.repeat = rep;
        this.repeatDelay = delay;
    }

    public Sound(Sound other) {
        this.attenuation = other.attenuation;
        this.sound = other.sound;
        this.volume = other.volume;
        this.pitch = other.pitch;
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.repeat = other.repeat;
        this.repeatDelay = other.repeatDelay;
    }

    public ISound.AttenuationType func_147656_j() {
        return this.attenuation;
    }

    public ResourceLocation func_147650_b() {
        return this.sound;
    }

    public float func_147653_e() {
        return this.volume * MekanismConfig.client.baseSoundVolume;
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public float func_147649_g() {
        return this.x;
    }

    public float func_147654_h() {
        return this.y;
    }

    public float func_147651_i() {
        return this.z;
    }

    public boolean func_147657_c() {
        return this.repeat;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }
}

