/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import mekanism.client.voice.VoiceClient;
import mekanism.common.Mekanism;

@SideOnly(value=Side.CLIENT)
public class VoiceOutput
extends Thread {
    public VoiceClient voiceClient;
    public DataLine.Info speaker;
    public SourceDataLine sourceLine;

    public VoiceOutput(VoiceClient client2) {
        this.voiceClient = client2;
        this.speaker = new DataLine.Info(SourceDataLine.class, this.voiceClient.format, 2200);
        this.setDaemon(true);
        this.setName("VoiceServer Client Output Thread");
    }

    @Override
    public void run() {
        try {
            this.sourceLine = (SourceDataLine)AudioSystem.getLine(this.speaker);
            this.sourceLine.open(this.voiceClient.format, 2200);
            this.sourceLine.start();
            while (this.voiceClient.running) {
                try {
                    short byteCount = this.voiceClient.input.readShort();
                    byte[] audioData = new byte[byteCount];
                    this.voiceClient.input.readFully(audioData);
                    this.sourceLine.write(audioData, 0, audioData.length);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while running client output thread.");
            e.printStackTrace();
        }
    }

    public void close() {
        this.sourceLine.flush();
        this.sourceLine.close();
    }
}

