/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;

public class IMCHandler {
    @Mod.EventHandler
    public void onIMCEvent(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage msg : messages) {
            if (!msg.isNBTMessage()) continue;
            try {
                boolean found = false;
                for (RecipeHandler.Recipe type : RecipeHandler.Recipe.values()) {
                    if (!msg.key.equalsIgnoreCase(type.getRecipeName() + "Recipe")) continue;
                    MachineInput input = (MachineInput)type.createInput(msg.getNBTValue());
                    if (input != null && input.isValid()) {
                        MachineRecipe recipe = (MachineRecipe)type.createRecipe(input, msg.getNBTValue());
                        if (recipe != null && recipe.recipeOutput != null) {
                            RecipeHandler.addRecipe(type, recipe);
                            Mekanism.logger.info("[Mekanism] " + msg.getSender() + " added recipe of type " + type.getRecipeName() + " to the recipe list.");
                        } else {
                            Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to add recipe of type " + type.getRecipeName() + " with an invalid output.");
                        }
                    } else {
                        Mekanism.logger.error("[Mekanism] " + msg.getSender() + " attempted to add recipe of type " + type.getRecipeName() + " with an invalid input.");
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                Mekanism.logger.error("[Mekanism] " + msg.getSender() + " sent unknown IMC message with key '" + msg.key + ".'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

