/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import io.netty.buffer.ByteBuf;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.LangUtils;
import net.minecraft.util.ResourceLocation;

public final class Tier {
    public static void loadConfig() {
        for (CableTier cableTier : CableTier.values()) {
            cableTier.loadConfig();
        }
        for (Enum enum_ : InductionCellTier.values()) {
            ((InductionCellTier)enum_).loadConfig();
        }
        for (Enum enum_ : InductionProviderTier.values()) {
            ((InductionProviderTier)enum_).loadConfig();
        }
        for (Enum enum_ : EnergyCubeTier.values()) {
            ((EnergyCubeTier)enum_).loadConfig();
        }
        for (Enum enum_ : PipeTier.values()) {
            ((PipeTier)enum_).loadConfig();
        }
        for (Enum enum_ : TubeTier.values()) {
            ((TubeTier)enum_).loadConfig();
        }
        for (Enum enum_ : TransporterTier.values()) {
            ((TransporterTier)enum_).loadConfig();
        }
    }

    public static void readConfig(ByteBuf dataStream) {
        for (CableTier cableTier : CableTier.values()) {
            cableTier.readConfig(dataStream);
        }
        for (Enum enum_ : InductionCellTier.values()) {
            ((InductionCellTier)enum_).readConfig(dataStream);
        }
        for (Enum enum_ : InductionProviderTier.values()) {
            ((InductionProviderTier)enum_).readConfig(dataStream);
        }
        for (Enum enum_ : EnergyCubeTier.values()) {
            ((EnergyCubeTier)enum_).readConfig(dataStream);
        }
        for (Enum enum_ : PipeTier.values()) {
            ((PipeTier)enum_).readConfig(dataStream);
        }
        for (Enum enum_ : TubeTier.values()) {
            ((TubeTier)enum_).readConfig(dataStream);
        }
        for (Enum enum_ : TransporterTier.values()) {
            ((TransporterTier)enum_).readConfig(dataStream);
        }
    }

    public static void writeConfig(ByteBuf dataStream) {
        for (CableTier cableTier : CableTier.values()) {
            cableTier.writeConfig(dataStream);
        }
        for (Enum enum_ : InductionCellTier.values()) {
            ((InductionCellTier)enum_).writeConfig(dataStream);
        }
        for (Enum enum_ : InductionProviderTier.values()) {
            ((InductionProviderTier)enum_).writeConfig(dataStream);
        }
        for (Enum enum_ : EnergyCubeTier.values()) {
            ((EnergyCubeTier)enum_).writeConfig(dataStream);
        }
        for (Enum enum_ : PipeTier.values()) {
            ((PipeTier)enum_).writeConfig(dataStream);
        }
        for (Enum enum_ : TubeTier.values()) {
            ((TubeTier)enum_).writeConfig(dataStream);
        }
        for (Enum enum_ : TransporterTier.values()) {
            ((TransporterTier)enum_).writeConfig(dataStream);
        }
    }

    public static enum TransporterTier {
        BASIC(1, 5, TransmitterType.LOGISTICAL_TRANSPORTER_BASIC),
        ADVANCED(16, 10, TransmitterType.LOGISTICAL_TRANSPORTER_ADVANCED),
        ELITE(32, 20, TransmitterType.LOGISTICAL_TRANSPORTER_ELITE),
        ULTIMATE(64, 50, TransmitterType.LOGISTICAL_TRANSPORTER_ULTIMATE);

        public int pullAmount;
        private int basePull;
        public int speed;
        private int baseSpeed;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private TransporterTier(int pull, int s, TransmitterType transmitterType) {
            this.basePull = this.pullAmount = pull;
            this.baseSpeed = this.speed = s;
            this.type = transmitterType;
        }

        protected void loadConfig() {
            this.pullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "TransporterPullAmount", this.basePull).getInt();
            this.speed = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "TransporterSpeed", this.baseSpeed).getInt();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.pullAmount = dataStream.readInt();
            this.speed = dataStream.readInt();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.pullAmount);
            dataStream.writeInt(this.speed);
        }

        public static TransporterTier get(BaseTier tier) {
            for (TransporterTier transmitter : TransporterTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum TubeTier {
        BASIC(256, 64, TransmitterType.PRESSURIZED_TUBE_BASIC),
        ADVANCED(1024, 256, TransmitterType.PRESSURIZED_TUBE_ADVANCED),
        ELITE(4096, 1024, TransmitterType.PRESSURIZED_TUBE_ELITE),
        ULTIMATE(16384, 4096, TransmitterType.PRESSURIZED_TUBE_ULTIMATE);

        public int tubeCapacity;
        private int baseCapacity;
        public int tubePullAmount;
        private int basePull;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private TubeTier(int capacity, int pullAmount, TransmitterType transmitterType) {
            this.baseCapacity = this.tubeCapacity = capacity;
            this.basePull = this.tubePullAmount = pullAmount;
            this.type = transmitterType;
        }

        protected void loadConfig() {
            this.tubeCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "TubeCapacity", this.baseCapacity).getInt();
            this.tubePullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "TubePullAmount", this.basePull).getInt();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.tubeCapacity = dataStream.readInt();
            this.tubePullAmount = dataStream.readInt();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.tubeCapacity);
            dataStream.writeInt(this.tubePullAmount);
        }

        public static TubeTier get(BaseTier tier) {
            for (TubeTier transmitter : TubeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum PipeTier {
        BASIC(1000, 100, TransmitterType.MECHANICAL_PIPE_BASIC),
        ADVANCED(4000, 400, TransmitterType.MECHANICAL_PIPE_ADVANCED),
        ELITE(16000, 1600, TransmitterType.MECHANICAL_PIPE_ELITE),
        ULTIMATE(64000, 6400, TransmitterType.MECHANICAL_PIPE_ULTIMATE);

        public int pipeCapacity;
        private int baseCapacity;
        public int pipePullAmount;
        private int basePull;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private PipeTier(int capacity, int pullAmount, TransmitterType transmitterType) {
            this.baseCapacity = this.pipeCapacity = capacity;
            this.basePull = this.pipePullAmount = pullAmount;
            this.type = transmitterType;
        }

        protected void loadConfig() {
            this.pipeCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "PipeCapacity", this.baseCapacity).getInt();
            this.pipePullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "PipePullAmount", this.basePull).getInt();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.pipeCapacity = dataStream.readInt();
            this.pipePullAmount = dataStream.readInt();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.pipeCapacity);
            dataStream.writeInt(this.pipePullAmount);
        }

        public static PipeTier get(BaseTier tier) {
            for (PipeTier transmitter : PipeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum CableTier {
        BASIC(3200, TransmitterType.UNIVERSAL_CABLE_BASIC),
        ADVANCED(12800, TransmitterType.UNIVERSAL_CABLE_ADVANCED),
        ELITE(64000, TransmitterType.UNIVERSAL_CABLE_ELITE),
        ULTIMATE(320000, TransmitterType.UNIVERSAL_CABLE_ULTIMATE);

        public int cableCapacity;
        private int baseCapacity;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private CableTier(int capacity, TransmitterType transmitterType) {
            this.baseCapacity = this.cableCapacity = capacity;
            this.type = transmitterType;
        }

        protected void loadConfig() {
            this.cableCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "CableCapacity", this.baseCapacity).getInt();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.cableCapacity = dataStream.readInt();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.cableCapacity);
        }

        public static CableTier get(BaseTier tier) {
            for (CableTier transmitter : CableTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum FactoryTier {
        BASIC(3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png")),
        ADVANCED(5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png")),
        ELITE(7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"));

        public int processes;
        public ResourceLocation guiLocation;

        public static FactoryTier getFromName(String tierName) {
            for (FactoryTier tier : FactoryTier.values()) {
                if (!tierName.contains(tier.getBaseTier().getName())) continue;
                return tier;
            }
            Mekanism.logger.error("Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private FactoryTier(int process, ResourceLocation gui) {
            this.processes = process;
            this.guiLocation = gui;
        }
    }

    public static enum InductionProviderTier {
        BASIC(64000.0),
        ADVANCED(512000.0),
        ELITE(4096000.0),
        ULTIMATE(3.2768E7);

        public double output;
        private double baseOutput;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        protected void loadConfig() {
            this.output = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "InductionProviderOutput", this.baseOutput).getDouble();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.output = dataStream.readDouble();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.output);
        }

        private InductionProviderTier(double out) {
            this.baseOutput = this.output = out;
        }
    }

    public static enum InductionCellTier {
        BASIC(1.0E9),
        ADVANCED(8.0E9),
        ELITE(6.4E10),
        ULTIMATE(5.12E11);

        public double maxEnergy;
        private double baseMaxEnergy;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        protected void loadConfig() {
            this.maxEnergy = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "InductionCellMaxEnergy", this.baseMaxEnergy).getDouble();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.maxEnergy = dataStream.readDouble();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.maxEnergy);
        }

        private InductionCellTier(double max) {
            this.baseMaxEnergy = this.maxEnergy = max;
        }
    }

    public static enum EnergyCubeTier {
        BASIC(2000000.0, 800.0),
        ADVANCED(8000000.0, 3200.0),
        ELITE(3.2E7, 12800.0),
        ULTIMATE(1.28E8, 51200.0),
        CREATIVE(2.147483647E9, 2.147483647E9);

        public double maxEnergy;
        private double baseMaxEnergy;
        public double output;
        private double baseOutput;

        public static EnergyCubeTier getFromName(String tierName) {
            for (EnergyCubeTier tier : EnergyCubeTier.values()) {
                if (!tierName.contains(tier.getBaseTier().getName())) continue;
                return tier;
            }
            return BASIC;
        }

        protected void loadConfig() {
            this.maxEnergy = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "EnergyCubeMaxEnergy", this.baseMaxEnergy).getDouble();
            this.output = Mekanism.configuration.get("tier", this.getBaseTier().getName() + "EnergyCubeOutput", this.baseOutput).getDouble();
        }

        protected void readConfig(ByteBuf dataStream) {
            this.maxEnergy = dataStream.readDouble();
            this.output = dataStream.readDouble();
        }

        protected void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.maxEnergy);
            dataStream.writeDouble(this.output);
        }

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private EnergyCubeTier(double max, double out) {
            this.baseMaxEnergy = this.maxEnergy = max;
            this.baseOutput = this.output = out;
        }
    }

    public static enum BaseTier {
        BASIC("Basic", EnumColor.BRIGHT_GREEN),
        ADVANCED("Advanced", EnumColor.DARK_RED),
        ELITE("Elite", EnumColor.DARK_BLUE),
        ULTIMATE("Ultimate", EnumColor.PURPLE),
        CREATIVE("Creative", EnumColor.BLACK);

        private String name;
        private EnumColor color;

        public String getName() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("tier." + this.getName());
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isObtainable() {
            return this != CREATIVE;
        }

        private BaseTier(String s, EnumColor c) {
            this.name = s;
            this.color = c;
        }
    }
}

