/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.CTMData;
import mekanism.common.CommonProxy;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBlockCTM;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntitySolarEvaporationBlock;
import mekanism.common.tile.TileEntitySolarEvaporationController;
import mekanism.common.tile.TileEntitySolarEvaporationValve;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockBasic
extends Block
implements IBlockCTM,
MekanismRenderer.ICustomBlockIcon {
    public IIcon[][] icons = new IIcon[16][16];
    public CTMData[][] ctms = new CTMData[16][4];
    public static String ICON_BASE = "mekanism:SteelCasing";
    public BasicBlock blockType;

    public BlockBasic(BasicBlock type) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(Mekanism.tabMekanism);
        this.blockType = type;
    }

    @Override
    public IIcon getIcon(ItemStack stack, int side) {
        if (BlockBasic.func_149634_a((Item)stack.func_77973_b()) == MekanismBlocks.BasicBlock2 && stack.func_77960_j() == 3) {
            return this.icons[3][((ItemBlockBasic)stack.func_77973_b()).getTier(stack).ordinal()];
        }
        if (BlockBasic.func_149634_a((Item)stack.func_77973_b()) == MekanismBlocks.BasicBlock2 && stack.func_77960_j() == 4) {
            return this.icons[4][((ItemBlockBasic)stack.func_77973_b()).getTier(stack).ordinal()];
        }
        return this.func_149691_a(side, stack.func_77960_j());
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (block == this && tileEntity instanceof TileEntityMultiblock) {
                ((TileEntityMultiblock)tileEntity).update();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                this.ctms[7][0] = new CTMData("ctm/TeleporterFrame", this, Arrays.asList(7)).addOtherBlockConnectivities(MekanismBlocks.MachineBlock, Arrays.asList(11)).registerIcons(register);
                this.ctms[9][0] = new CTMData("ctm/DynamicTank", this, Arrays.asList(9, 11)).registerIcons(register);
                this.ctms[10][0] = new CTMData("ctm/DynamicGlass", this, Arrays.asList(10)).registerIcons(register);
                this.ctms[11][0] = new CTMData("ctm/DynamicValve", this, Arrays.asList(11, 9)).registerIcons(register);
                this.ctms[14][0] = new CTMData("ctm/SolarEvaporationBlock", this, Arrays.asList(14, 15)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).addFacingOverride("ctm/SolarEvaporationController").registerIcons(register);
                this.ctms[14][1] = new CTMData("ctm/SolarEvaporationBlock", this, Arrays.asList(14, 15)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).addFacingOverride("ctm/SolarEvaporationControllerOn").registerIcons(register);
                this.ctms[15][0] = new CTMData("ctm/SolarEvaporationValve", this, Arrays.asList(15, 14)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).registerIcons(register);
                this.icons[0][0] = register.func_94245_a("mekanism:OsmiumBlock");
                this.icons[1][0] = register.func_94245_a("mekanism:BronzeBlock");
                this.icons[2][0] = register.func_94245_a("mekanism:RefinedObsidian");
                this.icons[3][0] = register.func_94245_a("mekanism:CoalBlock");
                this.icons[4][0] = register.func_94245_a("mekanism:RefinedGlowstone");
                this.icons[5][0] = register.func_94245_a("mekanism:SteelBlock");
                MekanismRenderer.loadDynamicTextures(register, "Bin", this.icons[6], MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:BinSide"), 3, 4, 5), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:BinTop"), 0), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:BinTopOn"), 6));
                this.icons[7][0] = this.ctms[7][0].mainTextureData.icon;
                this.icons[8][0] = register.func_94245_a("mekanism:SteelCasing");
                this.icons[9][0] = this.ctms[9][0].mainTextureData.icon;
                this.icons[10][0] = this.ctms[10][0].mainTextureData.icon;
                this.icons[11][0] = this.ctms[11][0].mainTextureData.icon;
                this.icons[12][0] = register.func_94245_a("mekanism:CopperBlock");
                this.icons[13][0] = register.func_94245_a("mekanism:TinBlock");
                this.icons[14][0] = this.ctms[14][0].facingOverride.icon;
                this.icons[14][1] = this.ctms[14][1].facingOverride.icon;
                this.icons[14][2] = this.ctms[14][0].mainTextureData.icon;
                this.icons[15][0] = this.ctms[15][0].mainTextureData.icon;
                break;
            }
            case BASIC_BLOCK_2: {
                this.ctms[0][0] = new CTMData("ctm/SolarEvaporationBlock", this, Arrays.asList(0)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock, Arrays.asList(14, 15)).registerIcons(register);
                this.ctms[1][0] = new CTMData("ctm/InductionCasing", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[2][0] = new CTMData("ctm/InductionPortInput", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[2][1] = new CTMData("ctm/InductionPortOutput", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[3][0] = new CTMData("ctm/InductionCellBasic", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][1] = new CTMData("ctm/InductionCellAdvanced", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][2] = new CTMData("ctm/InductionCellElite", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][3] = new CTMData("ctm/InductionCellUltimate", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][0] = new CTMData("ctm/InductionProviderBasic", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][1] = new CTMData("ctm/InductionProviderAdvanced", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][2] = new CTMData("ctm/InductionProviderElite", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][3] = new CTMData("ctm/InductionProviderUltimate", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.icons[0][0] = this.ctms[0][0].mainTextureData.icon;
                this.icons[1][0] = this.ctms[1][0].mainTextureData.icon;
                this.icons[2][0] = this.ctms[2][0].mainTextureData.icon;
                this.icons[2][1] = this.ctms[2][1].mainTextureData.icon;
                this.icons[3][0] = this.ctms[3][0].mainTextureData.icon;
                this.icons[3][1] = this.ctms[3][1].mainTextureData.icon;
                this.icons[3][2] = this.ctms[3][2].mainTextureData.icon;
                this.icons[3][3] = this.ctms[3][3].mainTextureData.icon;
                this.icons[4][0] = this.ctms[4][0].mainTextureData.icon;
                this.icons[4][1] = this.ctms[4][1].mainTextureData.icon;
                this.icons[4][2] = this.ctms[4][2].mainTextureData.icon;
                this.icons[4][3] = this.ctms[4][3].mainTextureData.icon;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 6: {
                        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.icons[meta][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                    case 14: {
                        TileEntitySolarEvaporationController tileEntity1 = (TileEntitySolarEvaporationController)world.func_147438_o(x, y, z);
                        if (side == tileEntity1.facing) {
                            return MekanismUtils.isActive(world, x, y, z) ? this.icons[meta][1] : this.icons[meta][0];
                        }
                        return this.icons[meta][2];
                    }
                }
                return this.func_149691_a(side, meta);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 2: {
                        TileEntityInductionPort tileEntity = (TileEntityInductionPort)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity.mode ? 1 : 0];
                    }
                    case 3: {
                        TileEntityInductionCell tileEntity1 = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity1.tier.ordinal()];
                    }
                    case 4: {
                        TileEntityInductionProvider tileEntity2 = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity2.tier.ordinal()];
                    }
                }
                return this.func_149691_a(side, meta);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 6: {
                        return this.icons[meta][side];
                    }
                    case 14: {
                        if (side == 2) {
                            return this.icons[meta][0];
                        }
                        return this.icons[meta][2];
                    }
                }
                return this.icons[meta][0];
            }
            case BASIC_BLOCK_2: {
                return this.icons[meta][0];
            }
        }
        return this.icons[meta][0];
    }

    public int func_149692_a(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List list) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                for (int i = 0; i < 16; ++i) {
                    list.add(new ItemStack(item, 1, i));
                }
                break;
            }
            case BASIC_BLOCK_2: {
                for (int i = 0; i < 5; ++i) {
                    ItemStack stack;
                    if (i == 3) {
                        for (Tier.BaseTier tier : Tier.BaseTier.values()) {
                            if (!tier.isObtainable()) continue;
                            stack = new ItemStack(item, 1, i);
                            ((ItemBlockBasic)stack.func_77973_b()).setTier(stack, tier);
                            list.add(stack);
                        }
                        continue;
                    }
                    if (i == 4) {
                        for (Tier.BaseTier tier : Tier.BaseTier.values()) {
                            if (!tier.isObtainable()) continue;
                            stack = new ItemStack(item, 1, i);
                            ((ItemBlockBasic)stack.func_77973_b()).setTier(stack, tier);
                            list.add(stack);
                        }
                        continue;
                    }
                    list.add(new ItemStack(item, 1, i));
                }
                break;
            }
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 9: 
                    case 10: 
                    case 11: {
                        TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_147438_o(x, y, z);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(type, world, x, y, z);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 1: 
                    case 2: {
                        TileEntityInductionCasing tileEntity = (TileEntityInductionCasing)world.func_147438_o(x, y, z);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(type, world, x, y, z);
            }
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.blockType == BasicBlock.BASIC_BLOCK_1 && !world.field_72995_K && meta == 6) {
            TileEntityBin bin = (TileEntityBin)world.func_147438_o(x, y, z);
            MovingObjectPosition pos = MekanismUtils.rayTrace(world, player);
            if (pos != null && pos.field_72310_e == bin.facing && bin.bottomStack != null) {
                if (!player.func_70093_af()) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.removeStack().func_77946_l()));
                } else {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.remove(1).func_77946_l()));
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int i1, float f1, float f2, float f3) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.blockType == BasicBlock.BASIC_BLOCK_1) {
            if (metadata != 6 && ItemAttacher.canAttach(entityplayer.func_71045_bC())) {
                return false;
            }
            if (metadata == 2 && entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)Mekanism.instance, 1, world, x, y, z);
                return true;
            }
            if (metadata == 14 && !entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)Mekanism.instance, 33, world, x, y, z);
                return true;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (metadata == 6) {
                TileEntityBin bin = (TileEntityBin)world.func_147438_o(x, y, z);
                if (bin.getItemCount() < bin.MAX_STORAGE) {
                    if (bin.addTicks == 0 && entityplayer.func_71045_bC() != null) {
                        if (entityplayer.func_71045_bC() != null) {
                            ItemStack remain = bin.add(entityplayer.func_71045_bC());
                            entityplayer.func_70062_b(0, remain);
                            bin.addTicks = 5;
                        }
                    } else if (bin.addTicks > 0 && bin.getItemCount() > 0) {
                        ItemStack[] inv = entityplayer.field_71071_by.field_70462_a;
                        for (int i = 0; i < inv.length && bin.getItemCount() != bin.MAX_STORAGE; ++i) {
                            if (inv[i] != null) {
                                ItemStack remain;
                                inv[i] = remain = bin.add(inv[i]);
                                bin.addTicks = 5;
                            }
                            ((EntityPlayerMP)entityplayer).func_71110_a(entityplayer.field_71070_bA, entityplayer.field_71070_bA.func_75138_a());
                        }
                    }
                }
                return true;
            }
            if (!(metadata != 9 && metadata != 10 && metadata != 11 || entityplayer.func_70093_af() || ((TileEntityDynamicTank)world.func_147438_o((int)x, (int)y, (int)z)).structure == null)) {
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_147438_o(x, y, z);
                if (!this.manageInventory(entityplayer, tileEntity)) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                    entityplayer.openGui((Object)Mekanism.instance, 18, world, x, y, z);
                } else {
                    entityplayer.field_71071_by.func_70296_d();
                    tileEntity.sendPacketToRenderer();
                }
                return true;
            }
        } else if (this.blockType == BasicBlock.BASIC_BLOCK_2) {
            if (world.field_72995_K) {
                return true;
            }
            if (!(metadata != 1 && metadata != 2 || entityplayer.func_70093_af() || ((TileEntityInductionCasing)world.func_147438_o((int)x, (int)y, (int)z)).structure == null)) {
                TileEntityInductionCasing tileEntity = (TileEntityInductionCasing)world.func_147438_o(x, y, z);
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                entityplayer.openGui((Object)Mekanism.instance, 49, world, x, y, z);
                return true;
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.blockType != BasicBlock.BASIC_BLOCK_1 || world.func_72805_g(x, y, z) != 10;
    }

    private boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null && tileEntity.structure != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)((SynchronizedTankData)tileEntity.structure).fluidStored, (ItemStack)itemStack)) != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                        }
                        return true;
                    }
                    if (itemStack.field_77994_a > 1) {
                        if (player.field_71071_by.func_70441_a(filled)) {
                            --itemStack.field_77994_a;
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                            if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                                ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                            }
                            return true;
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                        }
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int max = ((SynchronizedTankData)tileEntity.structure).volume * 16000;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored == null || ((SynchronizedTankData)tileEntity.structure).fluidStored.isFluidEqual(itemFluid) && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount + itemFluid.amount <= max) {
                    boolean filled = false;
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else {
                        ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                        if (containerItem != null) {
                            if (itemStack.field_77994_a == 1) {
                                player.func_70062_b(0, containerItem);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(containerItem)) {
                                --itemStack.field_77994_a;
                                filled = true;
                            }
                        } else {
                            --itemStack.field_77994_a;
                            if (itemStack.field_77994_a == 0) {
                                player.func_70062_b(0, null);
                            }
                            filled = true;
                        }
                    }
                    if (filled) {
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored == null) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = itemFluid;
                        } else {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount += itemFluid.amount;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.CTM_RENDER_ID;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        if (this.blockType == BasicBlock.BASIC_BLOCK_1) {
            switch (metadata) {
                case 2: {
                    return 8;
                }
                case 4: {
                    return 15;
                }
                case 7: {
                    return 12;
                }
            }
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (metadata) {
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return true;
                    }
                }
                return false;
            }
            case BASIC_BLOCK_2: {
                switch (metadata) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (metadata) {
                    case 6: {
                        return new TileEntityBin();
                    }
                    case 9: {
                        return new TileEntityDynamicTank();
                    }
                    case 10: {
                        return new TileEntityDynamicTank();
                    }
                    case 11: {
                        return new TileEntityDynamicValve();
                    }
                    case 14: {
                        return new TileEntitySolarEvaporationController();
                    }
                    case 15: {
                        return new TileEntitySolarEvaporationValve();
                    }
                }
                return null;
            }
            case BASIC_BLOCK_2: {
                switch (metadata) {
                    case 0: {
                        return new TileEntitySolarEvaporationBlock();
                    }
                    case 1: {
                        return new TileEntityInductionCasing();
                    }
                    case 2: {
                        return new TileEntityInductionPort();
                    }
                    case 3: {
                        return new TileEntityInductionCell();
                    }
                    case 4: {
                        return new TileEntityInductionProvider();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity;
        if (world.func_147438_o(x, y, z) instanceof TileEntityBasicBlock) {
            tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int height = Math.round(entityliving.field_70125_A);
            int change = 3;
            if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
                if (height >= 65) {
                    change = 1;
                } else if (height <= -65) {
                    change = 0;
                }
            }
            if (change != 0 && change != 1) {
                switch (side) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 1: {
                        change = 5;
                        break;
                    }
                    case 2: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                    }
                }
            }
            tileEntity.setFacing((short)change);
            tileEntity.redstone = world.func_72864_z(x, y, z);
            if (tileEntity instanceof IBoundingBlock) {
                ((IBoundingBlock)((Object)tileEntity)).onPlace();
            }
        }
        world.func_147479_m(x, y, z);
        world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        world.func_147463_c(EnumSkyBlock.Sky, x, y, z);
        if (!world.field_72995_K && world.func_147438_o(x, y, z) != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityMultiblock) {
            ((TileEntityMultiblock)tileEntity).update();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tileEntity;
        ItemStack ret = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        if (this.blockType == BasicBlock.BASIC_BLOCK_1) {
            if (ret.func_77960_j() == 6) {
                tileEntity = (TileEntityBin)world.func_147438_o(x, y, z);
                InventoryBin inv = new InventoryBin(ret);
                inv.setItemCount(tileEntity.getItemCount());
                if (tileEntity.getItemCount() > 0) {
                    inv.setItemType(tileEntity.itemType);
                }
            }
        } else if (this.blockType == BasicBlock.BASIC_BLOCK_2) {
            if (ret.func_77960_j() == 3) {
                tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                ((ItemBlockBasic)ret.func_77973_b()).setTier(ret, tileEntity.tier.getBaseTier());
            } else if (ret.func_77960_j() == 4) {
                tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                ((ItemBlockBasic)ret.func_77973_b()).setTier(ret, tileEntity.tier.getBaseTier());
            }
        }
        if ((tileEntity = world.func_147438_o(x, y, z)) instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)ret.func_77973_b();
            energizedItem.setEnergy(ret, ((IStrictEnergyStorage)tileEntity).getEnergy());
        }
        return ret;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z, null);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Coord4D obj = new Coord4D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side).getOpposite());
        if (this.blockType == BasicBlock.BASIC_BLOCK_1 && obj.getMetadata(world) == 10) {
            return this.ctms[10][0].shouldRenderSide(world, x, y, z, side);
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Override
    public CTMData getCTMData(IBlockAccess world, int x, int y, int z, int meta) {
        if (this.ctms[meta][1] != null && MekanismUtils.isActive(world, x, y, z)) {
            return this.ctms[meta][1];
        }
        if (this.blockType == BasicBlock.BASIC_BLOCK_2) {
            if (meta == 3) {
                TileEntityInductionCell tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                return this.ctms[meta][tileEntity.tier.ordinal()];
            }
            if (meta == 4) {
                TileEntityInductionProvider tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                return this.ctms[meta][tileEntity.tier.ordinal()];
            }
        }
        return this.ctms[meta][0];
    }

    public static enum BasicBlock {
        BASIC_BLOCK_1,
        BASIC_BLOCK_2;

    }
}

