/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.util.FluidContainerUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCache
extends MultiblockCache<SynchronizedBoilerData> {
    public ItemStack[] inventory = new ItemStack[2];
    public FluidStack water;
    public FluidStack steam;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;

    @Override
    public void apply(SynchronizedBoilerData data) {
        data.inventory = this.inventory;
        data.waterStored = this.water;
        data.steamStored = this.steam;
        data.editMode = this.editMode;
    }

    @Override
    public void sync(SynchronizedBoilerData data) {
        this.inventory = data.inventory;
        this.water = data.waterStored;
        this.steam = data.steamStored;
        this.editMode = data.editMode;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = new ItemStack[2];
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 2) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        if (nbtTags.func_74764_b("cachedWater")) {
            this.water = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedWater"));
        }
        if (nbtTags.func_74764_b("cachedSteam")) {
            this.steam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedSteam"));
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 2; ++slotCount) {
            if (this.inventory[slotCount] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.inventory[slotCount].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
        if (this.water != null) {
            nbtTags.func_74782_a("cachedWater", (NBTBase)this.water.writeToNBT(new NBTTagCompound()));
        }
        if (this.steam != null) {
            nbtTags.func_74782_a("cachedSteam", (NBTBase)this.steam.writeToNBT(new NBTTagCompound()));
        }
    }
}

