/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.util.FluidContainerUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SynchronizedBoilerData
extends SynchronizedData<SynchronizedBoilerData>
implements IHeatTransfer {
    public FluidStack waterStored;
    public FluidStack steamStored;
    public double temperature;
    public double heatToAbsorb;
    public double heatCapacity = 1.0E-6;
    public double enthalpyOfVaporization = 10.0;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;
    public ItemStack[] inventory = new ItemStack[2];
    public Set<ValveData> valves = new HashSet<ValveData>();

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 100.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb = heat;
    }

    @Override
    public double[] simulateHeat() {
        return new double[0];
    }

    @Override
    public double applyTemperatureChange() {
        if (this.temperature < 400.0) {
            double temperatureDeficit = 400.0 - this.temperature;
            double heatNeeded = temperatureDeficit * (double)this.volume * this.heatCapacity * 16000.0;
            double heatProvided = Math.min(this.heatToAbsorb, heatNeeded);
            this.heatToAbsorb -= heatProvided;
            this.temperature += heatProvided / ((double)this.volume * this.heatCapacity * 16.0);
        }
        if (this.temperature >= 400.0 && this.waterStored != null) {
            int amountToBoil = (int)Math.floor(this.heatToAbsorb / this.enthalpyOfVaporization);
            amountToBoil = Math.min(amountToBoil, this.waterStored.amount);
            this.waterStored.amount -= amountToBoil;
            if (this.steamStored == null) {
                this.steamStored = new FluidStack(FluidRegistry.getFluid((String)"steam"), amountToBoil);
            } else {
                this.steamStored.amount += amountToBoil;
            }
            this.heatToAbsorb -= (double)amountToBoil * this.enthalpyOfVaporization;
        }
        this.heatToAbsorb *= 0.8;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return false;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        return null;
    }

    public static class ValveData {
        public ForgeDirection side;
        public Coord4D location;
        public boolean serverFluid;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.location.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof ValveData && ((ValveData)obj).side == this.side && ((ValveData)obj).location.equals(this.location);
        }
    }
}

