/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.LangUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemGaugeDropper
extends ItemMekanism
implements IGasItem,
IFluidContainerItem {
    public static int CAPACITY = 1000;
    public static final int TRANSFER_RATE = 16;

    public ItemGaugeDropper() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    private void updateDamage(ItemStack stack) {
        GasStack gas = this.getGas_do(stack);
        FluidStack fluid = this.getFluid_do(stack);
        if (!(gas != null && gas.amount != 0 || fluid != null && fluid.amount != 0)) {
            stack.func_77964_b(100);
        } else if (gas != null && gas.amount > 0) {
            stack.func_77964_b((int)Math.max(1.0f, Math.abs((float)gas.amount / (float)this.getMaxGas(stack) * 100.0f - 100.0f)));
        } else if (fluid != null && fluid.amount > 0) {
            stack.func_77964_b((int)Math.max(1.0f, Math.abs((float)fluid.amount / (float)this.getCapacity(stack) * 100.0f - 100.0f)));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        empty.func_77964_b(100);
        this.setGas(empty, null);
        this.setFluid(empty, null);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(this.getEmptyItem());
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !world.field_72995_K) {
            this.setGas(stack, null);
            this.setFluid(stack, null);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (gasStack == null && fluidStack == null) {
            list.add(LangUtils.localize("gui.empty") + ".");
        } else if (gasStack != null) {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        } else if (fluidStack != null) {
            list.add(LangUtils.localize("tooltip.stored") + " " + fluidStack.getFluid().getLocalizedName(fluidStack) + ": " + fluidStack.amount);
        }
    }

    private FluidStack getFluid_do(ItemStack container) {
        if (container.field_77990_d == null) {
            return null;
        }
        if (container.field_77990_d.func_74764_b("fluidStack")) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("fluidStack"));
        }
        return null;
    }

    public FluidStack getFluid(ItemStack container) {
        this.updateDamage(container);
        return this.getFluid_do(container);
    }

    public void setFluid(ItemStack container, FluidStack stack) {
        if (container.field_77990_d == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0 || stack.fluidID == 0) {
            container.field_77990_d.func_82580_o("fluidStack");
        } else {
            container.field_77990_d.func_74782_a("fluidStack", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        this.updateDamage(container);
    }

    public int getCapacity(ItemStack container) {
        return CAPACITY;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidStack stored = this.getFluid(container);
        if (stored != null && stored.getFluid() != resource.getFluid()) {
            return 0;
        }
        int toFill = stored == null ? Math.min(resource.amount, 14000) : Math.min(resource.amount, 14000 - stored.amount);
        if (doFill) {
            int fillAmount = toFill + (stored == null ? 0 : stored.amount);
            this.setFluid(container, new FluidStack(resource.getFluid(), (stored != null ? stored.amount : 0) + toFill));
        }
        return toFill;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stored = this.getFluid(container);
        if (stored != null) {
            FluidStack toDrain = new FluidStack(stored.getFluid(), Math.min(stored.amount, maxDrain));
            if (doDrain) {
                stored.amount -= toDrain.amount;
                this.setFluid(container, (FluidStack)(stored.amount > 0 ? stored : null));
            }
            return toDrain;
        }
        return null;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return 16;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    private GasStack getGas_do(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        return GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("gasStack"));
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        this.updateDamage(itemstack);
        return this.getGas_do(itemstack);
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.field_77990_d.func_82580_o("gasStack");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.field_77990_d.func_74782_a("gasStack", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
        this.updateDamage(itemstack);
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return CAPACITY;
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemstack) {
        return false;
    }
}

