/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.render.ModelCustomArmor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.util.LangUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

public class ItemJetpack
extends ItemArmor
implements IGasItem,
ISpecialArmor {
    public int MAX_GAS = 24000;
    public int TRANSFER_RATE = 16;

    public ItemJetpack() {
        super(EnumHelper.addArmorMaterial((String)"JETPACK", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0), 0, 1);
        this.func_77637_a(Mekanism.tabMekanism);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.GREY) + this.getMode(itemstack).getName());
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "mekanism:render/NullArmor.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelCustomArmor model = ModelCustomArmor.INSTANCE;
        if (this == MekanismItems.Jetpack) {
            model.modelType = ModelCustomArmor.ArmorModel.JETPACK;
        } else if (this == MekanismItems.ArmoredJetpack) {
            model.modelType = ModelCustomArmor.ArmorModel.ARMOREDJETPACK;
        }
        return model;
    }

    public void incrementMode(ItemStack stack) {
        this.setMode(stack, this.getMode(stack).increment());
    }

    public void useGas(ItemStack stack) {
        this.setGas(stack, new GasStack(this.getGas(stack).getGas(), this.getGas((ItemStack)stack).amount - 1));
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return this.MAX_GAS;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != GasRegistry.getGas("hydrogen")) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == GasRegistry.getGas("hydrogen");
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        GasStack stored = GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("stored"));
        if (stored == null) {
            itemstack.func_77964_b(100);
        } else {
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)stored.amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
        }
        return stored;
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    public JetpackMode getMode(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return JetpackMode.NORMAL;
        }
        return JetpackMode.values()[stack.field_77990_d.func_74762_e("mode")];
    }

    public void setMode(ItemStack stack, JetpackMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.func_77964_b(100);
            itemstack.field_77990_d.func_82580_o("stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
            itemstack.field_77990_d.func_74782_a("stored", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        empty.func_77964_b(100);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        empty.func_77964_b(100);
        list.add(empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(GasRegistry.getGas("hydrogen"), ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add(filled);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this == MekanismItems.Jetpack) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (this == MekanismItems.ArmoredJetpack) {
            return new ISpecialArmor.ArmorProperties(1, MekanismConfig.general.armoredJetpackDamageRatio, MekanismConfig.general.armoredJetpackDamageMax);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.Jetpack) {
            return 0;
        }
        if (armor.func_77973_b() == MekanismItems.ArmoredJetpack) {
            return 12;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public static enum JetpackMode {
        NORMAL("tooltip.jetpack.regular", EnumColor.DARK_GREEN),
        HOVER("tooltip.jetpack.hover", EnumColor.DARK_AQUA),
        DISABLED("tooltip.jetpack.disabled", EnumColor.DARK_RED);

        private String unlocalized;
        private EnumColor color;

        private JetpackMode(String s, EnumColor c) {
            this.unlocalized = s;
            this.color = c;
        }

        public JetpackMode increment() {
            return this.ordinal() < JetpackMode.values().length - 1 ? JetpackMode.values()[this.ordinal() + 1] : JetpackMode.values()[0];
        }

        public String getName() {
            return (Object)((Object)this.color) + LangUtils.localize(this.unlocalized);
        }
    }
}

