/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import mekanism.api.IHeatTransfer;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.HeatNetwork;
import mekanism.common.multipart.MultipartHeatTransmitter;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PartHeatTransmitter
extends PartTransmitter<IHeatTransfer, HeatNetwork> {
    public static TransmitterIcons heatIcons = new TransmitterIcons(1, 2);

    public PartHeatTransmitter() {
        this.transmitterDelegate = new MultipartHeatTransmitter(this);
    }

    @Override
    public HeatNetwork createNewNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    public static void registerIcons(IIconRegister register) {
        heatIcons.registerCenterIcons(register, new String[]{"HeatTransmitter"});
        heatIcons.registerSideIcons(register, new String[]{"SmallTransmitterVerticalBasic", "SmallTransmitterHorizontalBasic"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return heatIcons.getCenterIcon(0);
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return heatIcons.getSideIcon(0);
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return heatIcons.getSideIcon(1);
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.HEAT_TRANSMITTER;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return tile instanceof IHeatTransfer && ((IHeatTransfer)tile).canConnectHeat(side.getOpposite());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    public String getType() {
        return "mekanism:heat_transmitter";
    }

    @Override
    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        this.getTransmitter().temperature += 10000.0;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.getTransmitter().temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("temperature", this.getTransmitter().temperature);
    }

    public void sendTemp() {
        MCDataOutput packet = this.getWriteStream();
        packet.writeBoolean(true);
        packet.writeDouble(this.getTransmitter().temperature);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeBoolean(false);
        super.writeDesc(packet);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        if (packet.readBoolean()) {
            this.getTransmitter().temperature = packet.readDouble();
        } else {
            super.readDesc(packet);
        }
    }

    public ColourRGBA getBaseColour() {
        return this.getTransmitter().material.baseColour;
    }

    @Override
    public MultipartHeatTransmitter getTransmitter() {
        return (MultipartHeatTransmitter)this.transmitterDelegate;
    }
}

