/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.multipart.MultipartTransmitter;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.transmitters.Transmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartTransmitter<A, N extends DynamicNetwork<A, N>>
extends PartSidedPipe
implements ITransmitterTile<A, N> {
    public MultipartTransmitter<A, N> transmitterDelegate = new MultipartTransmitter(this);

    @Override
    public MultipartTransmitter<A, N> getTransmitter() {
        return this.transmitterDelegate;
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (!this.world().field_72995_K) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new DynamicNetwork.NetworkClientRequest((TileEntity)this.tile()));
        }
    }

    public abstract N createNewNetwork();

    public abstract N createNetworkByMerging(Collection<N> var1);

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.world().field_72995_K) {
            ((MultipartTransmitter)this.getTransmitter()).takeShare();
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            ((Transmitter)this.getTransmitter()).setTransmitterNetwork(null);
        }
    }

    public void preRemove() {
        if (!this.world().field_72995_K) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            ((Transmitter)this.getTransmitter()).setTransmitterNetwork(null);
        }
        super.preRemove();
    }

    @Override
    public void onNeighborTileChanged(int side, boolean weak) {
        super.onNeighborTileChanged(side, weak);
    }

    @Override
    public void markDirtyTransmitters() {
        super.markDirtyTransmitters();
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyAcceptor(ForgeDirection side) {
        super.markDirtyAcceptor(side);
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            ((DynamicNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    public A getCachedAcceptor(ForgeDirection side) {
        PartSidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == PartSidedPipe.ConnectionType.PULL || type == PartSidedPipe.ConnectionType.NONE) {
            return null;
        }
        return (A)(PartTransmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.cachedAcceptors[side.ordinal()] : null);
    }

    public abstract int getCapacity();

    public abstract Object getBuffer();

    public abstract void takeShare();
}

