/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.MekanismConfig;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IModule;
import mekanism.common.block.BlockMachine;

public class PacketConfigSync
implements IMessageHandler<ConfigSyncMessage, IMessage> {
    public IMessage onMessage(ConfigSyncMessage message, MessageContext context) {
        return null;
    }

    public static class ConfigSyncMessage
    implements IMessage {
        public void toBytes(ByteBuf dataStream) {
            dataStream.writeBoolean(MekanismConfig.general.updateNotifications);
            dataStream.writeBoolean(MekanismConfig.general.controlCircuitOreDict);
            dataStream.writeBoolean(MekanismConfig.general.logPackets);
            dataStream.writeBoolean(MekanismConfig.general.dynamicTankEasterEgg);
            dataStream.writeBoolean(MekanismConfig.general.voiceServerEnabled);
            dataStream.writeBoolean(MekanismConfig.general.cardboardSpawners);
            dataStream.writeBoolean(MekanismConfig.general.creativeOverrideElectricChest);
            dataStream.writeBoolean(MekanismConfig.general.spawnBabySkeletons);
            dataStream.writeInt(MekanismConfig.general.obsidianTNTDelay);
            dataStream.writeInt(MekanismConfig.general.obsidianTNTBlastRadius);
            dataStream.writeInt(MekanismConfig.general.UPDATE_DELAY);
            dataStream.writeDouble(MekanismConfig.general.FROM_IC2);
            dataStream.writeDouble(MekanismConfig.general.TO_IC2);
            dataStream.writeDouble(MekanismConfig.general.FROM_TE);
            dataStream.writeDouble(MekanismConfig.general.TO_TE);
            dataStream.writeDouble(MekanismConfig.general.FROM_H2);
            dataStream.writeInt(MekanismConfig.general.ETHENE_BURN_TIME);
            dataStream.writeDouble(MekanismConfig.general.ENERGY_PER_REDSTONE);
            dataStream.writeDouble(MekanismConfig.general.DISASSEMBLER_USAGE);
            dataStream.writeInt(MekanismConfig.general.VOICE_PORT);
            dataStream.writeInt(MekanismConfig.general.maxUpgradeMultiplier);
            dataStream.writeInt(MekanismConfig.general.activeType.ordinal());
            dataStream.writeDouble(MekanismConfig.general.minerSilkMultiplier);
            dataStream.writeBoolean(MekanismConfig.general.blacklistIC2);
            dataStream.writeBoolean(MekanismConfig.general.blacklistRF);
            dataStream.writeDouble(MekanismConfig.general.armoredJetpackDamageRatio);
            dataStream.writeInt(MekanismConfig.general.armoredJetpackDamageMax);
            dataStream.writeBoolean(MekanismConfig.general.aestheticWorldDamage);
            dataStream.writeBoolean(MekanismConfig.general.opsBypassRestrictions);
            dataStream.writeDouble(MekanismConfig.general.solarEvaporationSpeed);
            for (BlockMachine.MachineType type : BlockMachine.MachineType.getValidMachines()) {
                dataStream.writeBoolean(MekanismConfig.machines.isEnabled(type.name));
            }
            dataStream.writeDouble(MekanismConfig.usage.enrichmentChamberUsage);
            dataStream.writeDouble(MekanismConfig.usage.osmiumCompressorUsage);
            dataStream.writeDouble(MekanismConfig.usage.combinerUsage);
            dataStream.writeDouble(MekanismConfig.usage.crusherUsage);
            dataStream.writeDouble(MekanismConfig.usage.factoryUsage);
            dataStream.writeDouble(MekanismConfig.usage.metallurgicInfuserUsage);
            dataStream.writeDouble(MekanismConfig.usage.purificationChamberUsage);
            dataStream.writeDouble(MekanismConfig.usage.energizedSmelterUsage);
            dataStream.writeDouble(MekanismConfig.usage.digitalMinerUsage);
            dataStream.writeDouble(MekanismConfig.usage.electricPumpUsage);
            dataStream.writeDouble(MekanismConfig.usage.rotaryCondensentratorUsage);
            dataStream.writeDouble(MekanismConfig.usage.oxidationChamberUsage);
            dataStream.writeDouble(MekanismConfig.usage.chemicalInfuserUsage);
            dataStream.writeDouble(MekanismConfig.usage.chemicalInjectionChamberUsage);
            dataStream.writeDouble(MekanismConfig.usage.precisionSawmillUsage);
            dataStream.writeDouble(MekanismConfig.usage.chemicalDissolutionChamberUsage);
            dataStream.writeDouble(MekanismConfig.usage.chemicalWasherUsage);
            dataStream.writeDouble(MekanismConfig.usage.chemicalCrystallizerUsage);
            dataStream.writeDouble(MekanismConfig.usage.seismicVibratorUsage);
            dataStream.writeDouble(MekanismConfig.usage.fluidicPlenisherUsage);
            dataStream.writeDouble(MekanismConfig.usage.gasCentrifugeUsage);
            dataStream.writeDouble(MekanismConfig.usage.heavyWaterElectrolysisUsage);
            Tier.writeConfig(dataStream);
            try {
                for (IModule module : Mekanism.modulesLoaded) {
                    module.writeConfig(dataStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            MekanismConfig.general.updateNotifications = dataStream.readBoolean();
            MekanismConfig.general.controlCircuitOreDict = dataStream.readBoolean();
            MekanismConfig.general.logPackets = dataStream.readBoolean();
            MekanismConfig.general.dynamicTankEasterEgg = dataStream.readBoolean();
            MekanismConfig.general.voiceServerEnabled = dataStream.readBoolean();
            MekanismConfig.general.cardboardSpawners = dataStream.readBoolean();
            MekanismConfig.general.creativeOverrideElectricChest = dataStream.readBoolean();
            MekanismConfig.general.spawnBabySkeletons = dataStream.readBoolean();
            MekanismConfig.general.obsidianTNTDelay = dataStream.readInt();
            MekanismConfig.general.obsidianTNTBlastRadius = dataStream.readInt();
            MekanismConfig.general.UPDATE_DELAY = dataStream.readInt();
            MekanismConfig.general.FROM_IC2 = dataStream.readDouble();
            MekanismConfig.general.TO_IC2 = dataStream.readDouble();
            MekanismConfig.general.FROM_TE = dataStream.readDouble();
            MekanismConfig.general.TO_TE = dataStream.readDouble();
            MekanismConfig.general.FROM_H2 = dataStream.readDouble();
            MekanismConfig.general.ETHENE_BURN_TIME = dataStream.readInt();
            MekanismConfig.general.ENERGY_PER_REDSTONE = dataStream.readDouble();
            MekanismConfig.general.DISASSEMBLER_USAGE = dataStream.readDouble();
            MekanismConfig.general.VOICE_PORT = dataStream.readInt();
            MekanismConfig.general.maxUpgradeMultiplier = dataStream.readInt();
            MekanismConfig.general.activeType = UnitDisplayUtils.EnergyType.values()[dataStream.readInt()];
            MekanismConfig.general.minerSilkMultiplier = dataStream.readDouble();
            MekanismConfig.general.blacklistIC2 = dataStream.readBoolean();
            MekanismConfig.general.blacklistRF = dataStream.readBoolean();
            MekanismConfig.general.armoredJetpackDamageRatio = dataStream.readDouble();
            MekanismConfig.general.armoredJetpackDamageMax = dataStream.readInt();
            MekanismConfig.general.aestheticWorldDamage = dataStream.readBoolean();
            MekanismConfig.general.opsBypassRestrictions = dataStream.readBoolean();
            MekanismConfig.general.solarEvaporationSpeed = dataStream.readDouble();
            for (BlockMachine.MachineType type : BlockMachine.MachineType.getValidMachines()) {
                MekanismConfig.machines.setEntry(type.name, dataStream.readBoolean());
            }
            MekanismConfig.usage.enrichmentChamberUsage = dataStream.readDouble();
            MekanismConfig.usage.osmiumCompressorUsage = dataStream.readDouble();
            MekanismConfig.usage.combinerUsage = dataStream.readDouble();
            MekanismConfig.usage.crusherUsage = dataStream.readDouble();
            MekanismConfig.usage.factoryUsage = dataStream.readDouble();
            MekanismConfig.usage.metallurgicInfuserUsage = dataStream.readDouble();
            MekanismConfig.usage.purificationChamberUsage = dataStream.readDouble();
            MekanismConfig.usage.energizedSmelterUsage = dataStream.readDouble();
            MekanismConfig.usage.digitalMinerUsage = dataStream.readDouble();
            MekanismConfig.usage.electricPumpUsage = dataStream.readDouble();
            MekanismConfig.usage.rotaryCondensentratorUsage = dataStream.readDouble();
            MekanismConfig.usage.oxidationChamberUsage = dataStream.readDouble();
            MekanismConfig.usage.chemicalInfuserUsage = dataStream.readDouble();
            MekanismConfig.usage.chemicalInjectionChamberUsage = dataStream.readDouble();
            MekanismConfig.usage.precisionSawmillUsage = dataStream.readDouble();
            MekanismConfig.usage.chemicalDissolutionChamberUsage = dataStream.readDouble();
            MekanismConfig.usage.chemicalWasherUsage = dataStream.readDouble();
            MekanismConfig.usage.chemicalCrystallizerUsage = dataStream.readDouble();
            MekanismConfig.usage.seismicVibratorUsage = dataStream.readDouble();
            MekanismConfig.usage.fluidicPlenisherUsage = dataStream.readDouble();
            MekanismConfig.usage.gasCentrifugeUsage = dataStream.readDouble();
            MekanismConfig.usage.heavyWaterElectrolysisUsage = dataStream.readDouble();
            Tier.readConfig(dataStream);
            try {
                for (IModule module : Mekanism.modulesLoaded) {
                    module.readConfig(dataStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Mekanism.proxy.onConfigSync(true);
        }
    }
}

