/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentAdvancedUpgrade;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAdvancedElectricMachine<RECIPE extends AdvancedMachineRecipe<RECIPE>>
extends TileEntityBasicMachine<AdvancedMachineInput, ItemStackOutput, RECIPE>
implements IGasHandler,
ITubeConnection {
    public int BASE_SECONDARY_ENERGY_PER_TICK;
    public double secondaryEnergyPerTick;
    public int secondaryEnergyThisTick;
    public static int MAX_GAS = 210;
    public GasTank gasTank;
    public Gas prevGas;

    public TileEntityAdvancedElectricMachine(String soundPath, String name, double perTick, int secondaryPerTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiAdvancedMachine.png"), perTick, ticksRequired, maxEnergy);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{3}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 4, 0, 3});
        this.configComponent.setInputEnergyConfig();
        this.gasTank = new GasTank(MAX_GAS);
        this.inventory = new ItemStack[5];
        this.BASE_SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.secondaryEnergyPerTick = secondaryPerTick;
        this.upgradeComponent = this.upgradeableSecondaryEfficiency() ? new TileComponentAdvancedUpgrade(this, 4) : new TileComponentUpgrade(this, 4);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
    }

    public void upgrade(IFactory.RecipeType type) {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, MekanismBlocks.MachineBlock, 5, 3);
        TileEntityFactory factory = (TileEntityFactory)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.ic2Registered = this.ic2Registered;
        factory.soundURL = this.soundURL;
        factory.progress[0] = this.operatingTicks;
        factory.updateDelay = this.updateDelay;
        factory.isActive = this.isActive;
        factory.clientActive = this.clientActive;
        factory.controlType = this.controlType;
        factory.prevEnergy = this.prevEnergy;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.upgradeComponent.setUpgradeSlot(0);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(4));
        factory.recipeType = type;
        factory.upgradeComponent.setSupported(Upgrade.GAS, type.fuelEnergyUpgrades());
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.inventory[5] = this.inventory[0];
        factory.inventory[4] = this.inventory[1];
        factory.inventory[8] = this.inventory[2];
        factory.inventory[1] = this.inventory[3];
        factory.inventory[0] = this.inventory[4];
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(factory), factory.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(factory)));
    }

    public abstract GasStack getItemGas(ItemStack var1);

    public abstract boolean isValidGas(Gas var1);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            this.handleSecondaryFuel();
            boolean inactive = false;
            MachineRecipe recipe = this.getRecipe();
            int n = this.secondaryEnergyThisTick = this.useStatisticalMechanics() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
                this.gasTank.draw(this.secondaryEnergyThisTick, true);
                this.electricityStored -= this.energyPerTick;
            } else {
                inactive = true;
                this.setActive(false);
            }
            if (inactive && this.getRecipe() == null) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.gasTank.getGasType() != null && this.gasTank.getStored() != 0) {
                this.prevGas = this.gasTank.getGasType();
            }
        }
    }

    public void handleSecondaryFuel() {
        if (this.inventory[1] != null && this.gasTank.getNeeded() > 0) {
            GasStack stack = this.getItemGas(this.inventory[1]);
            int gasNeeded = this.gasTank.getNeeded();
            if (stack != null && this.gasTank.canReceive(stack.getGas()) && gasNeeded >= stack.amount) {
                this.gasTank.receive(stack, true);
                --this.inventory[1].field_77994_a;
                if (this.inventory[1].field_77994_a == 0) {
                    this.inventory[1] = null;
                }
            }
        }
    }

    public boolean upgradeableSecondaryEfficiency() {
        return false;
    }

    public boolean useStatisticalMechanics() {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 4) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            for (AdvancedMachineInput input : this.getRecipes().keySet()) {
                if (!input.itemStack.func_77969_a(itemstack)) continue;
                return true;
            }
        } else {
            if (slotID == 3) {
                return ChargeUtils.canBeDischarged(itemstack);
            }
            if (slotID == 1) {
                return this.getItemGas(itemstack) != null;
            }
        }
        return false;
    }

    @Override
    public AdvancedMachineInput getInput() {
        return new AdvancedMachineInput(this.inventory[0], this.prevGas);
    }

    @Override
    public RECIPE getRecipe() {
        AdvancedMachineInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((AdvancedMachineInput)((AdvancedMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((AdvancedMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((AdvancedMachineRecipe)recipe).operate(this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((AdvancedMachineRecipe)recipe).canOperate(this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.gasTank.setMaxGas(MAX_GAS);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return false;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.SPEED || this.upgradeableSecondaryEfficiency() && upgrade == Upgrade.GAS) {
            this.secondaryEnergyPerTick = MekanismUtils.getSecondaryEnergyPerTickMean(this, this.BASE_SECONDARY_ENERGY_PER_TICK);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.gasTank.getStored()};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate(RecipeHandler.getRecipe(this.getInput(), this.getRecipes()))};
            }
            case 6: {
                return new Object[]{this.maxEnergy};
            }
            case 7: {
                return new Object[]{this.maxEnergy - this.getEnergy()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

