/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.common.content.boiler.BoilerSteamTank;
import mekanism.common.content.boiler.BoilerTank;
import mekanism.common.content.boiler.BoilerWaterTank;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.tile.TileEntityBoiler;
import mekanism.common.util.PipeUtils;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBoilerValve
extends TileEntityBoiler
implements IFluidHandler {
    public BoilerTank waterTank = new BoilerWaterTank(this);
    public BoilerTank steamTank = new BoilerSteamTank(this);

    public TileEntityBoilerValve() {
        super("Boiler Valve");
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[2];
            fluidTankInfoArray2[0] = this.waterTank.getInfo();
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[1] = this.steamTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).steamStored != null && resource.getFluid() == ((SynchronizedBoilerData)this.structure).steamStored.getFluid()) {
            return this.steamTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.structure != null) {
            return this.steamTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }
}

