/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITransporterTile;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MinerUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityDigitalMiner
extends TileEntityElectricBlock
implements IPeripheral,
IUpgradeTile,
IRedstoneControl,
IActiveState,
ISustainedData,
IAdvancedBoundingBlock {
    public static int[] EJECT_INV;
    public Map<Chunk3D, BitSet> oresToMine = new HashMap<Chunk3D, BitSet>();
    public Map<Integer, MinerFilter> replaceMap = new HashMap<Integer, MinerFilter>();
    public HashList<MinerFilter> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    public final double BASE_ENERGY_USAGE = MekanismConfig.usage.digitalMinerUsage;
    public double energyUsage = MekanismConfig.usage.digitalMinerUsage;
    public int radius;
    public boolean inverse;
    public int minY = 0;
    public int maxY = 60;
    public boolean doEject = false;
    public boolean doPull = false;
    public ItemStack missingStack = null;
    public int BASE_DELAY;
    public int delay;
    public int delayLength = this.BASE_DELAY = 80;
    public int clientToMine;
    public boolean isActive;
    public boolean clientActive;
    public boolean silkTouch;
    public boolean running;
    public double prevEnergy;
    public int delayTicks;
    public boolean initCalc = false;
    public int numPowering;
    public boolean clientRendering = false;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 28);
    public String[] names = new String[]{"setRadius", "setMin", "setMax", "addFilter", "removeFilter", "addOreFilter", "removeOreFilter", "reset", "start", "stop"};

    public TileEntityDigitalMiner() {
        super("DigitalMiner", BlockMachine.MachineType.DIGITAL_MINER.baseEnergy);
        this.inventory = new ItemStack[29];
        this.radius = 10;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getActive()) {
            for (EntityPlayer player : (HashSet)this.playersUsing.clone()) {
                if (!(player.field_71070_bA instanceof ContainerNull) && !(player.field_71070_bA instanceof ContainerFilter)) continue;
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.initCalc) {
                if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                    boolean prevRunning = this.running;
                    this.reset();
                    this.start();
                    this.running = prevRunning;
                }
                this.initCalc = true;
            }
            ChargeUtils.discharge(27, this);
            if (MekanismUtils.canFunction(this) && this.running && this.getEnergy() >= this.getPerTick() && this.searcher.state == ThreadMinerSearch.State.FINISHED && this.oresToMine.size() > 0) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.setEnergy(this.getEnergy() - this.getPerTick());
                if (this.delay == 0) {
                    HashSet<Chunk3D> toRemove = new HashSet<Chunk3D>();
                    boolean did = false;
                    for (Chunk3D chunk : this.oresToMine.keySet()) {
                        block31: {
                            int meta;
                            Block block;
                            Coord4D coord;
                            int index;
                            BitSet set = this.oresToMine.get(chunk);
                            int next = 0;
                            while (true) {
                                index = set.nextSetBit(next);
                                coord = this.getCoordFromIndex(index);
                                if (index == -1) {
                                    toRemove.add(chunk);
                                    break block31;
                                }
                                if (!coord.exists(this.field_145850_b)) {
                                    set.clear(index);
                                    if (set.cardinality() == 0) {
                                        toRemove.add(chunk);
                                    }
                                    next = index + 1;
                                    continue;
                                }
                                block = coord.getBlock((IBlockAccess)this.field_145850_b);
                                meta = coord.getMetadata((IBlockAccess)this.field_145850_b);
                                if (block == null || coord.isAirBlock((IBlockAccess)this.field_145850_b)) {
                                    set.clear(index);
                                    if (set.cardinality() == 0) {
                                        toRemove.add(chunk);
                                    }
                                    next = index + 1;
                                    continue;
                                }
                                boolean hasFilter = false;
                                for (MinerFilter filter : this.filters) {
                                    if (!filter.canFilter(new ItemStack(block, 1, meta))) continue;
                                    hasFilter = true;
                                    break;
                                }
                                if (!(this.inverse ? hasFilter : !hasFilter)) break;
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    toRemove.add(chunk);
                                    break block31;
                                }
                                next = index + 1;
                            }
                            List<ItemStack> drops = MinerUtils.getDrops(this.field_145850_b, coord, this.silkTouch);
                            if (this.canInsert(drops) && this.setReplace(coord, index)) {
                                did = true;
                                this.add(drops);
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    toRemove.add(chunk);
                                }
                                this.field_145850_b.func_72889_a(null, 2001, coord.xCoord, coord.yCoord, coord.zCoord, Block.func_149682_b((Block)block) + (meta << 12));
                                this.missingStack = null;
                            }
                        }
                        if (!did) continue;
                        break;
                    }
                    for (Chunk3D chunk : toRemove) {
                        this.oresToMine.remove(chunk);
                    }
                    this.delay = this.getDelay();
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.doEject && this.delayTicks == 0 && this.getTopEject(false, null) != null && this.getEjectInv() != null && this.getEjectTile() != null) {
                if (this.getEjectInv() instanceof IInventory) {
                    ItemStack remains = InventoryUtils.putStackInInventory((IInventory)this.getEjectInv(), this.getTopEject(false, null), ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), false);
                    this.getTopEject(true, remains);
                } else if (this.getEjectInv() instanceof ITransporterTile) {
                    ItemStack rejected = TransporterUtils.insert(this.getEjectTile(), ((ITransporterTile)this.getEjectInv()).getTransmitter(), this.getTopEject(false, null), null, true, 0);
                    if (TransporterManager.didEmit(this.getTopEject(false, null), rejected)) {
                        this.getTopEject(true, rejected);
                    }
                }
                this.delayTicks = 10;
            } else if (this.delayTicks > 0) {
                --this.delayTicks;
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getSmallPacket(new ArrayList())), (EntityPlayerMP)player);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public double getPerTick() {
        double ret = this.energyUsage;
        if (this.silkTouch) {
            ret *= 6.0;
        }
        int baseRad = Math.max(this.radius - 10, 0);
        ret *= (double)(1.0f + (float)baseRad / 22.0f);
        int baseHeight = Math.max(this.maxY - this.minY - 60, 0);
        return ret *= (double)(1.0f + (float)baseHeight / 195.0f);
    }

    public int getDelay() {
        return this.delayLength;
    }

    public boolean setReplace(Coord4D obj, int index) {
        Block block = obj.getBlock((IBlockAccess)this.field_145850_b);
        int meta = obj.getMetadata((IBlockAccess)this.field_145850_b);
        EntityPlayer dummy = (EntityPlayer)Mekanism.proxy.getDummyPlayer((WorldServer)this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord).get();
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(obj.xCoord, obj.yCoord, obj.zCoord, this.field_145850_b, block, meta, dummy);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            ItemStack stack = this.getReplace(index);
            if (stack != null) {
                this.field_145850_b.func_147465_d(obj.xCoord, obj.yCoord, obj.zCoord, Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 3);
                if (obj.getBlock((IBlockAccess)this.field_145850_b) != null && !obj.getBlock((IBlockAccess)this.field_145850_b).func_149718_j(this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord)) {
                    obj.getBlock((IBlockAccess)this.field_145850_b).func_149697_b(this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord, obj.getMetadata((IBlockAccess)this.field_145850_b), 1);
                    this.field_145850_b.func_147468_f(obj.xCoord, obj.yCoord, obj.zCoord);
                }
                return true;
            }
            MinerFilter filter = this.replaceMap.get(index);
            if (filter == null || filter.replaceStack == null || !filter.requireStack) {
                this.field_145850_b.func_147468_f(obj.xCoord, obj.yCoord, obj.zCoord);
                return true;
            }
            this.missingStack = filter.replaceStack;
            return false;
        }
        return false;
    }

    public ItemStack getReplace(int index) {
        InvStack stack;
        MinerFilter filter = this.replaceMap.get(index);
        if (filter == null || filter.replaceStack == null) {
            return null;
        }
        for (int i = 0; i < 27; ++i) {
            if (this.inventory[i] == null || !this.inventory[i].func_77969_a(filter.replaceStack)) continue;
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return MekanismUtils.size(filter.replaceStack, 1);
        }
        if (this.doPull && this.getPullInv() instanceof IInventory && (stack = InventoryUtils.takeDefinedItem((IInventory)this.getPullInv(), 1, filter.replaceStack.func_77946_l(), 1, 1)) != null) {
            stack.use();
            return MekanismUtils.size(filter.replaceStack, 1);
        }
        return null;
    }

    public ItemStack[] copy(ItemStack[] stacks) {
        ItemStack[] toReturn = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            toReturn[i] = stacks[i] != null ? stacks[i].func_77946_l() : null;
        }
        return toReturn;
    }

    public ItemStack getTopEject(boolean remove, ItemStack reject) {
        for (int i = 26; i >= 0; --i) {
            ItemStack stack = this.inventory[i];
            if (stack == null || this.isReplaceStack(stack)) continue;
            if (remove) {
                this.inventory[i] = reject;
            }
            return stack;
        }
        return null;
    }

    public boolean canInsert(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return true;
        }
        ItemStack[] testInv = this.copy(this.inventory);
        int added = 0;
        block0: for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            for (int i = 0; i < 27; ++i) {
                if (testInv[i] != null && testInv[i].func_77973_b() == null) {
                    testInv[i] = null;
                }
                if (testInv[i] == null) {
                    testInv[i] = stack;
                    ++added;
                    continue block0;
                }
                if (!testInv[i].func_77969_a(stack) || testInv[i].field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
                testInv[i].field_77994_a += stack.field_77994_a;
                ++added;
                continue block0;
            }
        }
        return added == stacks.size();
    }

    public TileEntity getPullInv() {
        return Coord4D.get(this).translate(0, 2, 0).getTileEntity((IBlockAccess)this.field_145850_b);
    }

    public TileEntity getEjectInv() {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return new Coord4D(this.field_145851_c + side.offsetX * 2, this.field_145848_d + 1, this.field_145849_e + side.offsetZ * 2, this.field_145850_b.field_73011_w.field_76574_g).getTileEntity((IBlockAccess)this.field_145850_b);
    }

    public void add(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        block0: for (ItemStack stack : stacks) {
            for (int i = 0; i < 27; ++i) {
                if (this.inventory[i] == null) {
                    this.inventory[i] = stack;
                    continue block0;
                }
                if (!this.inventory[i].func_77969_a(stack) || this.inventory[i].field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
                this.inventory[i].field_77994_a += stack.field_77994_a;
                continue block0;
            }
        }
    }

    public void start() {
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            this.searcher.start();
        }
        this.running = true;
        MekanismUtils.saveChunk(this);
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
        }
        MekanismUtils.saveChunk(this);
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.oresToMine.clear();
        this.replaceMap.clear();
        this.missingStack = null;
        MekanismUtils.saveChunk(this);
    }

    public boolean isReplaceStack(ItemStack stack) {
        for (MinerFilter filter : this.filters) {
            if (filter.replaceStack == null || !filter.replaceStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        int size = 0;
        for (Chunk3D chunk : this.oresToMine.keySet()) {
            size += this.oresToMine.get(chunk).cardinality();
        }
        return size;
    }

    @Override
    public void func_70295_k_() {
        super.func_70295_k_();
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.radius = nbtTags.func_74762_e("radius");
        this.minY = nbtTags.func_74762_e("minY");
        this.maxY = nbtTags.func_74762_e("maxY");
        this.doEject = nbtTags.func_74767_n("doEject");
        this.doPull = nbtTags.func_74767_n("doPull");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.running = nbtTags.func_74767_n("running");
        this.delay = nbtTags.func_74762_e("delay");
        this.silkTouch = nbtTags.func_74767_n("silkTouch");
        this.numPowering = nbtTags.func_74762_e("numPowering");
        this.searcher.state = ThreadMinerSearch.State.values()[nbtTags.func_74762_e("state")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inverse = nbtTags.func_74767_n("inverse");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.reset();
        }
        nbtTags.func_74768_a("radius", this.radius);
        nbtTags.func_74768_a("minY", this.minY);
        nbtTags.func_74768_a("maxY", this.maxY);
        nbtTags.func_74757_a("doEject", this.doEject);
        nbtTags.func_74757_a("doPull", this.doPull);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74757_a("running", this.running);
        nbtTags.func_74768_a("delay", this.delay);
        nbtTags.func_74757_a("silkTouch", this.silkTouch);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("state", this.searcher.state.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.doEject = !this.doEject;
            } else if (type == 1) {
                this.doPull = !this.doPull;
            } else if (type != 2) {
                int filterIndex;
                if (type == 3) {
                    this.start();
                } else if (type == 4) {
                    this.stop();
                } else if (type == 5) {
                    this.reset();
                } else if (type == 6) {
                    this.radius = dataStream.readInt();
                } else if (type == 7) {
                    this.minY = dataStream.readInt();
                } else if (type == 8) {
                    this.maxY = dataStream.readInt();
                } else if (type == 9) {
                    this.silkTouch = !this.silkTouch;
                } else if (type == 10) {
                    this.inverse = !this.inverse;
                } else if (type == 11) {
                    filterIndex = dataStream.readInt();
                    this.filters.swap(filterIndex, filterIndex - 1);
                    this.func_70295_k_();
                } else if (type == 12) {
                    filterIndex = dataStream.readInt();
                    this.filters.swap(filterIndex, filterIndex + 1);
                    this.func_70295_k_();
                }
            }
            MekanismUtils.saveChunk(this);
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new ArrayList())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            this.radius = dataStream.readInt();
            this.minY = dataStream.readInt();
            this.maxY = dataStream.readInt();
            this.doEject = dataStream.readBoolean();
            this.doPull = dataStream.readBoolean();
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.silkTouch = dataStream.readBoolean();
            this.numPowering = dataStream.readInt();
            this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
            this.clientToMine = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.inverse = dataStream.readBoolean();
            this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : null;
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(MinerFilter.readFromPacket(dataStream));
            }
        } else if (type == 1) {
            this.radius = dataStream.readInt();
            this.minY = dataStream.readInt();
            this.maxY = dataStream.readInt();
            this.doEject = dataStream.readBoolean();
            this.doPull = dataStream.readBoolean();
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.silkTouch = dataStream.readBoolean();
            this.numPowering = dataStream.readInt();
            this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
            this.clientToMine = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.inverse = dataStream.readBoolean();
            this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : null;
        } else if (type == 2) {
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(MinerFilter.readFromPacket(dataStream));
            }
        } else if (type == 3) {
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.clientToMine = dataStream.readInt();
            this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : null;
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        if (this.missingStack != null) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77960_j());
        } else {
            data.add(false);
        }
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getSmallPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(3);
        data.add(this.isActive);
        data.add(this.running);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        if (this.missingStack != null) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77960_j());
        } else {
            data.add(false);
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        if (this.missingStack != null) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77960_j());
        } else {
            data.add(false);
        }
        return data;
    }

    public ArrayList getFilterPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.maxY - this.minY + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public Coord4D getStartingCoord() {
        return new Coord4D(this.field_145851_c - this.radius, this.minY, this.field_145849_e - this.radius, this.field_145850_b.field_73011_w.field_76574_g);
    }

    public Coord4D getCoordFromIndex(int index) {
        int diameter = this.getDiameter();
        Coord4D start = this.getStartingCoord();
        int x = start.xCoord + index % diameter;
        int z = start.zCoord + index / diameter % diameter;
        int y = start.yCoord + index / diameter / diameter;
        return new Coord4D(x, y, z, this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onPlace() {
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int y = this.field_145848_d; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e) continue;
                    MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, x, y, z, Coord4D.get(this));
                    this.field_145850_b.func_147453_f(x, y, z, this.func_145838_q());
                }
            }
        }
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void onBreak() {
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int y = this.field_145848_d; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return InventoryUtils.EMPTY;
    }

    public TileEntity getEjectTile() {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return new Coord4D(this.field_145851_c + side.offsetX, this.field_145848_d + 1, this.field_145849_e + side.offsetZ, this.field_145850_b.field_73011_w.field_76574_g).getTileEntity((IBlockAccess)this.field_145850_b);
    }

    @Override
    public int[] getBoundSlots(Coord4D location, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = Coord4D.get(this).translate(dir.offsetX, 1, dir.offsetZ);
        Coord4D pull = Coord4D.get(this).translate(0, 1, 0);
        if (location.equals(eject) && side == dir.ordinal() || location.equals(pull) && side == 1) {
            if (EJECT_INV == null) {
                EJECT_INV = new int[27];
                for (int i = 0; i < EJECT_INV.length; ++i) {
                    TileEntityDigitalMiner.EJECT_INV[i] = i;
                }
            }
            return EJECT_INV;
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean canBoundInsert(Coord4D location, int i, ItemStack itemstack) {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = Coord4D.get(this).translate(side.offsetX, 1, side.offsetZ);
        Coord4D pull = Coord4D.get(this).translate(0, 1, 0);
        if (location.equals(eject)) {
            return false;
        }
        return location.equals(pull) && itemstack != null && this.isReplaceStack(itemstack);
    }

    @Override
    public boolean canBoundExtract(Coord4D location, int i, ItemStack itemstack, int j) {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = new Coord4D(this.field_145851_c + side.offsetX, this.field_145848_d + 1, this.field_145849_e + side.offsetZ, this.field_145850_b.field_73011_w.field_76574_g);
        Coord4D pull = new Coord4D(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
        if (location.equals(eject)) {
            return itemstack == null || !this.isReplaceStack(itemstack);
        }
        if (location.equals(pull)) {
            return false;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.names;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (arguments.length > 0) {
            int num = 0;
            if (arguments[0] instanceof Double) {
                num = ((Double)arguments[0]).intValue();
            } else if (arguments[0] instanceof String && method != 6 && method != 7) {
                num = Integer.parseInt((String)arguments[0]);
            }
            if (num != 0) {
                MinerFilter filter;
                if (method == 0) {
                    this.radius = num;
                } else if (method == 1) {
                    this.minY = num;
                } else if (method == 2) {
                    this.maxY = num;
                } else if (method == 3) {
                    int meta = 0;
                    if (arguments.length > 1) {
                        if (arguments[1] instanceof Double) {
                            meta = ((Double)arguments[1]).intValue();
                        } else if (arguments[1] instanceof String) {
                            meta = Integer.parseInt((String)arguments[1]);
                        }
                    }
                    this.filters.add(new MItemStackFilter(new ItemStack(Item.func_150899_d((int)num), 1, meta)));
                } else if (method == 4) {
                    Iterator iter = this.filters.iterator();
                    while (iter.hasNext()) {
                        filter = (MinerFilter)iter.next();
                        if (!(filter instanceof MItemStackFilter) || MekanismUtils.getID(((MItemStackFilter)filter).itemType) != num) continue;
                        iter.remove();
                    }
                } else if (method == 5) {
                    String ore = (String)arguments[0];
                    filter = new MOreDictFilter();
                    ((MOreDictFilter)filter).oreDictName = ore;
                    this.filters.add(filter);
                } else if (method == 6) {
                    String ore = (String)arguments[0];
                    Iterator iter = this.filters.iterator();
                    while (iter.hasNext()) {
                        MinerFilter filter2 = (MinerFilter)iter.next();
                        if (!(filter2 instanceof MOreDictFilter) || ((MOreDictFilter)filter2).oreDictName != ore) continue;
                        iter.remove();
                    }
                } else if (method == 7) {
                    this.reset();
                } else if (method == 8) {
                    this.start();
                } else if (method == 9) {
                    this.stop();
                }
            }
        }
        for (EntityPlayer player : this.playersUsing) {
            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new ArrayList())), (EntityPlayerMP)player);
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    public NBTTagCompound getFilterData(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("radius", this.radius);
        nbtTags.func_74768_a("minY", this.minY);
        nbtTags.func_74768_a("maxY", this.maxY);
        nbtTags.func_74757_a("doEject", this.doEject);
        nbtTags.func_74757_a("doPull", this.doPull);
        nbtTags.func_74757_a("silkTouch", this.silkTouch);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setFilterData(NBTTagCompound nbtTags) {
        this.radius = nbtTags.func_74762_e("radius");
        this.minY = nbtTags.func_74762_e("minY");
        this.maxY = nbtTags.func_74762_e("maxY");
        this.doEject = nbtTags.func_74767_n("doEject");
        this.doPull = nbtTags.func_74767_n("doPull");
        this.silkTouch = nbtTags.func_74767_n("silkTouch");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inverse = nbtTags.func_74767_n("inverse");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return "tooltip.filterCard.digitalMiner";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        itemStack.field_77990_d.func_74757_a("hasMinerConfig", true);
        itemStack.field_77990_d.func_74768_a("radius", this.radius);
        itemStack.field_77990_d.func_74768_a("minY", this.minY);
        itemStack.field_77990_d.func_74768_a("maxY", this.maxY);
        itemStack.field_77990_d.func_74757_a("doEject", this.doEject);
        itemStack.field_77990_d.func_74757_a("doPull", this.doPull);
        itemStack.field_77990_d.func_74757_a("silkTouch", this.silkTouch);
        itemStack.field_77990_d.func_74757_a("inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            itemStack.field_77990_d.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (itemStack.field_77990_d.func_74764_b("hasMinerConfig")) {
            this.radius = itemStack.field_77990_d.func_74762_e("radius");
            this.minY = itemStack.field_77990_d.func_74762_e("minY");
            this.maxY = itemStack.field_77990_d.func_74762_e("maxY");
            this.doEject = itemStack.field_77990_d.func_74767_n("doEject");
            this.doPull = itemStack.field_77990_d.func_74767_n("doPull");
            this.silkTouch = itemStack.field_77990_d.func_74767_n("silkTouch");
            this.inverse = itemStack.field_77990_d.func_74767_n("inverse");
            if (itemStack.field_77990_d.func_74764_b("filters")) {
                NBTTagList tagList = itemStack.field_77990_d.func_150295_c("filters", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
                }
            }
        }
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.delayLength = MekanismUtils.getTicks(this, this.BASE_DELAY);
            }
            case ENERGY: {
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            }
        }
    }
}

