/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.FluidContainerUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityDynamicTank
extends TileEntityMultiblock<SynchronizedTankData>
implements IFluidContainerManager {
    public Set<SynchronizedTankData.ValveData> valveViewing = new HashSet<SynchronizedTankData.ValveData>();
    public int clientCapacity;
    public float prevScale;

    public TileEntityDynamicTank() {
        super("DynamicTank");
    }

    public TileEntityDynamicTank(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevScale - (targetScale = (float)(((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : 0) / (float)this.clientCapacity)) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData data : this.valveViewing) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedTankData)this.structure).fluidStored != null && ((SynchronizedTankData)this.structure).fluidStored.amount <= 0) {
                ((SynchronizedTankData)this.structure).fluidStored = null;
                this.func_70296_d();
            }
            if (this.isRendering) {
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedTankData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                if (needsValveUpdate || ((SynchronizedTankData)this.structure).needsRenderUpdate()) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedTankData)this.structure).prevFluid = ((SynchronizedTankData)this.structure).fluidStored;
            }
            this.manageInventory();
        }
    }

    public void manageInventory() {
        int max = ((SynchronizedTankData)this.structure).volume * 16000;
        if (((SynchronizedTankData)this.structure).inventory[0] != null) {
            if (((SynchronizedTankData)this.structure).inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                if (((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.FILL && ((SynchronizedTankData)this.structure).fluidStored != null) {
                    int prev = ((SynchronizedTankData)this.structure).fluidStored.amount;
                    ((SynchronizedTankData)this.structure).fluidStored.amount -= FluidContainerUtils.insertFluid(((SynchronizedTankData)this.structure).fluidStored, ((SynchronizedTankData)this.structure).inventory[0]);
                    if ((prev == ((SynchronizedTankData)this.structure).fluidStored.amount || ((SynchronizedTankData)this.structure).fluidStored.amount == 0) && ((SynchronizedTankData)this.structure).inventory[1] == null) {
                        ((SynchronizedTankData)this.structure).inventory[1] = ((SynchronizedTankData)this.structure).inventory[0].func_77946_l();
                        ((SynchronizedTankData)this.structure).inventory[0] = null;
                        this.func_70296_d();
                    }
                    if (((SynchronizedTankData)this.structure).fluidStored.amount == 0) {
                        ((SynchronizedTankData)this.structure).fluidStored = null;
                    }
                } else if (((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.EMPTY) {
                    int newStored;
                    if (((SynchronizedTankData)this.structure).fluidStored != null) {
                        FluidStack received = FluidContainerUtils.extractFluid(max - ((SynchronizedTankData)this.structure).fluidStored.amount, ((SynchronizedTankData)this.structure).inventory[0], ((SynchronizedTankData)this.structure).fluidStored.getFluid());
                        if (received != null) {
                            ((SynchronizedTankData)this.structure).fluidStored.amount += received.amount;
                        }
                    } else {
                        ((SynchronizedTankData)this.structure).fluidStored = FluidContainerUtils.extractFluid(max, ((SynchronizedTankData)this.structure).inventory[0], null);
                    }
                    int n = newStored = ((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : 0;
                    if ((((IFluidContainerItem)((SynchronizedTankData)this.structure).inventory[0].func_77973_b()).getFluid(((SynchronizedTankData)this.structure).inventory[0]) == null || newStored == max) && ((SynchronizedTankData)this.structure).inventory[1] == null) {
                        ((SynchronizedTankData)this.structure).inventory[1] = ((SynchronizedTankData)this.structure).inventory[0].func_77946_l();
                        ((SynchronizedTankData)this.structure).inventory[0] = null;
                        this.func_70296_d();
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)((SynchronizedTankData)this.structure).inventory[0]) && (((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.BOTH || ((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.FILL)) {
                ItemStack filled;
                if (((SynchronizedTankData)this.structure).fluidStored != null && ((SynchronizedTankData)this.structure).fluidStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)((SynchronizedTankData)this.structure).fluidStored, (ItemStack)((SynchronizedTankData)this.structure).inventory[0])) != null && (((SynchronizedTankData)this.structure).inventory[1] == null || ((SynchronizedTankData)this.structure).inventory[1].func_77969_a(filled) && ((SynchronizedTankData)this.structure).inventory[1].field_77994_a + 1 <= filled.func_77976_d())) {
                    --((SynchronizedTankData)this.structure).inventory[0].field_77994_a;
                    if (((SynchronizedTankData)this.structure).inventory[0].field_77994_a <= 0) {
                        ((SynchronizedTankData)this.structure).inventory[0] = null;
                    }
                    if (((SynchronizedTankData)this.structure).inventory[1] == null) {
                        ((SynchronizedTankData)this.structure).inventory[1] = filled;
                    } else {
                        ++((SynchronizedTankData)this.structure).inventory[1].field_77994_a;
                    }
                    this.func_70296_d();
                    ((SynchronizedTankData)this.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                    if (((SynchronizedTankData)this.structure).fluidStored.amount == 0) {
                        ((SynchronizedTankData)this.structure).fluidStored = null;
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)((SynchronizedTankData)this.structure).inventory[0]) && (((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.BOTH || ((SynchronizedTankData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.EMPTY)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((SynchronizedTankData)this.structure).inventory[0]);
                if (((SynchronizedTankData)this.structure).fluidStored == null && itemFluid.amount <= max || ((SynchronizedTankData)this.structure).fluidStored.amount + itemFluid.amount <= max) {
                    if (((SynchronizedTankData)this.structure).fluidStored != null && !((SynchronizedTankData)this.structure).fluidStored.isFluidEqual(itemFluid)) {
                        return;
                    }
                    ItemStack containerItem = ((SynchronizedTankData)this.structure).inventory[0].func_77973_b().getContainerItem(((SynchronizedTankData)this.structure).inventory[0]);
                    boolean filled = false;
                    if (containerItem != null) {
                        if (((SynchronizedTankData)this.structure).inventory[1] == null || ((SynchronizedTankData)this.structure).inventory[1].func_77969_a(containerItem) && ((SynchronizedTankData)this.structure).inventory[1].field_77994_a + 1 <= containerItem.func_77976_d()) {
                            ((SynchronizedTankData)this.structure).inventory[0] = null;
                            if (((SynchronizedTankData)this.structure).inventory[1] == null) {
                                ((SynchronizedTankData)this.structure).inventory[1] = containerItem;
                            } else {
                                ++((SynchronizedTankData)this.structure).inventory[1].field_77994_a;
                            }
                            filled = true;
                        }
                    } else {
                        --((SynchronizedTankData)this.structure).inventory[0].field_77994_a;
                        if (((SynchronizedTankData)this.structure).inventory[0].field_77994_a == 0) {
                            ((SynchronizedTankData)this.structure).inventory[0] = null;
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (((SynchronizedTankData)this.structure).fluidStored == null) {
                            ((SynchronizedTankData)this.structure).fluidStored = itemFluid.copy();
                        } else {
                            ((SynchronizedTankData)this.structure).fluidStored.amount += itemFluid.amount;
                        }
                        this.func_70296_d();
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
        }
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData();
    }

    public TankCache getNewCache() {
        return new TankCache();
    }

    protected TankUpdateProtocol getProtocol() {
        return new TankUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedTankData)this.structure).volume * 16000);
            data.add(((SynchronizedTankData)this.structure).editMode.ordinal());
            if (((SynchronizedTankData)this.structure).fluidStored != null) {
                data.add(1);
                data.add(((SynchronizedTankData)this.structure).fluidStored.fluidID);
                data.add(((SynchronizedTankData)this.structure).fluidStored.amount);
            } else {
                data.add(0);
            }
            if (this.isRendering) {
                HashSet<SynchronizedTankData.ValveData> toSend = new HashSet<SynchronizedTankData.ValveData>();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedTankData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side.ordinal());
                }
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.clientHasStructure) {
            this.clientCapacity = dataStream.readInt();
            ((SynchronizedTankData)this.structure).editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            ((SynchronizedTankData)this.structure).fluidStored = dataStream.readInt() == 1 ? new FluidStack(dataStream.readInt(), dataStream.readInt()) : null;
            if (this.isRendering) {
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = ForgeDirection.getOrientation((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    public int getScaledFluidLevel(int i) {
        if (this.clientCapacity == 0 || ((SynchronizedTankData)this.structure).fluidStored == null) {
            return 0;
        }
        return ((SynchronizedTankData)this.structure).fluidStored.amount * i / this.clientCapacity;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        if (this.structure != null) {
            return ((SynchronizedTankData)this.structure).editMode;
        }
        return FluidContainerUtils.ContainerEditMode.BOTH;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        if (this.structure == null) {
            return;
        }
        ((SynchronizedTankData)this.structure).editMode = mode;
    }
}

